/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.retailprice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.drp.dpm.business.retailprice.RetailItemPriceHelper;

public class PriceDistributeBranchPlugin
extends AbstractFormPlugin {
    private static final String BRANCHLIST = "branchlist";
    private static final String BRANCH = "branch";
    private static final String HASDISTRIBUTED = "hasdistributed";
    private static final String PRICEENABLE = "priceenable";
    private static final String PKVALUE = "retailpriceid";
    private static final String OP_DISTRIBUTE = "distribute";
    private static final String OP_CANCELDISTRIBUTE = "canceldistribute";
    private static final String OPERATION = "operation";
    private static final String BTNOK = "btnok";
    private static final String CBTN = "cancelbtn";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BRANCHLIST});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String operation = this.getOperation();
        if (OP_DISTRIBUTE.equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CBTN});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object pkValue = this.getPkValue();
        List list = null;
        DynamicObjectCollection branchList = this.getModel().getEntryEntity(BRANCHLIST);
        list = OP_DISTRIBUTE.equals(this.getOperation()) ? RetailItemPriceHelper.getNotDistributedBranchList((Object)this.getPkValue()) : RetailItemPriceHelper.getDistributedBranchList((Object)this.getPkValue());
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject branch = branchList.addNew();
            branch.set(BRANCH, (Object)((DynamicObject)list.get(i)).getDynamicObject("pricebranch"));
            branch.set(HASDISTRIBUTED, ((DynamicObject)list.get(i)).get(HASDISTRIBUTED));
            branch.set(PRICEENABLE, ((DynamicObject)list.get(i)).get(PRICEENABLE));
            branch.set(PKVALUE, pkValue);
        }
    }

    private Object getPkValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return formShowParameter.getCustomParam("id");
    }

    private String getOperation() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam(OPERATION);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        Object pkValue = this.getPkValue();
        List<Object> branchIds = this.getSelectBranchList();
        if (branchIds.size() == 0) {
            this.getView().showErrorNotification("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6e20\u9053\u3002");
            return;
        }
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "distribute": {
                List dResults = RetailItemPriceHelper.distributeItemPriceToBranches((Object)pkValue, branchIds);
                this.getView().returnDataToParent((Object)dResults);
                this.getView().getParentView().updateView("userangeentity");
                this.getView().close();
                break;
            }
            case "canceldistribute": {
                List cdResults = RetailItemPriceHelper.cancelDistribute(branchIds, (Object)pkValue);
                this.getView().returnDataToParent((Object)cdResults);
                this.getView().getParentView().updateView("userangeentity");
                this.getView().close();
                break;
            }
        }
    }

    private List<Object> getSelectBranchList() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(BRANCHLIST);
        int[] selectedRows = entryGrid.getSelectRows();
        ArrayList<Object> selectList = new ArrayList<Object>(10);
        if (selectedRows != null && selectedRows.length > 0) {
            DynamicObjectCollection branchList = this.getModel().getEntryEntity(BRANCHLIST);
            for (int i = 0; i < selectedRows.length; ++i) {
                selectList.add(((DynamicObject)branchList.get(selectedRows[i])).getDynamicObject(BRANCH).getPkValue());
            }
        }
        return selectList;
    }
}

