/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.retailprice;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpm.common.util.CommonUtil;

public class RetailItemPriceListPlugin
extends AbstractListPlugin {
    private static final String OP_NEW = "new";
    private static final String OP_DISABLE = "disable";
    private static final String OP_ENABLE = "enable";
    private static final String TABNAME_HEADQUARTERS = "\u603b\u90e8\u5546\u54c1\u96f6\u552e\u4ef7\u76ee\u8868";
    private static final String TABNAME_BRANCHES = "\u95e8\u5e97\u5546\u54c1\u96f6\u552e\u4ef7\u76ee\u8868";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void setFilter(SetFilterEvent e) {
        String billTypeId = this.getBillTypeId();
        List filters = e.getCustomQFilters();
        filters.add(new QFilter("billtype", "=", (Object)billTypeId));
        e.setCustomQFilters(filters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "new": {
                args.setCancel(true);
                this.openAddFormByBillType();
                break;
            }
            case "disable": {
                break;
            }
        }
    }

    private void openAddFormByBillType() {
        String billType = this.getBillTypeId();
        BillShowParameter param = new BillShowParameter();
        param.setFormId("dpm_retailpricelist");
        param.setCustomParam("billtype", (Object)billType);
        param.setCustomParam("org", ((IListView)this.getView()).getSelectedMainOrgIds().get(0));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("920289759207803904".equalsIgnoreCase(billType)) {
            param.setCaption(TABNAME_BRANCHES);
        } else {
            param.setCaption(TABNAME_HEADQUARTERS);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if ("920289759207803904".equalsIgnoreCase(this.getBillTypeId())) {
            e.getParameter().setCaption(TABNAME_BRANCHES);
        } else {
            e.getParameter().setCaption(TABNAME_HEADQUARTERS);
            this.getView().setVisible(Boolean.FALSE, new String[]{"channel"});
        }
    }

    private String getBillTypeId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (String)parameter.getCustomParam("billtype");
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String opKey = eventArgs.getOperateKey();
        if (OP_ENABLE.equalsIgnoreCase(opKey) || OP_DISABLE.equalsIgnoreCase(opKey)) {
            Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
            IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"dpm_retailpricelist").getDataEntityType();
            DynamicObject[] entities = (DynamicObject[])BusinessDataServiceHelper.load((Object[])primaryKeyValues, (IDataEntityType)dataEntityType);
            DynamicObjectCollection entries = null;
            if (OP_DISABLE.equalsIgnoreCase(opKey)) {
                for (DynamicObject entity : entities) {
                    entries = entity.getDynamicObjectCollection("pricedetailentity");
                    entity.set(OP_ENABLE, (Object)"B");
                    entity.set("disabler", (Object)CommonUtil.getLoginUser());
                    entity.set("disabletime", (Object)TimeServiceHelper.now());
                    for (DynamicObject entry : entries) {
                        if (entry.getBoolean("priceisinvalid")) continue;
                        entry.set("priceisinvalid", (Object)Boolean.TRUE);
                        entry.set("disableopdate", (Object)TimeServiceHelper.now());
                        entry.set("disabloper", (Object)CommonUtil.getLoginUser());
                    }
                }
            } else {
                for (DynamicObject entity : entities) {
                    entity.set(OP_ENABLE, (Object)"A");
                    entity.set("disabler", null);
                    entity.set("disabletime", null);
                }
            }
            SaveServiceHelper.update((DynamicObject[])entities);
            this.getView().updateView();
            if (eventArgs.getOperationResult().isSuccess()) {
                this.getView().showSuccessNotification(eventArgs.getOperationResult().getMessage());
            }
        }
    }
}

