/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.retailprice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dpm.common.util.GoodsInfoUtil;
import kd.drp.dpm.common.util.PriceTypeUtil;
import kd.drp.dpm.formplugin.retailprice.RetailPriceBasePlugin;

public class RetailItemPricePlugin
extends RetailPriceBasePlugin {
    private static final String KEY_MDR_ITEM_BARCODE = "mdr_item_barcode";
    private boolean fromBarcode = false;
    private static boolean setTrue = true;
    private static boolean setFalse = true;
    private static Boolean PRICE_TYPE_VISIBLE = Boolean.TRUE;
    private static String[] PRICE_TYPES = new String[]{"rpcheckbox", "fpcheckbox", "upcheckbox", "mpcheckbox", "spcheckbox", "p1checkbox", "p2checkbox", "p3checkbox", "p4checkbox", "p5checkbox"};
    private static String SELECT_FIELDS = "id, currency.id, item.id, barcode";

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String billTypeId = this.getBillTypeId();
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (("save".equals(opKey) || "submit".equals(opKey)) && "920289759207803904".equalsIgnoreCase(billTypeId)) {
            this.setBranchRangeList();
        }
    }

    public void afterBindData(EventObject e) {
        this.setVisiblePriceType();
    }

    private void setVisiblePriceType() {
        List enablePriceTypes = PriceTypeUtil.getEnableRetailPriceTypeList();
        String checkBox = null;
        String enumType = null;
        ArrayList<String> visibleBox = new ArrayList<String>(PRICE_TYPES.length);
        for (DynamicObject dyObj : enablePriceTypes) {
            enumType = dyObj.getString("pricefield");
            checkBox = PriceTypeUtil.getCheckBoxByEnum((String)enumType);
            visibleBox.add(checkBox);
        }
        this.getView().setVisible(PRICE_TYPE_VISIBLE, visibleBox.toArray(new String[visibleBox.size()]));
        ArrayList<String> unVisibles = new ArrayList<String>(PRICE_TYPES.length);
        for (String unVisvible : PRICE_TYPES) {
            if (visibleBox.contains(unVisvible)) continue;
            unVisibles.add(unVisvible);
        }
        this.getView().setVisible(Boolean.valueOf(PRICE_TYPE_VISIBLE == false), unVisibles.toArray(new String[unVisibles.size()]));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        IDataModel model = this.getView().getModel();
        String propertyName = e.getProperty().getName();
        int rowIndex = changeSet[0].getRowIndex();
        switch (propertyName) {
            case "item": {
                DynamicObject goods = (DynamicObject)changeSet[0].getNewValue();
                this.setDefaultUnit(goods, rowIndex);
                this.setBarcodeByGoodsId(goods, rowIndex);
                break;
            }
            case "barcode": {
                DynamicObject barCode = (DynamicObject)changeSet[0].getNewValue();
                this.setGoodsIdByBarCode(barCode, rowIndex);
                break;
            }
            case "channel": {
                DynamicObject channel = (DynamicObject)this.getView().getModel().getValue("channel");
                if (channel != null) {
                    this.getView().getModel().setValue("currency", (Object)channel.getDynamicObject("currency"));
                    break;
                }
                this.getView().showTipNotification("\u6e20\u9053\u4e0d\u5141\u8bb8\u6e05\u7a7a");
                break;
            }
        }
    }

    private void setGoodsIdByBarCode(DynamicObject barCode, int index) {
        IDataModel model = this.getView().getModel();
        if (barCode != null && DynamicObjectUtils.getPkValue((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item")) != 0L) {
            this.fromBarcode = true;
            model.setValue("item", (Object)DynamicObjectUtils.getPkValue((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item")), index);
            model.setValue("retailprice", (Object)barCode.getBigDecimal("retailprice"), index);
        } else {
            model.setValue("item", null, index);
            model.setValue("retailprice", null, index);
        }
    }

    private void updateValue(String key, Object value, int index) {
        this.getView().getModel().beginInit();
        this.getView().getModel().setValue(key, value, index);
        this.getView().updateView(key, index);
        this.getView().getModel().endInit();
    }

    private DynamicObjectCollection getBarCodeByGoodsId(DynamicObject goods) {
        DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("channel");
        DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currency");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)currency);
        DynamicObject billType = (DynamicObject)this.getView().getModel().getValue("billtype");
        QFilter filter = "920045548189278208".equals(billType.getPkValue().toString()) ? GoodsInfoUtil.getBarCodeIdGoodsCur((long)goodsId, (long)currencyId) : GoodsInfoUtil.getBarCodeIdFilter((long)branchId, (long)goodsId, (long)currencyId);
        return QueryServiceHelper.query((String)KEY_MDR_ITEM_BARCODE, (String)"id,retailprice", (QFilter[])filter.toArray());
    }

    private void setBarcodeByGoodsId(DynamicObject goods, int index) {
        if (goods == null) {
            this.updateValue("barcode", null, index);
            this.updateValue("retailprice", null, index);
            return;
        }
        DynamicObjectCollection data = this.getBarCodeByGoodsId(goods);
        if (!this.fromBarcode) {
            if (data.size() == 1) {
                long barCodeId = ((DynamicObject)data.get(0)).getLong("id");
                this.updateValue("barcode", barCodeId, index);
                this.getView().getModel().setValue("retailprice", ((DynamicObject)data.get(0)).get("retailprice"), index);
                this.fromBarcode = false;
            } else {
                this.updateValue("barcode", null, index);
                this.getView().getModel().setValue("retailprice", null, index);
            }
        }
    }

    private void setBranchRangeList() {
        DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("channel");
        if (branch != null) {
            DynamicObjectCollection rangeList = this.getView().getModel().getEntryEntity("userangeentity");
            this.getView().getModel().deleteEntryData("userangeentity");
            DynamicObject rangeObject = new DynamicObject(rangeList.getDynamicObjectType());
            rangeObject.set("priceorg", (Object)branch.getDynamicObject("org"));
            rangeObject.set("pricebranch", (Object)branch);
            rangeObject.set("priceenable", (Object)setTrue);
            rangeObject.set("hasdistributed", (Object)setFalse);
            this.getView().getModel().createNewEntryRow("userangeentity", rangeObject);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        QFilter qFilter = null;
        DynamicObject saleBranch = null;
        String billType = ((DynamicObject)this.getView().getModel().getValue("billtype")).getPkValue().toString();
        switch (propertyName) {
            case "item": {
                saleBranch = (DynamicObject)this.getView().getModel().getValue("channel");
                if (StringUtils.equals((CharSequence)billType, (CharSequence)"920289759207803904") && this.checkBranchIsBlank(saleBranch)) {
                    event.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                qFilter = this.getGoodsInfoFilter(saleBranch, setTrue, billType, "item");
                break;
            }
            case "barcode": {
                saleBranch = (DynamicObject)this.getView().getModel().getValue("channel");
                if (StringUtils.equals((CharSequence)billType, (CharSequence)"920289759207803904") && this.checkBranchIsBlank(saleBranch)) {
                    event.setCancel(setTrue);
                    return;
                }
                DynamicObject goods = (DynamicObject)this.getView().getModel().getValue("item", event.getRow());
                if (goods == null) {
                    qFilter = this.getGoodsInfoFilter(saleBranch, setFalse, billType, "barcode");
                    break;
                }
                long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
                qFilter = this.getGoodsInfoFilter(saleBranch, goodsId, billType);
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"item") && StringUtils.equals((CharSequence)billType, (CharSequence)"920289759207803904")) {
            showParameter.setFormId("bos_listf7");
            showParameter.setCustomParam("isFromPos", (Object)"1");
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter getGoodsInfoFilter(DynamicObject saleBranch, boolean flag, String billType, String property) {
        if ("920289759207803904".equals(billType)) {
            DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currency");
            long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleBranch);
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)currency);
            if (flag) {
                return GoodsInfoUtil.getGoodsIdFilter((long)branchId, (long)currencyId);
            }
            return GoodsInfoUtil.getBarCodeIdFilter((long)branchId, (long)currencyId);
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("currency.id", "=", ((DynamicObject)this.getView().getModel().getValue("currency")).getPkValue());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)KEY_MDR_ITEM_BARCODE, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{filter});
        if ("item".equals(property)) {
            Set<Object> objects = this.setIdsFilter(dynamicObjects, "item.id");
            return new QFilter("id", "in", objects);
        }
        Set<Object> objects = this.setIdsFilter(dynamicObjects, "id");
        return filter.and(new QFilter("id", "in", objects));
    }

    private Set<Object> setIdsFilter(DynamicObjectCollection col, String key) {
        HashSet<Object> ids = new HashSet<Object>();
        for (DynamicObject obj : col) {
            ids.add(obj.get(key));
        }
        return ids;
    }

    private boolean checkBranchIsBlank(DynamicObject saleBranch) {
        if (saleBranch == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u6e20\u9053\u3002");
            return true;
        }
        return false;
    }

    private QFilter getGoodsInfoFilter(DynamicObject saleBranch, long goodsId, String billType) {
        if ("920289759207803904".equals(billType)) {
            DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currency");
            long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleBranch);
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)currency);
            return GoodsInfoUtil.getBarCodeIdFilter((long)branchId, (long)goodsId, (long)currencyId);
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("item.id", "=", (Object)goodsId);
        return filter;
    }

    private void setDefaultUnit(DynamicObject goods, int index) {
        long retailUnitId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"retailunit");
        this.getView().getModel().setValue("priceunit", (Object)(retailUnitId == 0L ? null : Long.valueOf(retailUnitId)), index);
    }
}

