/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.CustomerRangeUtil;
import kd.drp.dpm.common.ItemRangeUtil;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;

public class PromotionApi
extends MdrApi {
    public ApiResult queryPolicyByItem(Map<String, Object> data) {
        long ownerid = this.parseId(data.get("ownerid"));
        long customerid = this.parseId(data.get("customerid"));
        String datetime = this.parseDateTime(data.get("datetime"));
        long itemid = this.parseId(data.get("itemid").toString());
        long unitid = this.parseId(data.get("unitid").toString());
        long attrid = this.parseId(data.get("attrid"));
        ArrayList policyresult = new ArrayList();
        DynamicObjectCollection policys = QueryServiceHelper.query((String)"dpm_policy", (String)"id,starttime,endtime,number,name,customerrange.id,entryentity.conditionexp,description", (QFilter[])this.buildQFilters(ownerid, datetime));
        for (DynamicObject policy : policys) {
            if (!this.isInRange(policy, customerid) || !this.isPolicyHasItem(policy, itemid, unitid, attrid)) continue;
            HashMap<String, Object> policymap = new HashMap<String, Object>();
            policymap.put("id", policy.getString("id"));
            policymap.put("number", policy.get("number"));
            policymap.put("name", policy.get("name"));
            policymap.put("description", policy.get("description"));
            policymap.put("starttime", policy.getDate("starttime") == null ? 0L : policy.getDate("starttime").getTime());
            policymap.put("endtime", policy.getDate("endtime") == null ? 0L : policy.getDate("endtime").getTime());
            policyresult.add(policymap);
        }
        return ApiResult.success(policyresult);
    }

    private boolean isPolicyHasItem(DynamicObject policy, long itemid, long unitid, long attrid) {
        String[] conditionids = policy.getString("entryentity.conditionexp").split(",");
        if (conditionids.length == 0) {
            return false;
        }
        return this.isConditionHasItem(conditionids[0], itemid, unitid, attrid);
    }

    private boolean isConditionHasItem(String conditionid, long itemid, long unitid, long attrid) {
        DynamicObject condition = QueryServiceHelper.queryOne((String)"dpm_condition", (String)"conditiontype.number,item.id,unit.id,attr.id,itemrange.id", (QFilter[])new QFilter("id", "=", (Object)conditionid).toArray());
        String conditiontype = condition.getString("conditiontype.number");
        if ("singleitem".equals(conditiontype)) {
            return itemid == condition.getLong("item.id") && unitid == condition.getLong("unit.id") && attrid == condition.getLong("attr.id");
        }
        if ("itemrange".equals(conditiontype)) {
            return ItemRangeUtil.isItemInRange((DetailItemInfo)new DetailItemInfo((Object)itemid, (Object)unitid, (Object)attrid), (Object)condition.get("itemrange.id"));
        }
        return false;
    }

    private boolean isInRange(DynamicObject policy, long customerid) {
        return CustomerRangeUtil.isCustomerInRange((Object)customerid, (Object)policy.get("customerrange.id"));
    }

    private long parseId(Object id) {
        return id == null ? 0L : Long.parseLong(id.toString());
    }

    private String parseDateTime(Object datetime) {
        if (datetime != null) {
            return datetime.toString();
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    private QFilter[] buildQFilters(long ownerid, String datetime) {
        QFilter filter = new QFilter("owner", "=", (Object)ownerid);
        filter.and(new QFilter("starttime", "<=", (Object)datetime));
        filter.and(new QFilter("endtime", ">=", (Object)datetime));
        filter.and(new QFilter("entryentity.seq", "=", (Object)1));
        filter.and(new QFilter("status", "=", (Object)"D"));
        return filter.toArray();
    }
}

