/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.api;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.PromotionUtil;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;
import kd.drp.mdr.common.util.PriceUtil;

public class PromotionExecuteApi
extends MdrApi {
    public ApiResult matchAndExecutePromotion(Map<String, Object> data) {
        String pid = (String)data.get("pid");
        if (pid == null) {
            pid = UUID.randomUUID().toString();
        }
        PromotionOrder porder = this.buildPromotionOrder(data);
        PromotionExecuteContext context = PromotionUtil.matchAndExecute((String)pid, (PromotionOrder)porder);
        porder = context.getOrder();
        return ApiResult.success(this.convertPromotionOrderToData(porder, pid));
    }

    private PromotionOrder buildPromotionOrder(Map<String, Object> data) {
        long ownerid = this.parseId(data.get("ownerid"));
        long customerid = this.parseId(data.get("customerid"));
        Date datetime = this.parseDateTime(data.get("datetime"));
        PromotionOrder order = new PromotionOrder((Object)ownerid, (Object)customerid, datetime);
        List entrys = (List)data.get("entrys");
        BigDecimal totalamount = BigDecimal.ZERO;
        for (Map entry : entrys) {
            PromotionOrderEntry pentry = new PromotionOrderEntry();
            pentry.setEntryid((Object)this.parseAndCreateId(entry.get("entryid")));
            pentry.setItemid((Object)this.parseId(entry.get("itemid")));
            pentry.setUnitid((Object)this.parseId(entry.get("unitid")));
            pentry.setAttrid((Object)this.parseId(entry.get("attrid")));
            pentry.setIspresent(Boolean.parseBoolean(entry.get("ispresent").toString()));
            pentry.setIscombination(false);
            pentry.setType(SaleOrderEntryType.COMMON);
            BigDecimal qty = new BigDecimal(entry.get("qty").toString());
            pentry.setQty(qty);
            pentry.setPrice(PriceUtil.getItemPrice((Object)ownerid, (Object)customerid, (Object)pentry.getItemid(), (Object)pentry.getUnitid(), (Object)pentry.getAttrid(), (BigDecimal)qty, (Date)order.getCreatetime()));
            pentry.setAmount(pentry.getPrice().multiply(pentry.getQty()));
            totalamount = totalamount.add(pentry.getAmount());
            order.addEntry(pentry);
        }
        order.setTotalamount(totalamount);
        return order;
    }

    private Map<String, Object> convertPromotionOrderToData(PromotionOrder porder, String pid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerid", porder.getOwnerid());
        map.put("customerid", porder.getCustomerid());
        map.put("datetime", porder.getCreatetime());
        map.put("pid", pid);
        ArrayList entrys = new ArrayList(porder.getEntries().size());
        for (PromotionOrderEntry pentry : porder.getEntries()) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("entryid", pentry.getEntryid());
            entry.put("itemid", pentry.getItemid());
            entry.put("unitid", pentry.getUnitid());
            entry.put("attrid", pentry.getUnitid());
            entry.put("qty", pentry.getQty());
            entry.put("price", pentry.getPrice());
            entry.put("amount", pentry.getAmount());
            entry.put("ispresent", pentry.isIspresent());
            entry.put("itemname", this.getObjName(pentry.getItemid(), "mdr_item_info"));
            entry.put("unitname", this.getObjName(pentry.getUnitid(), "bd_measureunits"));
            entry.put("attrname", this.getObjName(pentry.getAttrid(), "mdr_item_attrvalue"));
            if (pentry.isIspresent()) {
                entry.put("sourceentryid", pentry.getSourceentryid());
            }
            entrys.add(entry);
        }
        map.put("entrys", entrys);
        return map;
    }

    private String getObjName(Object objid, String objtype) {
        if (objid == null || Long.valueOf(objid.toString()).equals(0L)) {
            return "";
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)objtype, (String)"name", (QFilter[])new QFilter("id", "=", objid).toArray());
        return obj.getString("name");
    }

    public ApiResult removePromotionCache(Map<String, Object> data) {
        String pid = (String)data.get("pid");
        if (pid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165pid\u503c", (String)"PromotionExecuteApi_0", (String)"drp-dpm-webapi", (Object[])new Object[0]));
        }
        PromotionUtil.removePromotionCache((String)pid);
        return ApiResult.success(null);
    }

    private long parseId(Object id) {
        return id == null ? 0L : Long.parseLong(id.toString());
    }

    private Date parseDateTime(Object datetime) {
        if (datetime == null) {
            return new Date();
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(datetime.toString());
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private long parseAndCreateId(Object id) {
        return id == null ? DBServiceHelper.genGlobalLongId() : Long.parseLong(id.toString());
    }
}

