/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.mservice.flow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.drp.dbd.business.helper.TicketActionFlowHelper;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketFlowOperTypeEnum;
import kd.drp.dbd.pojo.TicketFlowParamVO;
import kd.drp.gcm.common.result.TicketApiResult;
import kd.drp.gcm.meservice.api.flow.TicketActionFlowService;

public class TicketActionFlowServiceImpl
implements TicketActionFlowService {
    private static final String ERR_01 = "\u5355\u636e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERR_02 = "\u6d41\u6c34\u65b9\u5411\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5";
    private static final String ERR_03 = "\u6d41\u6c34\u7c7b\u578b\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5";
    private static final String ERR_04 = "\u793c\u5238\u8d44\u6599id\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERR_05 = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";

    public JSONObject saveTicketActionFlow(JSONObject jsonObject) {
        if (ObjectUtils.isEmpty((Object)jsonObject)) {
            return TicketApiResult.fail((String)ERR_05);
        }
        try {
            String msg = this.checkData(jsonObject);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return TicketApiResult.fail((String)msg);
            }
            TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
            if (OptionDirectEnum.OPTIONDIRECT_NEG.getValue().equals(jsonObject.getString("option"))) {
                ticketFlowParamVO.setOption(OptionDirectEnum.OPTIONDIRECT_NEG);
            } else {
                ticketFlowParamVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT);
            }
            if (TicketFlowOperTypeEnum.TICKET_SALE_GIVE.getValue().equals(jsonObject.getString("opertype"))) {
                ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_SALE_GIVE);
            }
            if (TicketFlowOperTypeEnum.TICKET_CANCEL.getValue().equals(jsonObject.getString("opertype"))) {
                ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_CANCEL);
            }
            ticketFlowParamVO.setBillFormId(jsonObject.getString("billsource"));
            ticketFlowParamVO.setBillIdList(JSON.parseArray((String)jsonObject.getJSONArray("billinfoids").toJSONString(), Long.class));
            List flowVOList = TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
            return TicketApiResult.success((Object)flowVOList);
        }
        catch (Exception e) {
            return TicketApiResult.fail((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    private String checkData(JSONObject jsonObject) {
        String msg = "";
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("billsource"))) {
            msg = ERR_01;
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("option")) || !OptionDirectEnum.OPTIONDIRECT_NEG.getValue().equals(jsonObject.getString("option")) && !OptionDirectEnum.OPTIONDIRECT_RIGHT.getValue().equals(jsonObject.getString("option"))) {
            msg = msg + "," + ERR_02;
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("opertype")) || !TicketFlowOperTypeEnum.TICKET_SALE_GIVE.getValue().equals(jsonObject.getString("opertype")) && !TicketFlowOperTypeEnum.TICKET_CANCEL.getValue().equals(jsonObject.getString("opertype")) && !TicketFlowOperTypeEnum.TICKET_REFUND.getValue().equals(jsonObject.getString("opertype"))) {
            msg = msg + "," + ERR_03;
        }
        if (jsonObject.getJSONArray("billinfoids") == null || jsonObject.getJSONArray("billinfoids").size() < 1) {
            msg = msg + "," + ERR_04;
        }
        return msg;
    }
}

