/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.mservice.ticketinfo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dbd.business.helper.TicketActionFlowHelper;
import kd.drp.dbd.business.helper.TicketsInfoHelper;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketFlowOperTypeEnum;
import kd.drp.dbd.pojo.TicketFlowParamVO;
import kd.drp.dbd.pojo.TicketInfoParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;
import kd.drp.gcm.common.result.TicketInfoServiceResult;
import kd.drp.gcm.meservice.api.ticketinfo.ITicketInfoService;

public class TicketInfoServiceImpl
implements ITicketInfoService {
    private static final String ERR_01 = "\u5355\u636e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERR_02 = "\u6d41\u6c34\u65b9\u5411\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5";
    private static final String ERR_03 = "\u6d41\u6c34\u7c7b\u578b\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5";
    private static final String KEY_TICKET_INFO = "gcm_ticketsinfo";

    public JSONObject ticketInfoGift(JSONObject jsonParam) {
        try {
            if (ObjectUtils.isEmpty((Object)jsonParam)) {
                return TicketInfoServiceResult.fail((String)"\u8bf7\u8f93\u5165\u53c2\u6570");
            }
            TicketInfoParamVO ticketInfoParamVo = (TicketInfoParamVO)JSONObject.toJavaObject((JSON)jsonParam, TicketInfoParamVO.class);
            List ticketsInfoVOS = TicketsInfoHelper.doHelp((TicketInfoParamVO)ticketInfoParamVo);
            if (!CollectionUtils.isEmpty((Collection)ticketsInfoVOS)) {
                List billIds = ticketsInfoVOS.stream().filter(ticketsInfoVO -> ticketsInfoVO.getId() > 0L).map(TicketsInfoVO::getId).collect(Collectors.toList());
                jsonParam.put("billinfoids", billIds);
                jsonParam.put("billsource", (Object)"salesorder_send");
                String msg = this.checkData(jsonParam);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return TicketInfoServiceResult.fail((String)msg);
                }
                TicketFlowParamVO ticketFlowParamVO = this.getTicketFlowParamVO(jsonParam);
                List flowVOList = TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
                if (CollectionUtils.isEmpty((Collection)flowVOList)) {
                    TicketInfoServiceResult.fail((String)"\u751f\u6210\u6d41\u6c34\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            return TicketInfoServiceResult.success((Object)ticketsInfoVOS);
        }
        catch (Exception e) {
            return TicketInfoServiceResult.fail((String)e.getMessage());
        }
    }

    private TicketFlowParamVO getTicketFlowParamVO(JSONObject jsonParam) {
        TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
        if (OptionDirectEnum.OPTIONDIRECT_NEG.getValue().equals(jsonParam.getString("option"))) {
            ticketFlowParamVO.setOption(OptionDirectEnum.OPTIONDIRECT_NEG);
        } else {
            ticketFlowParamVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT);
        }
        if (TicketFlowOperTypeEnum.TICKET_SALE_GIVE.getValue().equals(jsonParam.getString("opertype"))) {
            ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_SALE_GIVE);
        }
        if (TicketFlowOperTypeEnum.TICKET_CANCEL.getValue().equals(jsonParam.getString("opertype"))) {
            ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_CANCEL);
        }
        ticketFlowParamVO.setBillFormId(jsonParam.getString("billsource"));
        ticketFlowParamVO.setBillIdList(JSON.parseArray((String)jsonParam.getJSONArray("billinfoids").toJSONString(), Long.class));
        return ticketFlowParamVO;
    }

    public JSONObject ticketInfoPay(JSONObject jsonParam) {
        try {
            DynamicObject[] ticketInfoDyns;
            if (ObjectUtils.isEmpty((Object)jsonParam)) {
                return TicketInfoServiceResult.fail((String)"\u8bf7\u8f93\u5165\u53c2\u6570");
            }
            TicketInfoParamVO ticketInfoParamVo = (TicketInfoParamVO)JSONObject.toJavaObject((JSON)jsonParam, TicketInfoParamVO.class);
            List ticketsInfoVOS = TicketsInfoHelper.doHelp((TicketInfoParamVO)ticketInfoParamVo);
            if (!CollectionUtils.isEmpty((Collection)ticketInfoParamVo.getNumbers()) && (ticketInfoDyns = BusinessDataServiceHelper.load((String)KEY_TICKET_INFO, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)ticketInfoParamVo.getNumbers().toArray())})) != null && ticketInfoDyns.length > 0) {
                ArrayList<Long> billIds = new ArrayList<Long>(ticketInfoDyns.length);
                for (DynamicObject temp : ticketInfoDyns) {
                    billIds.add((Long)temp.getPkValue());
                }
                jsonParam.put("billinfoids", billIds);
                jsonParam.put("billsource", (Object)"salesorder_cancel");
                String msg = this.checkData(jsonParam);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return TicketInfoServiceResult.fail((String)msg);
                }
                TicketFlowParamVO ticketFlowParamVO = this.getTicketFlowParamVO(jsonParam);
                ticketFlowParamVO.setSourceBillId(jsonParam.getString("consumebillid"));
                List flowVOList = TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
                if (CollectionUtils.isEmpty((Collection)flowVOList)) {
                    TicketInfoServiceResult.fail((String)"\u751f\u6210\u6d41\u6c34\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            return TicketInfoServiceResult.success((Object)ticketsInfoVOS);
        }
        catch (Exception e) {
            return TicketInfoServiceResult.fail((String)e.getMessage());
        }
    }

    public JSONObject queryTicketInfoDetail(JSONObject jsonParam) {
        if (ObjectUtils.isEmpty((Object)jsonParam)) {
            return TicketInfoServiceResult.fail((String)"\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        try {
            TicketInfoParamVO ticketInfoParamVo = (TicketInfoParamVO)JSONObject.toJavaObject((JSON)jsonParam, TicketInfoParamVO.class);
            List ticketsInfoVOS = TicketsInfoHelper.doHelp((TicketInfoParamVO)ticketInfoParamVo);
            return TicketInfoServiceResult.success((Object)ticketsInfoVOS);
        }
        catch (Exception e) {
            return TicketInfoServiceResult.success((Object)e.getMessage());
        }
    }

    public JSONObject queryTicketInfoList(JSONObject jsonParam) {
        if (ObjectUtils.isEmpty((Object)jsonParam)) {
            return TicketInfoServiceResult.fail((String)"\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        try {
            TicketInfoParamVO ticketInfoParamVo = (TicketInfoParamVO)JSONObject.toJavaObject((JSON)jsonParam, TicketInfoParamVO.class);
            List ticketsInfoVOS = TicketsInfoHelper.doHelp((TicketInfoParamVO)ticketInfoParamVo);
            return TicketInfoServiceResult.success((Object)ticketsInfoVOS);
        }
        catch (Exception e) {
            return TicketInfoServiceResult.success((Object)e.getMessage());
        }
    }

    public JSONObject ticketInfoRefund(JSONObject jsonParam) {
        if (ObjectUtils.isEmpty((Object)jsonParam)) {
            return TicketInfoServiceResult.fail((String)"\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        try {
            DynamicObject[] ticketInfoDyns;
            TicketInfoParamVO ticketInfoParamVo = (TicketInfoParamVO)JSONObject.toJavaObject((JSON)jsonParam, TicketInfoParamVO.class);
            List ticketsInfoVOS = TicketsInfoHelper.doHelp((TicketInfoParamVO)ticketInfoParamVo);
            if (!CollectionUtils.isEmpty((Collection)ticketInfoParamVo.getNumbers()) && (ticketInfoDyns = BusinessDataServiceHelper.load((String)KEY_TICKET_INFO, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)ticketInfoParamVo.getNumbers().toArray())})) != null && ticketInfoDyns.length > 0) {
                ArrayList<Long> billIds = new ArrayList<Long>(ticketInfoDyns.length);
                for (DynamicObject temp : ticketInfoDyns) {
                    billIds.add((Long)temp.getPkValue());
                }
                jsonParam.put("billinfoids", billIds);
                jsonParam.put("billsource", (Object)"salesorder_refund");
                String msg = this.checkData(jsonParam);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    return TicketInfoServiceResult.fail((String)msg);
                }
                TicketFlowParamVO ticketFlowParamVO = this.getTicketFlowParamVO(jsonParam);
                ticketFlowParamVO.setSourceBillId(jsonParam.getString("consumebillid"));
                List flowVOList = TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
                if (CollectionUtils.isEmpty((Collection)flowVOList)) {
                    TicketInfoServiceResult.fail((String)"\u751f\u6210\u6d41\u6c34\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            return TicketInfoServiceResult.success((Object)ticketsInfoVOS);
        }
        catch (Exception e) {
            return TicketInfoServiceResult.success((Object)e.getMessage());
        }
    }

    private String checkData(JSONObject jsonObject) {
        String msg = "";
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("billsource"))) {
            msg = ERR_01;
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("option")) || !OptionDirectEnum.OPTIONDIRECT_NEG.getValue().equals(jsonObject.getString("option")) && !OptionDirectEnum.OPTIONDIRECT_RIGHT.getValue().equals(jsonObject.getString("option"))) {
            msg = msg + "," + ERR_02;
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("opertype")) || !TicketFlowOperTypeEnum.TICKET_SALE_GIVE.getValue().equals(jsonObject.getString("opertype")) && !TicketFlowOperTypeEnum.TICKET_CANCEL.getValue().equals(jsonObject.getString("opertype")) && !TicketFlowOperTypeEnum.TICKET_REFUND.getValue().equals(jsonObject.getString("opertype"))) {
            msg = msg + "," + ERR_03;
        }
        return msg;
    }
}

