/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TicketServiceHelper {
    public static Map<Object, DynamicObject> getTicketInfo(long memberId) {
        QFilter filter = TicketServiceHelper.getDefaultFilter();
        filter.and("vipid", "=", (Object)memberId);
        return BusinessDataServiceHelper.loadFromCache((String)"gcm_ticketsinfo", (String)StringUtils.join((Object[])TicketServiceHelper.getSelectFields(), (char)','), (QFilter[])filter.toArray());
    }

    public static Map<Object, DynamicObject> getTicketInfoByBranchid(long branchid) {
        List<Long> tickettypeids = TicketServiceHelper.getTicketTypeidByBranchid(branchid);
        QFilter filter = TicketServiceHelper.getDefaultFilter();
        filter.and("tickettypeid", "in", tickettypeids);
        filter.or("publishbranchid", "=", (Object)branchid);
        return BusinessDataServiceHelper.loadFromCache((String)"gcm_ticketsinfo", (String)StringUtils.join((Object[])TicketServiceHelper.getSelectFields(), (char)','), (QFilter[])filter.toArray());
    }

    private static QFilter getDefaultFilter() {
        QFilter defaultfilter = new QFilter("status", "=", (Object)"C");
        defaultfilter.and("enable", "=", (Object)"1");
        defaultfilter.and("ticketstatus", "=", (Object)"P");
        defaultfilter.and("cancelstatus", "=", (Object)"A");
        return defaultfilter;
    }

    private static String[] getSelectFields() {
        return new String[]{"id", "number", "tickettypeid", "ticketvalue", "minconsumeamount", "ticketcurrencyid"};
    }

    private static List<Long> getTicketTypeidByBranchid(long branchid) {
        ArrayList<Long> tickettypeids = new ArrayList<Long>();
        TicketServiceHelper.getTicketTypeByAllBranchid(tickettypeids);
        TicketServiceHelper.getTicketTypeByAssignBranchid(tickettypeids, branchid);
        return tickettypeids.stream().distinct().collect(Collectors.toList());
    }

    private static void getTicketTypeByAllBranchid(List<Long> tickettypeids) {
        DynamicObject[] tickettypeentity;
        QFilter filter = new QFilter("controlmethod", "=", (Object)"1");
        for (DynamicObject dynamicObject : tickettypeentity = BusinessDataServiceHelper.load((String)"gcm_ticketstype", (String)"id", (QFilter[])filter.toArray())) {
            tickettypeids.add(dynamicObject.getLong("id"));
        }
    }

    private static void getTicketTypeByAssignBranchid(List<Long> tickettypeids, long branchid) {
        DynamicObject[] tickettypeentity;
        QFilter filter = new QFilter("controlmethod", "=", (Object)"3");
        for (DynamicObject dynamicObject : tickettypeentity = BusinessDataServiceHelper.load((String)"gcm_ticketstype", (String)"idchannelgroup", (QFilter[])filter.toArray())) {
            DynamicObjectCollection branchentitys = dynamicObject.getDynamicObjectCollection("channelgroup");
            boolean isadapt = branchentitys.stream().anyMatch(s -> branchid == (Long)s.getPkValue());
            if (!isadapt) continue;
            tickettypeids.add(dynamicObject.getLong("id"));
        }
    }
}

