/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.formplugin.Ticketsreturn;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dbd.business.helper.CurrencyHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.enums.DataStatusEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.utils.DynamicObjectUtil;
import kd.drp.dbd.utils.OwnerUtil;

public class TicketsReturnEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketEdit = (BasedataEdit)this.getView().getControl("ticketid");
        ticketEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit branchEdit = (BasedataEdit)this.getView().getControl("branchid");
        branchEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void initDefaultLocalCurrency() {
        long orgId = RequestContext.get().getOrgId();
        if (orgId <= 0L) {
            return;
        }
        DynamicObject CurrencyDyn = CurrencyHelper.getCurrency((Long)orgId);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)CurrencyDyn);
        this.getView().getModel().setItemValueByID("localcurrencyid", (Object)currencyId);
        DynamicObject branch = (DynamicObject)this.getModel().getValue("branchid");
        long setcurrencyid = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"currency");
        this.getView().getModel().setItemValueByID("settlecurrencyid", (Object)setcurrencyid);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.initDefaultBranchID();
            this.initDefaultLocalCurrency();
            this.getView().setEnable(Boolean.FALSE, new String[]{"retdeductionamt"});
        }
    }

    private void initDefaultBranchID() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
        if (doBizOrg != null) {
            List lstOwner = OwnerUtil.getOwnerIds((long)DynamicObjectUtil.getPkValue((DynamicObject)doBizOrg), (boolean)true);
            Object ownerId = OwnerUtil.getDefaultOwnerId((List)lstOwner);
            this.getView().getModel().setValue("branchid", ownerId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "ticketid": {
                this.setQytAndAmount();
                break;
            }
            case "org": 
            case "branchid": {
                this.initDefaultLocalCurrency();
                break;
            }
            case "returnamount": {
                this.setReturnAmount();
                break;
            }
            case "exchangerateid": {
                this.setRate(e);
                break;
            }
            case "retdeductionamt": {
                this.setRetDeductionAmt();
                break;
            }
            case "retamount": {
                this.setPayAmount(e);
                break;
            }
            case "retmodeid": {
                this.setPayWayType(e);
                break;
            }
            case "retcurrencyid": {
                this.setRate(e);
                break;
            }
        }
    }

    private void setPayWayType(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject payMode = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (payMode == null) {
            this.getModel().setValue("paywaytypeid", null, rowIndex);
            this.getModel().setValue("paywaytypeid", null, rowIndex);
            return;
        }
        DynamicObjectCollection payWayCol = payMode.getDynamicObjectCollection("paywaytype");
        if (payWayCol != null && payWayCol.size() > 0) {
            this.getModel().setValue("paywaytypeid", (Object)((DynamicObject)payWayCol.get(0)).getDynamicObject("fbasedataid"), rowIndex);
            this.getView().updateView("paywaytypeid", rowIndex);
        } else {
            this.getModel().setValue("paywaytypeid", null, rowIndex);
        }
        DynamicObject branch = (DynamicObject)this.getModel().getValue("branchid");
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        if (branch != null) {
            qFilter.and("treeentryentity.branch.Id", "=", branch.getPkValue());
        }
        qFilter.and("entryentity.channel.Id", "=", payMode.getPkValue());
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"dbd_payconfigs", (String)"id,entryentity.currencyid", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            QFilter filter = new QFilter("entryentity.channel.Id", "=", payMode.getPkValue());
            filter.and("status", "=", (Object)"C");
            filter.and("controlmode", "=", (Object)"0");
            dyn = BusinessDataServiceHelper.loadSingle((String)"dbd_payconfigs", (String)"id,entryentity.currencyid", (QFilter[])new QFilter[]{filter});
        }
        if (dyn != null && dyn.getDynamicObjectCollection("entryentity") != null && dyn.getDynamicObjectCollection("entryentity").size() > 0 && ((DynamicObject)dyn.getDynamicObjectCollection("entryentity").get(0)).get("currencyid") != null) {
            this.getModel().setValue("retcurrencyid", ((DynamicObject)dyn.getDynamicObjectCollection("entryentity").get(0)).get("currencyid"), rowIndex);
            this.getView().updateView("retcurrencyid", rowIndex);
            this.setRate(e);
        }
    }

    private void setPayAmount(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal payAmt = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (payAmt == null || BigDecimal.ZERO.compareTo(payAmt) == 0) {
            this.getModel().setValue("localcrypayamount", null, rowIndex);
        }
    }

    private void setRetDeductionAmt() {
        BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("retdeductionamt");
        if (discountAmount != null) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal realAmount = amount.subtract(discountAmount);
            this.updateValue("realretamount", realAmount);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"ticrreturnentry")) {
            DynamicObject exrateTable;
            DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
            if (doBizOrg != null && (exrateTable = CurrencyHelper.getExRateTable((Long)((Long)doBizOrg.getPkValue()))) != null) {
                this.getModel().setValue("exchangerateid", exrateTable.getPkValue(), rowIndex);
            }
            this.getModel().setValue("exchangetype", (Object)1, rowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"entryentity")) {
            this.setQytAndAmount();
        }
    }

    public void afterCopyData(EventObject e) {
        BigDecimal retdeductionamt;
        Integer qty;
        BigDecimal realretamount;
        BigDecimal amount;
        DynamicObjectCollection payEntryColl;
        super.afterCopyData(e);
        DynamicObjectCollection ticketInfoEntryColl = this.getModel().getEntryEntity("entryentity");
        if (ticketInfoEntryColl.size() > 0) {
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
        }
        if ((payEntryColl = this.getModel().getEntryEntity("ticrreturnentry")).size() > 0) {
            this.getModel().deleteEntryData("ticrreturnentry");
            this.getView().updateView("ticrreturnentry");
        }
        if ((amount = (BigDecimal)this.getModel().getValue("amount")) != null && BigDecimal.ZERO.compareTo(amount) < 0) {
            this.getModel().setValue("amount", null);
            this.getView().updateView("amount");
        }
        if ((realretamount = (BigDecimal)this.getModel().getValue("realretamount")) != null && BigDecimal.ZERO.compareTo(realretamount) < 0) {
            this.getModel().setValue("realretamount", null);
            this.getView().updateView("realretamount");
        }
        if ((qty = (Integer)this.getModel().getValue("returnqty")) != null && qty > 0) {
            this.getModel().setValue("returnqty", null);
            this.getView().updateView("returnqty");
        }
        if ((retdeductionamt = (BigDecimal)this.getModel().getValue("retdeductionamt")) != null && BigDecimal.ZERO.compareTo(retdeductionamt) < 0) {
            this.getModel().setValue("retdeductionamt", null);
            this.getView().updateView("retdeductionamt");
        }
    }

    private void setReturnAmount() {
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObjectCollection ticketInfoEntryColl = this.getModel().getEntryEntity("entryentity");
        if (ticketInfoEntryColl.size() > 0) {
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                if (ticketInfoEntry.getBigDecimal("returnamount") == null) continue;
                amount = amount.add(ticketInfoEntry.getBigDecimal("returnamount"));
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"retdeductionamt"});
        }
        this.getModel().setValue("realretamount", (Object)amount);
        this.getView().updateView("realretamount");
        BigDecimal refsaleAmount = (BigDecimal)this.getModel().getValue("amount");
        this.setReturnAmtAndRetDeuctionAmt(amount, refsaleAmount);
    }

    private void setReturnAmtAndRetDeuctionAmt(BigDecimal amount, BigDecimal refsaleAmount) {
        if (refsaleAmount.subtract(amount).compareTo(new BigDecimal(0)) > 0) {
            BigDecimal retDeductionAmt = refsaleAmount.subtract(amount);
            this.getModel().setValue("retdeductionamt", (Object)retDeductionAmt);
        } else {
            this.getModel().setValue("retdeductionamt", null);
        }
    }

    private void setQytAndAmount() {
        Integer qty = 0;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal realAmount = BigDecimal.ZERO;
        DynamicObjectCollection ticketInfoEntryColl = this.getModel().getEntryEntity("entryentity");
        if (ticketInfoEntryColl.size() > 0) {
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                long ticketsInfoID = ticketInfoEntry.getLong("ticketid_id");
                if (ticketsInfoID > 0L) {
                    qty = qty + 1;
                    DynamicObject ticketInfoDyn = ticketInfoEntry.getDynamicObject("ticketid");
                    amount = amount.add(TicketsReturnEdit.getBigDecimal(ticketInfoDyn, "realsaleamount"));
                    realAmount = realAmount.add(TicketsReturnEdit.getBigDecimal(ticketInfoEntry, "returnamount"));
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"retdeductionamt"});
            }
        } else {
            this.getModel().setValue("realretamount", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"retdeductionamt"});
        }
        this.getModel().setValue("returnqty", (Object)qty);
        this.getModel().setValue("amount", (Object)amount);
        this.getModel().setValue("realretamount", (Object)realAmount);
        this.setReturnAmtAndRetDeuctionAmt(realAmount, amount);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        IDataModel dataModel = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        switch (fieldKey) {
            case "branchid": {
                QFilter qFilter;
                if (!StringUtils.equals((CharSequence)fieldKey, (CharSequence)"branchid") || (qFilter = this.buildBranchFilter()) == null) break;
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "ticketid": {
                DynamicObject customerDyn = (DynamicObject)dataModel.getValue("branchid");
                DynamicObject bizOrgDyn = (DynamicObject)dataModel.getValue("org");
                if (ObjectUtils.isEmpty((Object)customerDyn) || ObjectUtils.isEmpty((Object)bizOrgDyn)) {
                    event.setCancel(true);
                    throw new KDBizException("\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u548c\u53d1\u552e\u95e8\u5e97");
                }
                showParameter.getListFilterParameter().setQFilters(this.ticketInfoFilter(dataModel));
            }
        }
    }

    private List<QFilter> ticketInfoFilter(IDataModel dataModel) {
        DynamicObject customerDyn = (DynamicObject)dataModel.getValue("branchid");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter branchFilter = new QFilter("recyclebranchid", "=", customerDyn.getPkValue());
        branchFilter.or(new QFilter("recyclebranchid", "=", (Object)0));
        qFilters.add(branchFilter);
        QFilter ticketQFilter1 = new QFilter("ticketstatus", "=", (Object)TicketStatusEnum.SEND.getName());
        QFilter ticketQFilter2 = new QFilter("cancelstatus", "=", (Object)DataStatusEnum.SAVED);
        qFilters.add(ticketQFilter1);
        qFilters.add(ticketQFilter2);
        DynamicObjectCollection ticketInfoEntryColl = dataModel.getEntryEntity("entryentity");
        ArrayList<Long> selectedTicketInfoIds = null;
        if (ticketInfoEntryColl.size() > 0) {
            selectedTicketInfoIds = new ArrayList<Long>(ticketInfoEntryColl.size());
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                if (ticketInfoEntry.getLong("ticketid_id") <= 0L) continue;
                selectedTicketInfoIds.add(ticketInfoEntry.getLong("ticketid_id"));
            }
        }
        if (selectedTicketInfoIds != null && selectedTicketInfoIds.size() > 0) {
            QFilter ticketQFilter3 = new QFilter("id", "not in", selectedTicketInfoIds);
            qFilters.add(ticketQFilter3);
        }
        return qFilters;
    }

    private QFilter buildBranchFilter() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
        if (doBizOrg != null) {
            long bizOrgId = Long.parseLong(String.valueOf(doBizOrg.getPkValue()));
            return OwnerUtil.getOwnerIdsFilter((long)bizOrgId);
        }
        return null;
    }

    private void setRate(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            this.getModel().setValue("exchangerate", null, rowIndex);
            this.getModel().setValue("localcrypayamount", null, rowIndex);
            return;
        }
        Object settleCurrency = this.getView().getModel().getValue("retcurrencyid");
        Object exrateTable = this.getView().getModel().getValue("exchangerateid");
        Object loCurrency = this.getModel().getValue("localcurrencyid");
        if (settleCurrency == null || exrateTable == null || loCurrency == null) {
            return;
        }
        Long settleCurrencyId = ((DynamicObject)settleCurrency).getLong("id");
        Long exrateTableId = ((DynamicObject)exrateTable).getLong("id");
        Long loCurrencyId = ((DynamicObject)loCurrency).getLong("id");
        BigDecimal rate = CurrencyHelper.getExChangeRate((Long)settleCurrencyId, (Long)loCurrencyId, (Long)exrateTableId);
        this.getModel().setValue("exchangerate", (Object)rate);
    }

    private void updateValue(String key, Object value) {
        this.getView().getModel().beginInit();
        this.getView().getModel().setValue(key, value);
        this.getView().updateView(key);
        this.getView().getModel().endInit();
    }

    public static BigDecimal getBigDecimal(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return BigDecimal.ZERO;
        }
        return item.getBigDecimal(key);
    }
}

