/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.formplugin.ticketsmake;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.business.helper.TicketRuleCodeHelper;
import kd.drp.dbd.utils.DynamicObjectUtil;
import kd.drp.dbd.utils.OwnerUtil;

public class TicketsMakeFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_TICKETMAKE = "ticketmake";
    private static final String KEY_CALLBACK = "callback";
    private static final String KEY_REFRESH = "refresh";
    public static final String KEY_ID = "id";
    public static final String KEY_FID = "fid";
    public static final String KEY_RULEID = "ruleid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TICKETMAKE});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("makebranchid");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.initDefaultBranchID();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)KEY_TICKETMAKE, (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String status = (String)this.getModel().getValue("makestatus");
            String ticketRuleStatus = this.getTicketCodeRuleStatus(this.getModel().getDataEntity().getDynamicObject("ticketstypeid"));
            if ("1".equals(status)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5236\u5238\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String)"TicketsMakeFormPlugin_0", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            } else if ("0".equals(ticketRuleStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5238\u53f7\u89c4\u5219\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u5238\u53f7,\u8bf7\u9009\u62e9\u5176\u4ed6\u793c\u5238\u7c7b\u578b", (String)"TicketsMakeFormPlugin_1", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            } else {
                Long fid = (Long)this.getModel().getDataEntity().getPkValue();
                this.openTicketMakeWindow(fid);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        if (e.getChangeSet().length <= 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "ticketstypeid": {
                List codelist;
                long ticketruleno = this.getTicketRuleId();
                if (ticketruleno <= 0L || (codelist = TicketRuleCodeHelper.getTicketCode((long)ticketruleno, (int)1)) == null || codelist.size() <= 0) break;
                this.getModel().setValue("ticketsno", codelist.get(0));
                break;
            }
        }
    }

    private long getTicketRuleId() {
        DynamicObject tickettype = (DynamicObject)this.getModel().getValue("ticketstypeid");
        if (tickettype != null) {
            if (!"0".equals(this.getTicketCodeRuleStatus(tickettype))) {
                return tickettype.getDynamicObject("ticketcoderule").getLong(KEY_ID);
            }
            this.getModel().setValue("ticketstypeid", (Object)"");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5238\u53f7\u89c4\u5219\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u5238\u53f7,\u8bf7\u9009\u62e9\u5176\u4ed6\u793c\u5238\u7c7b\u578b", (String)"TicketsMakeFormPlugin_1", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
        }
        return 0L;
    }

    private String getTicketCodeRuleStatus(DynamicObject tickettype) {
        long ticketcoderuleid = tickettype.getDynamicObject("ticketcoderule").getLong(KEY_ID);
        DynamicObject coderuleEntity = this.getTicketCodeRuleEntity(ticketcoderuleid);
        return coderuleEntity.getString("enable");
    }

    private DynamicObject getTicketCodeRuleEntity(long ticketcoderuleid) {
        QFilter filter = new QFilter(KEY_ID, "=", (Object)ticketcoderuleid);
        return BusinessDataServiceHelper.loadSingle((String)"gcm_ticketscoderule", (String)"enable", (QFilter[])filter.toArray());
    }

    private void openTicketMakeWindow(Long fid) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("gcm_ticketmake_view");
        formShowParameter.setCustomParam(KEY_FID, (Object)fid);
        formShowParameter.setCustomParam(KEY_RULEID, (Object)this.getTicketRuleId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CALLBACK));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (KEY_CALLBACK.equals(closedCallBackEvent.getActionId())) {
            String returndata = (String)closedCallBackEvent.getReturnData();
            String startno = returndata.split(",")[0];
            String endno = returndata.split(",")[1];
            this.updateTicketInfo(startno, endno);
            this.updateMaketicketstatus();
            this.getView().updateView();
            this.getView().invokeOperation(KEY_REFRESH);
        }
    }

    public void updateTicketInfo(String ticketsstartvalue, String ticketsendvalue) {
        Long fid = this.getModel().getDataEntity().getLong(KEY_ID);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ID, "=", (Object)fid)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"gcm_ticketsmake", (String)"makestatus,ticketsstartvalue,ticketsendvalue", (QFilter[])qFilters);
        dynamicObject.set("makestatus", (Object)"1");
        dynamicObject.set("ticketsstartvalue", (Object)ticketsstartvalue);
        dynamicObject.set("ticketsendvalue", (Object)ticketsendvalue);
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    public void updateMaketicketstatus() {
        DynamicObject tickettype = (DynamicObject)this.getModel().getValue("ticketstypeid");
        tickettype.set("maketicketstatus", (Object)"1");
        SaveServiceHelper.update((DynamicObject)tickettype);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "makebranchid": {
                QFilter qFilter = this.buildFilter();
                if (qFilter == null) break;
                ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private QFilter buildFilter() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
        if (doBizOrg != null) {
            long bizOrgId = Long.parseLong(String.valueOf(doBizOrg.getPkValue()));
            return OwnerUtil.getOwnerIdsFilter((long)bizOrgId);
        }
        return null;
    }

    private void initDefaultBranchID() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
        if (doBizOrg != null) {
            List lstOwner = OwnerUtil.getOwnerIds((long)DynamicObjectUtil.getPkValue((DynamicObject)doBizOrg), (boolean)true);
            Object ownerId = OwnerUtil.getDefaultOwnerId((List)lstOwner);
            this.getView().getModel().setValue("makebranchid", ownerId);
        }
    }
}

