/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.formplugin.ticketsreceive;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.drp.dbd.business.helper.CurrencyHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.enums.CancelStatusEnum;
import kd.drp.dbd.enums.TicketStatusEnum;
import kd.drp.dbd.utils.DynamicObjectUtil;
import kd.drp.dbd.utils.OwnerUtil;

public class TicketsReceiveEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketEdit = (BasedataEdit)this.getView().getControl("ticketsid");
        ticketEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit branchEdit = (BasedataEdit)this.getView().getControl("branchid");
        branchEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "deleteentry": {
                this.setQytAndAmount();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void initDefaultBranchID() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
        if (doBizOrg != null) {
            List lstOwner = OwnerUtil.getOwnerIds((long)DynamicObjectUtil.getPkValue((DynamicObject)doBizOrg), (boolean)true);
            Object ownerId = OwnerUtil.getDefaultOwnerId((List)lstOwner);
            this.getView().getModel().setValue("branchid", ownerId);
        }
    }

    private void initDefaultLocalCurrency() {
        long orgId = RequestContext.get().getOrgId();
        if (orgId <= 0L) {
            return;
        }
        DynamicObject CurrencyDyn = CurrencyHelper.getCurrency((Long)orgId);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)CurrencyDyn);
        if (currencyId > 0L) {
            this.getView().getModel().setItemValueByID("currencyid", (Object)currencyId, 0);
        } else {
            this.getView().getModel().setValue("currencyid", null);
        }
        DynamicObject branch = (DynamicObject)this.getModel().getValue("branchid");
        long settleCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"currency");
        this.getView().getModel().setItemValueByID("settlecurrencyid", (Object)settleCurrencyId);
        this.getView().updateView();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.initDefaultBranchID();
            this.initDefaultLocalCurrency();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        IDataModel dataModel = this.getView().getModel();
        switch (fieldKey) {
            case "ticketsid": {
                this.setQytAndAmount();
                break;
            }
            case "org": {
                dataModel.deleteEntryData("entryentity");
                this.initDefaultLocalCurrency();
                break;
            }
            case "branchid": {
                this.setSettleCurrencyId();
                dataModel.deleteEntryData("entryentity");
            }
        }
    }

    private void setSettleCurrencyId() {
        DynamicObject branch = (DynamicObject)this.getModel().getValue("branchid");
        long settleCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"currency");
        this.getView().getModel().setItemValueByID("settlecurrencyid", (Object)settleCurrencyId);
        this.getView().updateView();
    }

    private void setQytAndAmount() {
        Integer qty = 0;
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObjectCollection ticketInfoEntryColl = this.getModel().getEntryEntity("entryentity");
        if (ticketInfoEntryColl.size() > 0) {
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                long ticketsInfoID = this.getBaseDataLongPkId(ticketInfoEntry, "ticketsid");
                if (ticketsInfoID <= 0L) continue;
                qty = qty + 1;
                DynamicObject ticketInfoDyn = ticketInfoEntry.getDynamicObject("ticketsid");
                amount = amount.add(ticketInfoDyn.getBigDecimal("ticketvalue"));
            }
        }
        this.getModel().setValue("qty", (Object)qty);
        this.getModel().setValue("amount", (Object)amount);
    }

    protected long getBaseDataLongPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getLong(fieldKey + "_id");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "ticketsid": {
                DynamicObject customerDyn = (DynamicObject)dataModel.getValue("branchid");
                DynamicObject bizOrgDyn = (DynamicObject)dataModel.getValue("org");
                if (ObjectUtils.isEmpty((Object)customerDyn) || ObjectUtils.isEmpty((Object)bizOrgDyn)) {
                    evt.setCancel(true);
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u548c\u9886\u53d6\u95e8\u5e97", (String)"TicketsReceiveEdit_0", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                }
                showParameter.getListFilterParameter().setQFilters(this.buildTicketInfoFilters(dataModel));
                break;
            }
            case "branchid": {
                QFilter qFilter = this.buildBranchFilter();
                if (qFilter == null) break;
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private QFilter buildBranchFilter() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("org");
        if (doBizOrg != null) {
            long bizOrgId = Long.parseLong(String.valueOf(doBizOrg.getPkValue()));
            QFilter ownerIdsFilter = OwnerUtil.getOwnerIdsFilter((long)bizOrgId);
            return ownerIdsFilter;
        }
        return null;
    }

    private List<QFilter> buildTicketInfoFilters(IDataModel dataModel) {
        DynamicObject customerDyn = (DynamicObject)dataModel.getValue("branchid");
        if (ObjectUtils.isEmpty((Object)customerDyn)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9886\u53d6\u95e8\u5e97", (String)"TicketsReceiveEdit_1", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection ticketInfoEntryColl = dataModel.getEntryEntity("entryentity");
        ArrayList<Long> selectedTicketInfoIds = null;
        if (ticketInfoEntryColl.size() > 0) {
            selectedTicketInfoIds = new ArrayList<Long>(ticketInfoEntryColl.size());
            for (DynamicObject ticketInfoEntry : ticketInfoEntryColl) {
                if (this.getBaseDataLongPkId(ticketInfoEntry, "ticketsid") <= 0L) continue;
                selectedTicketInfoIds.add(this.getBaseDataLongPkId(ticketInfoEntry, "ticketsid"));
            }
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter branchFilter = new QFilter("receivebranchid", "=", customerDyn.getPkValue());
        branchFilter.or(new QFilter("receivebranchid", "=", (Object)0));
        branchFilter.and(new QFilter("ticketstatus", "=", (Object)TicketStatusEnum.NO_MAKE.getName()));
        branchFilter.and(new QFilter("cancelstatus", "=", (Object)CancelStatusEnum.NOCANCEL));
        if (!CollectionUtils.isEmpty(selectedTicketInfoIds)) {
            branchFilter.and(new QFilter("id", "not in", selectedTicketInfoIds));
        }
        qFilters.add(branchFilter);
        return qFilters;
    }
}

