/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.opplugin.ticketpublish;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class TicketPublishSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        BigDecimal realAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject ticketPublishDyn = dataEntity.getDataEntity();
            DynamicObjectCollection ticketInfoDynColl = ticketPublishDyn.getDynamicObjectCollection("entryentity");
            if (ticketInfoDynColl.size() <= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u793c\u5238\u4fe1\u606f\u680f\u9009\u62e9\u672c\u6b21\u53d1\u552e\u7684\u793c\u5238", (String)"TicketPublishSubmitValidator_0", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject ticketEntry : ticketInfoDynColl) {
                if (ticketEntry.getBigDecimal("realsaleamount") == null) continue;
                realAmount = realAmount.add(ticketEntry.getBigDecimal("realsaleamount"));
            }
            BigDecimal tempRealAmount = ticketPublishDyn.getBigDecimal("realamount");
            if (tempRealAmount != null && realAmount.compareTo(tempRealAmount) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u793c\u5238\u4fe1\u606f\u680f\u5b9e\u9645\u552e\u5238\u91d1\u989d\u4e0e\u5b9e\u6536\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u8c03\u6574", (String)"TicketPublishSubmitValidator_1", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal amount = ticketPublishDyn.getBigDecimal("amount");
            DynamicObjectCollection payDynColl = ticketPublishDyn.getDynamicObjectCollection("paymodeentry");
            if (payDynColl.size() <= 0 && amount != null && amount.compareTo(BigDecimal.ZERO) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u6536\u6b3e\u4fe1\u606f\u680f\u8f93\u5165\u6536\u6b3e\u4fe1\u606f", (String)"TicketPublishSubmitValidator_2", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject payEntry : payDynColl) {
                if (payEntry.getBigDecimal("payamount") == null) continue;
                payAmount = payAmount.add(payEntry.getBigDecimal("payamount"));
            }
            if (payAmount == null || payAmount.compareTo(tempRealAmount) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u680f\u6536\u6b3e\u91d1\u989d\u4e0e\u5b9e\u6536\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u8c03\u6574", (String)"TicketPublishSubmitValidator_3", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

