/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.opplugin.ticketreceive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.drp.dbd.business.helper.TicketActionFlowHelper;
import kd.drp.dbd.business.helper.TicketsInfoHelper;
import kd.drp.dbd.enums.TicketFlowOperTypeEnum;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketReceiveAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("ticketsid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        int size = bills.length;
        ArrayList<Long> ticketReceiveBillIds = new ArrayList<Long>(size);
        ArrayList<Long> ticketInfoBaseDataIds = new ArrayList<Long>(size);
        for (DynamicObject bill : bills) {
            ticketReceiveBillIds.add(bill.getLong("id"));
            DynamicObjectCollection ticketInfoEntryDynColl = bill.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)ticketInfoEntryDynColl)) continue;
            for (DynamicObject ticketInfoEntryDyn : ticketInfoEntryDynColl) {
                ticketInfoBaseDataIds.add(this.getBaseDataLongPkId(ticketInfoEntryDyn, "ticketsid"));
            }
        }
        if (ticketInfoBaseDataIds.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.required((String)"gcm_ticketsinfo");){
            try {
                TicketsInfoHelper.updateTicketsInfo(ticketReceiveBillIds, (String)"gcm_ticketreceive", null);
                TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
                ticketFlowParamVO.setBillIdList(ticketInfoBaseDataIds);
                ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_COUPON);
                ticketFlowParamVO.setBillFormId("gcm_ticketreceive");
                List list = TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
            }
            catch (Exception exec) {
                tx.markRollback();
                throw new KDBizException(exec.getMessage());
            }
        }
    }

    protected long getBaseDataLongPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getLong(fieldKey + "_id");
    }
}

