/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.opplugin.ticketrecovery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.OperationException;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.drp.dbd.business.helper.TicketActionFlowHelper;
import kd.drp.dbd.business.helper.TicketsInfoHelper;
import kd.drp.dbd.enums.OptionDirectEnum;
import kd.drp.dbd.enums.TicketFlowOperTypeEnum;
import kd.drp.dbd.pojo.TicketFlowParamVO;

public class TicketRecoveryAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("returnamount");
        e.getFieldKeys().add("ticrreturnentry");
        e.getFieldKeys().add("retamount");
        e.getFieldKeys().add("realretamount");
        e.getFieldKeys().add("retdeductionamt");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("ticketid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> billIds = new HashSet<Long>(bills.length);
        HashSet<Long> billTicketsIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            billIds.add((Long)bill.getPkValue());
            DynamicObjectCollection dynColl = bill.getDynamicObjectCollection("entryentity");
            if (dynColl == null || dynColl.size() < 1) continue;
            for (DynamicObject ticket : dynColl) {
                billTicketsIds.add(ticket.getLong("ticketid_id"));
            }
        }
        try (TXHandle tx = TX.required((String)"gcm_ticketsinfo");){
            try {
                List infoVOS = TicketsInfoHelper.updateTicketsInfo(new ArrayList(billIds), (String)"gcm_ticketsreturn", null);
                TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
                ticketFlowParamVO.setBillIdList(new ArrayList(billTicketsIds));
                ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_RECOVERY);
                ticketFlowParamVO.setOption(OptionDirectEnum.OPTIONDIRECT_RIGHT);
                ticketFlowParamVO.setBillFormId("gcm_ticketsreturn");
                TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
            }
            catch (OperationException exec) {
                tx.markRollback();
                throw exec;
            }
        }
    }
}

