/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.gcm.opplugin.ticketrecovery;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class TicketRecoverySubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            BigDecimal returnAmt = BigDecimal.ZERO;
            BigDecimal payAmt = BigDecimal.ZERO;
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dyn = dataEntity.getDataEntity();
                DynamicObjectCollection ticketCollection = dyn.getDynamicObjectCollection("entryentity");
                if (ticketCollection == null || ticketCollection.size() < 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u793c\u5238\u4fe1\u606f\u680f\u9009\u62e9\u672c\u6b21\u56de\u6536\u7684\u793c\u5238", (String)"TicketRecoverySubmitValidator_0", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject ticketEntry : ticketCollection) {
                    if (ticketEntry.getBigDecimal("returnamount") == null) continue;
                    returnAmt = returnAmt.add(ticketEntry.getBigDecimal("returnamount"));
                }
                BigDecimal tempRealAmount = dyn.getBigDecimal("realretamount");
                if (tempRealAmount != null && returnAmt.compareTo(tempRealAmount) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u793c\u5238\u4fe1\u606f\u680f\u56de\u9000\u91d1\u989d\u603b\u548c\u4e0e\u5b9e\u9000\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u8c03\u6574", (String)"TicketRecoverySubmitValidator_1", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection returnDynColl = dyn.getDynamicObjectCollection("ticrreturnentry");
                BigDecimal amount = dyn.getBigDecimal("amount");
                if (returnDynColl.size() <= 0 && amount != null && BigDecimal.ZERO.compareTo(amount) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u9000\u6b3e\u4fe1\u606f\u680f\u8f93\u5165\u9000\u6b3e\u4fe1\u606f", (String)"TicketRecoverySubmitValidator_2", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject payEntry : returnDynColl) {
                    if (payEntry.getBigDecimal("retamount") == null) continue;
                    payAmt = payAmt.add(payEntry.getBigDecimal("retamount"));
                }
                if (payAmt == null || payAmt.compareTo(tempRealAmount) == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9000\u6b3e\u4fe1\u606f\u680f\u9000\u6b3e\u91d1\u989d\u4e0e\u5b9e\u9000\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u8c03\u6574", (String)"TicketRecoverySubmitValidator_3", (String)"drp-gcm-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

