/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.Api;
import kd.drp.mdr.common.util.CacheUtil;
import kd.drp.mdr.common.util.UserUtil;
import net.sf.json.JSONObject;

public class ApiManage {
    public static final String cacheKey = "mdrapi-" + UserUtil.getAcctId();

    public static void reloadApiList() {
        HashMap<String, Api> apiMap = new HashMap<String, Api>();
        DynamicObjectCollection apiCol = QueryServiceHelper.query((String)"mdr_api", (String)"id,name,number,plugin,method,islog,description", null);
        for (DynamicObject apiD : apiCol) {
            Api api = new Api(apiD.getLong("id"), apiD.getString("name"), apiD.getString("number"), apiD.getString("plugin"), apiD.getString("method"), apiD.getBoolean("islog"), apiD.getString("description"));
            apiMap.put(apiD.getString("number"), api);
        }
        CacheUtil.remove(cacheKey);
        CacheUtil.put(cacheKey, apiMap);
    }

    public static Map<String, Api> getApiMap() {
        Map apiMap = CacheUtil.get(cacheKey, HashMap.class);
        if (apiMap == null) {
            ApiManage.reloadApiList();
            apiMap = CacheUtil.get(cacheKey, HashMap.class);
            if (apiMap == null) {
                throw new KDBizException(ResManager.loadKDString((String)"api\u7f13\u5b58\u4e0d\u5b58\u5728\uff01", (String)"ApiManage_0", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
        }
        return apiMap;
    }

    public static String printApiList() {
        Map<String, Api> apiMap = ApiManage.getApiMap();
        HashMap<String, Api> map = new HashMap<String, Api>(apiMap.size());
        for (Map.Entry<String, Api> apiEntry : apiMap.entrySet()) {
            map.put(apiEntry.getKey(), apiEntry.getValue());
        }
        JSONObject json = JSONObject.fromObject(map);
        return json.toString();
    }

    static {
        ApiManage.reloadApiList();
    }
}

