/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ShortMessageUtil {
    public static final String COUNTRYCODE = "+86";
    public static final long TIME = 604800000L;

    private static void sendmessage(List<String> phonelist, String content) {
        ShortMessageInfo message = new ShortMessageInfo();
        message.setCountryCode(COUNTRYCODE);
        message.setPhone(phonelist);
        message.setMessage(content);
        MessageServiceHelper.sendShortMessage((ShortMessageInfo)message);
    }

    private static DynamicObject addOrderMessageLog(List<String> phonelist, String content, DynamicObject saleorder) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"mdr_message_log");
        log.set("order", saleorder.get("billno"));
        log.set("remark", saleorder.get("customer.name"));
        return ShortMessageUtil.addMessageLog(phonelist, content, log);
    }

    private static DynamicObject addMessageLog(List<String> phonelist, String content, DynamicObject log) {
        if (log == null) {
            log = BusinessDataServiceHelper.newDynamicObject((String)"mdr_message_log");
        }
        log.set("user", (Object)UserUtil.getUserInfo());
        StringBuilder phone = new StringBuilder();
        for (String phoneTemp : phonelist) {
            phone.append('[');
            phone.append(phoneTemp);
            phone.append(']');
        }
        log.set("phonelist", (Object)phone.toString());
        log.set("message", (Object)content);
        log.set("createtime", (Object)new Date());
        log.set("status", (Object)"A");
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return log;
    }

    public static void sendDispatchOrderMsg(Object saleorderid) {
        DynamicObject saleorder = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"billno,orderdate,customer.name,customerphone,createtime,confirmarrivaldate,totalorderamount,totalqty", (QFilter[])new QFilter[]{new QFilter("id", "=", saleorderid)});
        SimpleDateFormat d = new SimpleDateFormat("d");
        SimpleDateFormat m = new SimpleDateFormat("M");
        StringBuilder content = new StringBuilder();
        Date orderDate = saleorder.getDate("orderdate");
        if (orderDate == null) {
            orderDate = new Date();
        }
        content.append(ResManager.loadKDString((String)"\u3010\u76ca\u5ba2\u3011\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684", (String)"ShortMessageUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(d.format(orderDate));
        content.append(ResManager.loadKDString((String)"\u65e5\u8ba2\u5355(\u91cd\u91cf\uff1a", (String)"ShortMessageUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(saleorder.getBigDecimal("totalqty").setScale(2, 1));
        content.append(ResManager.loadKDString((String)"\u5343\u514b\uff0c\u91d1\u989d\uff1a", (String)"ShortMessageUtil_2", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(saleorder.getBigDecimal("totalorderamount").setScale(2, 1));
        content.append(ResManager.loadKDString((String)"\u5143)\u9884\u8ba1", (String)"ShortMessageUtil_3", (String)"drp-mdr-common", (Object[])new Object[0]));
        Date date = saleorder.getDate("confirmarrivaldate");
        content.append(m.format(date));
        content.append(ResManager.loadKDString((String)"\u6708", (String)"ShortMessageUtil_4", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(d.format(date));
        content.append(ResManager.loadKDString((String)"\u65e5", (String)"ShortMessageUtil_5", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(ResManager.loadKDString((String)"\u53d1\u8d27\uff0c\u8bf7\u70b9\u51fb\u6b64\u94fe\u63a5\u786e\u8ba4\u8ba2\u5355\uff1a ", (String)"ShortMessageUtil_6", (String)"drp-mdr-common", (Object[])new Object[0]));
        String url = SysParamsUtil.getAllotUrl() + saleorderid;
        content.append(url);
        ArrayList<String> phonelist = new ArrayList<String>();
        String customerPhone = saleorder.getString("customerphone");
        phonelist.add(customerPhone.trim());
        DynamicObject log = ShortMessageUtil.addOrderMessageLog(phonelist, content.toString(), saleorder);
        ShortMessageUtil.sendmessage(phonelist, content.toString());
        log.set("status", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void sendAmountOrderMsg(Object saleorderid) {
        DynamicObject saleorder = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"billno,orderdate,customer.name,customerphone,createtime,confirmarrivaldate,totalorderamount,totalqty", (QFilter[])new QFilter[]{new QFilter("id", "=", saleorderid)});
        SimpleDateFormat d = new SimpleDateFormat("d");
        StringBuilder content = new StringBuilder();
        Date orderDate = saleorder.getDate("orderdate");
        if (orderDate == null) {
            orderDate = new Date();
        }
        content.append(ResManager.loadKDString((String)"\u3010\u76ca\u5ba2\u3011\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684", (String)"ShortMessageUtil_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(d.format(orderDate));
        content.append(ResManager.loadKDString((String)"\u65e5\u8ba2\u5355(\u91cd\u91cf\uff1a", (String)"ShortMessageUtil_1", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(saleorder.getBigDecimal("totalqty").setScale(2, 1));
        content.append(ResManager.loadKDString((String)"\u5343\u514b\uff0c\u91d1\u989d\uff1a", (String)"ShortMessageUtil_2", (String)"drp-mdr-common", (Object[])new Object[0]));
        content.append(saleorder.getBigDecimal("totalorderamount").setScale(2, 1));
        content.append(ResManager.loadKDString((String)"\u5143)\u5df2\u53d1\u8d27\uff0c\u8bf7\u70b9\u51fb\u6b64\u94fe\u63a5\u786e\u8ba4\u6536\u8d27\uff1a ", (String)"ShortMessageUtil_7", (String)"drp-mdr-common", (Object[])new Object[0]));
        String url = SysParamsUtil.getAmountUrl() + saleorderid;
        content.append(url);
        ArrayList<String> phonelist = new ArrayList<String>();
        String customerPhone = saleorder.getString("customerphone");
        phonelist.add(customerPhone.trim());
        DynamicObject log = ShortMessageUtil.addOrderMessageLog(phonelist, content.toString(), saleorder);
        ShortMessageUtil.sendmessage(phonelist, content.toString());
        log.set("status", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void sendCodeMsg(List<String> phoneList, String Content) {
        DynamicObject log = ShortMessageUtil.addMessageLog(phoneList, Content, null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        ShortMessageUtil.sendmessage(phoneList, Content);
    }
}

