/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public final class StringUtils {
    private StringUtils() {
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final boolean isEmpty(Object s) {
        if (s instanceof DynamicObjectCollection) {
            return ((DynamicObjectCollection)s).size() == 0;
        }
        return s == null || s.toString().trim().length() == 0;
    }

    public static final boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static final boolean isNotEmpty(Object s) {
        return !StringUtils.isEmpty(s);
    }

    public static final String urlEncode(String s) {
        String encodeStr = null;
        try {
            encodeStr = URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
        return encodeStr;
    }

    public static final String urlDecode(String s) {
        String decodeStr = null;
        try {
            decodeStr = URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
        return decodeStr;
    }

    public static boolean areNotEmpty(String[] values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtils.isEmpty(value);
            }
        }
        return result;
    }
}

