/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.apiclient.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.apiclient.common.APIResponse;
import kd.drp.mdr.common.apiclient.common.ClientPolicy;
import kd.drp.mdr.common.apiclient.common.Request;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public abstract class AbstractAPIClient {
    private static Logger log = Logger.getLogger(AbstractAPIClient.class);
    protected HttpClient httpClient;
    protected ClientPolicy clientPolicy;

    public AbstractAPIClient(ClientPolicy clientPolicy) {
        this.clientPolicy = clientPolicy;
        this.init();
    }

    public AbstractAPIClient() {
    }

    protected void init() {
        if (this.httpClient != null) {
            return;
        }
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"HttpComponents/1.1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)true);
        int REQUEST_TIMEOUT = 10000;
        int SO_TIMEOUT = 300000;
        params.setParameter("http.connection.timeout", (Object)REQUEST_TIMEOUT);
        params.setParameter("http.socket.timeout", (Object)SO_TIMEOUT);
        SchemeRegistry schreg = new SchemeRegistry();
        schreg.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schreg.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager pccm = new PoolingClientConnectionManager(schreg);
        pccm.setMaxTotal(500);
        pccm.setDefaultMaxPerRoute(50);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)pccm, (HttpParams)params);
    }

    public JSONObject send(Request request) throws KDBizException {
        JSONObject result;
        block8: {
            result = null;
            try {
                APIResponse res = this.getMethodResponse(request);
                if (res == null) {
                    throw new Exception(String.format(ResManager.loadKDString((String)"\u8c03\u7528%sAPI\u4e09\u6b21\u91cd\u8bd5\u5168\u90e8\u5931\u8d25\uff01", (String)"AbstractAPIClient_0", (String)"drp-mdr-common", (Object[])new Object[0]), this.getAPIClientName()));
                }
                StringBuilder builder = new StringBuilder();
                log.info((Object)builder.append("\u8c03\u7528").append(this.getAPIClientName()).append("API\u8fd4\u56de\u7ed3\u679c Response: ").append(res));
                if (res.isSuccess()) {
                    String data = res.getData();
                    if (data == null || data.length() == 0 || "null".equalsIgnoreCase(data)) {
                        result = new JSONObject();
                        result.put((Object)"description", (Object)res.getErrmsg());
                        result.put((Object)"errcode", (Object)res.getErrcode());
                    } else if (data.startsWith("[") && data.endsWith("]")) {
                        JSONObject array = JSONObject.fromObject((Object)data);
                        result = new JSONObject();
                        result.put((Object)"list", (Object)array);
                    } else {
                        result = JSONObject.fromObject((Object)data);
                    }
                    break block8;
                }
                builder = new StringBuilder();
                log.error((Object)builder.append("\u8c03\u7528").append(this.getAPIClientName()).append("API\uff0c\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\uff1a").append(request.getApiId()).append(" response:").append(res));
                throw new Exception(res.getErrmsg());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIResponse getMethodResponse(Request request) throws JSONException, Exception {
        int retry = 0;
        HttpRequestBase method = null;
        do {
            try {
                method = this.getMethod(request);
                HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status != 200) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("send message failed, urlPath:");
                    builder.append(request.getApiId());
                    builder.append(" status:");
                    builder.append(status);
                    builder.append(" response:");
                    builder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
                    log.error((Object)builder.toString());
                    throw new Exception(builder.toString());
                }
                APIResponse aPIResponse = this.innerParseResult(response);
                return aPIResponse;
            }
            catch (Exception e) {
                if (method != null) {
                    method.abort();
                }
                StringBuilder error = new StringBuilder();
                log.error((Object)error.append("\u8c03\u7528").append(this.getAPIClientName()).append("API\u5f02\u5e38\uff1a").append(e));
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        } while (++retry < 3);
        return null;
    }

    protected HttpRequestBase getMethod(Request request) throws Exception {
        HttpGet method = null;
        String urlPath = this.getUrlPath(request);
        if (Request.HttpMethodPolicy.GET == request.getHttpMethod()) {
            method = new HttpGet(urlPath);
        } else {
            if (Request.HttpMethodPolicy.PUT == request.getHttpMethod()) {
                method = new HttpPut(urlPath);
                try {
                    this.setPutParameters((HttpRequestBase)method, request);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
            if (Request.HttpMethodPolicy.DELETE == request.getHttpMethod()) {
                method = new HttpDelete(urlPath);
            } else {
                method = new HttpPost(urlPath);
                try {
                    this.setPostParameters((HttpRequestBase)method, request);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
        return method;
    }

    protected void setPutParameters(HttpRequestBase method, Request request) throws UnsupportedEncodingException {
        if (request.getPostParams() != null) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(request.getPostParams().size());
            for (Map.Entry<String, Object> entry : request.getPostParams().entrySet()) {
                if (entry.getValue() == null) continue;
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
            ((HttpResponse)method).setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            method.addHeader("Content-type", "application/x-www-form-urlencoded");
        } else if (!StringUtils.isEmpty(request.getRequestBody())) {
            StringEntity entity = new StringEntity(request.getRequestBody(), "UTF-8");
            ((HttpResponse)method).setEntity((HttpEntity)entity);
            method.setHeader("Content-type", "application/json; charset=UTF-8");
        }
    }

    private String getUrlPath(Request request) {
        StringBuilder url = new StringBuilder();
        String protocol = "";
        protocol = this.clientPolicy.isUseHttps() ? "https://" : "http://";
        url.append(protocol);
        url.append(this.clientPolicy.getServerHost());
        url.append(this.clientPolicy.getUrlPath());
        url.append(request.getApiId().getNamespace());
        url.append('/');
        url.append(request.getApiId().getName());
        return url.toString();
    }

    protected void setQueryString(HttpRequestBase method, Request request) throws UnsupportedEncodingException {
        Map<String, Object> params = request.getQueryStringParams();
        String url = method.getURI().toString();
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        ((HttpResponse)method).setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
        method.setHeader("Content-type", "application/json; charset=UTF-8");
    }

    protected void setPostParameters(HttpRequestBase method, Request request) throws UnsupportedEncodingException {
        if (!request.getPostParams().isEmpty()) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(request.getPostParams().size());
            for (Map.Entry<String, Object> entry : request.getPostParams().entrySet()) {
                if (entry.getValue() == null) continue;
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
            ((HttpPost)method).setEntity((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
            method.addHeader("Content-type", "application/x-www-form-urlencoded");
        } else if (!StringUtils.isEmpty(request.getRequestBody())) {
            StringEntity entity = new StringEntity(request.getRequestBody(), "UTF-8");
            ((HttpPost)method).setEntity((HttpEntity)entity);
            method.setHeader("Content-type", "application/json; charset=UTF-8");
        }
    }

    private APIResponse innerParseResult(HttpResponse response) throws IOException, Exception {
        String result = this.parseResponse(response);
        return this.parseResult(result);
    }

    protected abstract APIResponse parseResult(String var1) throws Exception;

    protected abstract String getAPIClientName();

    private String parseResponse(HttpResponse response) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        HttpEntity entity = response.getEntity();
        InputStream in = null;
        if (entity != null) {
            in = entity.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, Consts.UTF_8));
            String inputLine = null;
            while ((inputLine = reader.readLine()) != null) {
                contentBuffer.append(inputLine);
                contentBuffer.append('\n');
            }
            in.close();
        }
        contentBuffer.delete(contentBuffer.length() - 1, contentBuffer.length());
        return contentBuffer.toString();
    }

    public String getResultCharset() {
        return "UTF-8";
    }
}

