/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.apiclient.common;

public class ClientPolicy {
    private static Integer DEFAULT_HTTP_PORT = 80;
    private static Integer DEFAULT_HTTPS_PORT = 443;
    private static final ClientPolicy CBU_POLICY = new ClientPolicy("localhost");
    private boolean useHttps = false;
    private String serverHost;
    private int httpPort = DEFAULT_HTTP_PORT;
    private String urlPath;
    private int connectTimeout = 10000;
    private int soTimeout = 60000;
    private String queryStringCharset = "GB18030";
    private String contentCharset = "UTF-8";
    private boolean isProxy = false;
    private String proxyHost;
    private int proxyPort;
    private int httpsPort = DEFAULT_HTTPS_PORT;
    private int defaultVersion = 1;

    public static ClientPolicy getDefaultPolicy() {
        return CBU_POLICY.clone();
    }

    public ClientPolicy clone() {
        ClientPolicy newObj = new ClientPolicy(this.serverHost);
        newObj.httpPort = this.httpPort;
        newObj.httpsPort = this.httpsPort;
        newObj.defaultVersion = this.defaultVersion;
        return newObj;
    }

    protected ClientPolicy newPolicy() {
        return new ClientPolicy(this.serverHost);
    }

    public ClientPolicy(String serverHost) {
        if (serverHost == null || serverHost.length() < 1) {
            throw new IllegalArgumentException("serverHost can not be empty");
        }
        this.serverHost = serverHost;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public void setUseHttps(boolean useHttps) {
        this.useHttps = useHttps;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public ClientPolicy setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public ClientPolicy setHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientPolicy setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public ClientPolicy setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public String getQueryStringCharset() {
        return this.queryStringCharset;
    }

    public ClientPolicy setQueryStringCharset(String queryStringCharset) {
        this.queryStringCharset = queryStringCharset;
        return this;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public ClientPolicy setContentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
        return this;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public ClientPolicy setProxy(boolean isProxy) {
        this.isProxy = isProxy;
        return this;
    }

    public ClientPolicy setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public ClientPolicy setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public int getDefaultVersion() {
        return this.defaultVersion;
    }

    public ClientPolicy setDefaultVersion(int defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }
}

