/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.apiclient.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.drp.mdr.common.apiclient.common.APIId;
import kd.drp.mdr.common.apiclient.common.AccessToken;

public class Request {
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private APIId apiId;
    private HttpMethodPolicy httpMethod = HttpMethodPolicy.POST;
    private Map<String, Object> queryStringParams;
    private Map<String, Object> postParams;
    private String requestBody;
    private Map<String, String> attachments;

    public Request(APIId apiId) {
        this.apiId = apiId;
        this.queryStringParams = new HashMap<String, Object>();
        this.postParams = new HashMap<String, Object>();
    }

    public Request(String namespace, String name) {
        this(new APIId(namespace, name));
    }

    public Request(String namespace, String name, int version) {
        this(new APIId(namespace, name, version));
    }

    public APIId getApiId() {
        return this.apiId;
    }

    public HttpMethodPolicy getHttpMethod() {
        return this.httpMethod;
    }

    public Request setHttpMethod(HttpMethodPolicy httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public Map<String, Object> getQueryStringParams() {
        return this.queryStringParams;
    }

    public Map<String, Object> getPostParams() {
        return this.postParams;
    }

    public Request setAttachment(String name, String value) {
        return this;
    }

    public Map<String, String> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new LinkedHashMap<String, String>();
        }
        return this.attachments;
    }

    public Request addQueryStringParam(String name, Object value) {
        this.getQueryStringParams().put(name, value);
        return this;
    }

    public Request addPostParam(String name, Object value) {
        this.getPostParams().put(name, value);
        return this;
    }

    public String getAccessToken() {
        return (String)this.queryStringParams.get(KEY_ACCESS_TOKEN);
    }

    public void setAccessToken(AccessToken accessToken) {
        this.addQueryStringParam(KEY_ACCESS_TOKEN, accessToken.getToken());
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public static enum HttpMethodPolicy {
        POST,
        GET,
        PUT,
        DELETE;

    }
}

