/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.apiclient.jdstore;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.apiclient.common.APIResponse;
import kd.drp.mdr.common.apiclient.common.AbstractAPIClient;
import kd.drp.mdr.common.apiclient.common.ClientPolicy;
import kd.drp.mdr.common.apiclient.common.Request;
import kd.drp.mdr.common.apiclient.jdstore.JDStoreAPIConst;
import kd.drp.mdr.common.apiclient.jdstore.JDStoreCodecUtil;
import kd.drp.mdr.common.matetype.Dto;
import kd.drp.mdr.common.matetype.impl.BaseDto;
import kd.drp.mdr.common.message.json.JsonHelper;
import kd.drp.mdr.common.util.SysParamsUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class JDStoreAPIClient
extends AbstractAPIClient {
    private static final Logger log = Logger.getLogger(JDStoreAPIClient.class);
    private static final String VERSION = "v";
    private static final String METHOD = "method";
    private static final String APP_KEY = "app_key";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String APP_SECRET = "app_secret";
    private static final String BUY_PARAM_JSON = "360buy_param_json";
    private static final String TIME_STAMP = "timestamp";
    private static final String SIGN = "sign";
    public static final String ECLPSONO = "eclpSoNo";

    public JDStoreAPIClient(ClientPolicy clientPolicy) {
        super(clientPolicy);
    }

    public void getCode() throws Exception {
        Request request = new Request("oauth", "authorize");
        request.setHttpMethod(Request.HttpMethodPolicy.GET);
        request.addQueryStringParam("response_type", "code");
        request.addQueryStringParam("client_id", JDStoreAPIConst.getAppKey());
        request.addQueryStringParam("redirect_uri", JDStoreAPIConst.getRedirectUrl());
        this.send(request);
    }

    private Request getRequest(String method, String appJson) {
        Request request = new Request("", "routerjson");
        request.setHttpMethod(Request.HttpMethodPolicy.POST);
        request.addPostParam(VERSION, "2.0");
        request.addPostParam(METHOD, method);
        request.addPostParam(ACCESS_TOKEN, JDStoreAPIConst.getAccessToken());
        request.addPostParam(APP_KEY, JDStoreAPIConst.getAppKey());
        request.addPostParam(APP_SECRET, JDStoreAPIConst.getAppSecret());
        request.addPostParam(BUY_PARAM_JSON, appJson);
        Map<String, Object> data = request.getPostParams();
        String sign = this.sign(data, JDStoreAPIConst.getAppSecret());
        request.addPostParam(SIGN, sign);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        request.addPostParam(TIME_STAMP, format.format(new Date()));
        return request;
    }

    public Dto sendOrderToJDStore(DynamicObject saleorder) throws KDBizException {
        String method = "jingdong.eclp.order.addOrder";
        String appJson = this.sendOrderToJDStoreJson(saleorder);
        Request request = this.getRequest(method, appJson);
        BaseDto resultDto = new BaseDto(Boolean.FALSE);
        JSONObject result = this.send(request);
        try {
            if (this.checkIsSuccess(result, resultDto)) {
                String eclpSoNo = result.getJSONObject("jingdong_eclp_order_addOrder_responce").getString(ECLPSONO);
                resultDto.put(ECLPSONO, eclpSoNo);
                resultDto.setSuccess(Boolean.TRUE);
            }
            return resultDto;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String sendOrderToJDStoreJson(DynamicObject saleorder) {
        TreeMap<String, String> data = new TreeMap<String, String>();
        data.put("isvUUID", saleorder.getString("billno"));
        data.put("isvSource", "ISV0000000000003");
        data.put("shopNo", "ESP0020000038381");
        data.put("departmentNo", "EBU4418046550810");
        String warehouseNo = SysParamsUtil.getJDWarehouseNo();
        if (warehouseNo.isEmpty()) {
            warehouseNo = "110013767";
        }
        data.put("warehouseNo", warehouseNo);
        String shipperNo = SysParamsUtil.getJDShipperNo();
        if (shipperNo.isEmpty()) {
            shipperNo = "CYS4418046511227";
        }
        data.put("shipperNo", shipperNo);
        data.put("salePlatformSource", "6");
        data.put("soType", "2");
        data.put("consigneeName", saleorder.getString("consignee"));
        data.put("consigneeMobile", saleorder.getString("consigneephone"));
        data.put("consigneeAddress", saleorder.getString("address"));
        StringBuilder orderMark = new StringBuilder("00000000000000000000000000000000000000000000000000");
        orderMark.replace(9, 10, "1");
        orderMark.replace(36, 37, "1");
        data.put("orderMark", orderMark.toString());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bbc_saleorder");
        if (entityType.getAllFields().containsKey("insuredPriceFlag")) {
            String insuredPriceFlag = saleorder.getBoolean("insuredPriceFlag") ? "1" : "0";
            data.put("insuredPriceFlag", insuredPriceFlag);
            data.put("insuredValue", saleorder.getString("insuredValue"));
        }
        DynamicObjectCollection itementrys = saleorder.getDynamicObjectCollection("itementry");
        ArrayList<String> goodsNoList = new ArrayList<String>();
        ArrayList<String> qtyList = new ArrayList<String>();
        for (DynamicObject itementry : itementrys) {
            goodsNoList.add(itementry.getDynamicObject("item").getString("easnum"));
            qtyList.add(itementry.getBigDecimal("qty").setScale(0, 5).toString());
        }
        String goodsNo = String.join((CharSequence)",", goodsNoList);
        String quantity = String.join((CharSequence)",", qtyList);
        data.put("isvGoodsNo", goodsNo);
        data.put("quantity", quantity);
        return JsonHelper.encodeObject2Json(data);
    }

    public Dto cancelOrderFromJDStore(DynamicObject saleorder) throws KDBizException {
        String method = "jingdong.eclp.order.cancelOrder";
        String appJson = this.getOrderStatusFromJDStoreJson(saleorder);
        Request request = this.getRequest(method, appJson);
        BaseDto resultDto = new BaseDto(Boolean.FALSE);
        JSONObject result = this.send(request);
        try {
            if (this.checkIsSuccess(result, resultDto)) {
                String msg = result.getJSONObject("jingdong_eclp_order_cancelOrder_responce").getJSONObject("cancelorder_result").getString("msg");
                resultDto.put("msg", msg);
                resultDto.setSuccess(Boolean.TRUE);
            }
            return resultDto;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public Dto getOrderStatusFromJDStore(DynamicObject saleorder) throws KDBizException {
        String method = "jingdong.eclp.order.queryOrderStatus";
        String appJson = this.getOrderStatusFromJDStoreJson(saleorder);
        Request request = this.getRequest(method, appJson);
        BaseDto resultDto = new BaseDto(Boolean.FALSE);
        JSONObject result = this.send(request);
        try {
            if (this.checkIsSuccess(result, resultDto)) {
                JSONArray orderStatusList = result.getJSONObject("jingdong_eclp_order_queryOrderStatus_responce").getJSONObject("queryorderstatus_result").getJSONArray("orderStatusList");
                resultDto.put("orderStatusList", orderStatusList.toString());
                resultDto.setSuccess(Boolean.TRUE);
            }
            return resultDto;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String getOrderStatusFromJDStoreJson(DynamicObject saleorder) {
        TreeMap<String, String> data = new TreeMap<String, String>();
        data.put(ECLPSONO, saleorder.getString("outsidelogisticsno"));
        return JsonHelper.encodeObject2Json(data);
    }

    public Dto getOrderDetailFromJDStore(DynamicObject saleorder) throws KDBizException {
        String method = "jingdong.eclp.order.queryOrder";
        String appJson = this.getOrderDetailFromJDStoreJson(saleorder);
        Request request = this.getRequest(method, appJson);
        BaseDto resultDto = new BaseDto(Boolean.FALSE);
        JSONObject result = this.send(request);
        try {
            if (this.checkIsSuccess(result, resultDto)) {
                JSONObject orderDetail = result.getJSONObject("jingdong_eclp_order_queryOrder_responce").getJSONObject("queryorder_result");
                resultDto.put("orderDetail", orderDetail.toString());
                resultDto.setSuccess(Boolean.TRUE);
            }
            return resultDto;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String getOrderDetailFromJDStoreJson(DynamicObject saleorder) {
        TreeMap<String, String> data = new TreeMap<String, String>();
        data.put(ECLPSONO, saleorder.getString("outsidelogisticsno"));
        return JsonHelper.encodeObject2Json(data);
    }

    public Dto getOrderPacksFromJDStore(DynamicObject saleorder) throws KDBizException {
        String method = "jingdong.eclp.order.queryOrderPacks";
        String appJson = this.getOrderDetailFromJDStoreJson(saleorder);
        Request request = this.getRequest(method, appJson);
        BaseDto resultDto = new BaseDto(Boolean.FALSE);
        JSONObject result = this.send(request);
        try {
            if (this.checkIsSuccess(result, resultDto)) {
                JSONArray orderPacks = result.getJSONObject("jingdong_eclp_order_queryOrderPacks_responce").getJSONArray("queryorderpacks_result");
                resultDto.put("orderPacks", orderPacks.toString());
                resultDto.setSuccess(Boolean.TRUE);
            }
            return resultDto;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public Dto getWaybillTraceFromJDStore(String waybillno) throws KDBizException {
        String method = "jingdong.ldop.receive.trace.get";
        String appJson = this.getWaybillTraceFromJDStoreJson(waybillno);
        Request request = this.getRequest(method, appJson);
        BaseDto resultDto = new BaseDto(Boolean.FALSE);
        JSONObject result = this.send(request);
        try {
            if (this.checkIsSuccess(result, resultDto)) {
                JSONObject resultData = result.getJSONObject("jingdong_ldop_receive_trace_get_responce").getJSONObject("querytrace_result");
                String code = resultData.getString("code");
                if ("200".equals(code)) {
                    resultDto.setErrorMsg(resultData.getString("messsage"));
                } else if ("100".equals(code)) {
                    JSONArray returnData = resultData.getJSONArray("data");
                    resultDto.put("returnData", returnData.toString());
                    resultDto.setSuccess(Boolean.TRUE);
                }
            }
            return resultDto;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String getWaybillTraceFromJDStoreJson(String waybillno) {
        TreeMap<String, String> data = new TreeMap<String, String>();
        data.put("customerCode", "027K242102");
        data.put("waybillCode", waybillno);
        return JsonHelper.encodeObject2Json(data);
    }

    private boolean checkIsSuccess(JSONObject result, Dto resultDto) {
        boolean isSuccess = true;
        if (result.containsKey((Object)"error_response")) {
            String errorMsg = result.getJSONObject("error_response").getString("zh_desc");
            resultDto.setErrorMessage(errorMsg);
            isSuccess = false;
        }
        return isSuccess;
    }

    private String sign(Map<String, String> pmap, String appSecret) {
        StringBuilder sb = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.areNotEmpty(new String[]{name, value})) continue;
            sb.append(name).append(value);
        }
        sb.append(appSecret);
        String result = JDStoreCodecUtil.md5(sb.toString());
        return result;
    }

    @Override
    protected APIResponse parseResult(String response) throws KDBizException {
        JSONObject json;
        try {
            json = JSONObject.fromObject((Object)response);
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u6790API\u7ed3\u679c\uff1a" + response + "\uff1b\u5f02\u5e38\uff1a" + e));
            throw new KDBizException(e.getMessage());
        }
        String errCode = json.optString("errcode");
        String errMsg = json.optString("errmsg");
        String data = json.optString("data");
        if (errCode == null || errCode.length() == 0) {
            errCode = "0";
            errMsg = "success";
            data = response;
        }
        return new APIResponse(errCode, errMsg, data);
    }

    @Override
    protected String getAPIClientName() {
        return ResManager.loadKDString((String)"\u4eac\u4e1c\u7269\u6d41", (String)"JDStoreAPIClient_0", (String)"drp-mdr-common", (Object[])new Object[0]);
    }
}

