/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.apiclient.jdstore;

import kd.bos.dataentity.entity.DynamicObject;
import kd.drp.mdr.common.apiclient.common.ClientPolicy;
import kd.drp.mdr.common.apiclient.jdstore.JDStoreAPIClient;
import kd.drp.mdr.common.apiclient.jdstore.JDStoreAPIConst;
import kd.drp.mdr.common.matetype.Dto;

public class JDStoreAPIInvokeService {
    private static JDStoreAPIClient oauthClient;
    private static JDStoreAPIClient client;
    private static volatile boolean isOauthInit;
    private static volatile boolean isInit;

    private static synchronized void oauthInit() {
        if (isOauthInit) {
            return;
        }
        ClientPolicy clientPolicy = new ClientPolicy(JDStoreAPIConst.getOauthHost());
        clientPolicy.setUseHttps(true);
        clientPolicy.setUrlPath(JDStoreAPIConst.getUrlPath());
        oauthClient = new JDStoreAPIClient(clientPolicy);
        isOauthInit = true;
    }

    private static synchronized void init() {
        if (isInit) {
            return;
        }
        ClientPolicy clientPolicy = new ClientPolicy(JDStoreAPIConst.getHost());
        clientPolicy.setUseHttps(true);
        clientPolicy.setUrlPath("");
        client = new JDStoreAPIClient(clientPolicy);
        isInit = true;
    }

    public static void getCode() throws Exception {
        if (oauthClient == null) {
            JDStoreAPIInvokeService.oauthInit();
        }
        oauthClient.getCode();
    }

    public static Dto sendOrderToJDStore(DynamicObject saleorder) {
        if (client == null) {
            JDStoreAPIInvokeService.init();
        }
        return client.sendOrderToJDStore(saleorder);
    }

    public static Dto cancelOrderFromJDStore(DynamicObject saleorder) {
        if (client == null) {
            JDStoreAPIInvokeService.init();
        }
        return client.cancelOrderFromJDStore(saleorder);
    }

    public static Dto getOrderStatusFromJDStore(DynamicObject saleorder) {
        if (client == null) {
            JDStoreAPIInvokeService.init();
        }
        return client.getOrderStatusFromJDStore(saleorder);
    }

    public static Dto getOrderDetailFromJDStore(DynamicObject saleorder) {
        if (client == null) {
            JDStoreAPIInvokeService.init();
        }
        return client.getOrderDetailFromJDStore(saleorder);
    }

    public static Dto getOrderPacksFromJDStore(DynamicObject saleorder) {
        if (client == null) {
            JDStoreAPIInvokeService.init();
        }
        return client.getOrderPacksFromJDStore(saleorder);
    }

    public static Dto getWaybillTraceFromJDStore(String waybillno) {
        if (client == null) {
            JDStoreAPIInvokeService.init();
        }
        return client.getWaybillTraceFromJDStore(waybillno);
    }
}

