/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.drp.mdr.common.cache.LRUCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CacheUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class CustomerTreeCache {
    private static final int MAX_COMPANY_SIZE = 128;
    private Map<String, AuthCust> authCustMap;
    private Map<Object, List<AuthCust>> authownerMap;
    private Map<Object, List<AuthCust>> customerMap;
    private static final Map<String, Long> DATA_TIME_STAMP_MAP = new HashMap<String, Long>();
    private static final LRUCache<String, CustomerTreeCache> TREE_CACHE_MAP = new LRUCache(128);
    private static final String PRE_KEY = "customerTreeReLoadFlag";

    public static synchronized CustomerTreeCache getCache() {
        CustomerTreeCache.checkAndReLoadCache();
        CustomerTreeCache localTreeCache = TREE_CACHE_MAP.get(UserUtil.getAcctId());
        if (localTreeCache == null) {
            localTreeCache = CustomerTreeCache.refreshAndGetCache();
        }
        return localTreeCache;
    }

    public static void refreshCache() {
        CustomerTreeCache.refreshAndGetCache();
        CustomerTreeCache.reSetDataTimeStamp();
    }

    private static CustomerTreeCache refreshAndGetCache() {
        String fields = F7Utils.getSelectCols("authowner", "customer", "marketability", "enable", "isdefault");
        int[] size = CustomerTreeCache.caculMapSize();
        final HashMap<String, AuthCust> tempAuthCustMap = new HashMap<String, AuthCust>(size[0]);
        final HashMap<Object, List<AuthCust>> tempAuthownerMap = new HashMap<Object, List<AuthCust>>(size[1]);
        final HashMap<Object, List<AuthCust>> tempCustomerMap = new HashMap<Object, List<AuthCust>>(size[2]);
        QueryUtil.queryDataSet((Consumer<? super Row>)new Consumer<Row>(){

            @Override
            public void accept(Row row) {
                AuthCust cust = CustomerTreeCache.createAuthCust(row);
                tempAuthCustMap.put(cust.getKey(), cust);
                CustomerTreeCache.updateAuthOwnerMap(tempAuthownerMap, cust);
                CustomerTreeCache.updateCustomerMap(tempCustomerMap, cust);
            }
        }, ResManager.loadKDString((String)"\u6e20\u9053\u6811\u7f13\u5b58\u52a0\u8f7d\u5931\u8d25\uff1a", (String)"CustomerTreeCache_0", (String)"drp-mdr-common", (Object[])new Object[0]), "mdr_customer_authorize", fields, null, null);
        CustomerTreeCache newTreeCache = new CustomerTreeCache(tempAuthCustMap, tempAuthownerMap, tempCustomerMap);
        TREE_CACHE_MAP.put(UserUtil.getAcctId(), newTreeCache);
        return newTreeCache;
    }

    private static int[] caculMapSize() {
        int[] size = new int[]{64, 64, 64};
        CustomerTreeCache cache = TREE_CACHE_MAP.get(UserUtil.getAcctId());
        if (cache != null) {
            if (cache.authCustMap != null) {
                size[0] = cache.authCustMap.size();
            }
            if (cache.authownerMap != null) {
                size[1] = cache.authownerMap.size();
            }
            if (cache.customerMap != null) {
                size[2] = cache.customerMap.size();
            }
        }
        return size;
    }

    private static AuthCust createAuthCust(Row row) {
        return new AuthCust(row.getLong("authowner"), row.getLong("customer"), row.getString("enable"), row.getBoolean("marketability"), row.getBoolean("isdefault"));
    }

    private static void updateCustomerMap(Map<Object, List<AuthCust>> tempCustomerMap, AuthCust cust) {
        List<AuthCust> tempCustomers = tempCustomerMap.get(cust.getCustomerId());
        if (tempCustomers == null) {
            tempCustomers = new ArrayList<AuthCust>();
            tempCustomerMap.put(cust.getCustomerId(), tempCustomers);
        }
        tempCustomers.add(cust);
    }

    private static void updateAuthOwnerMap(Map<Object, List<AuthCust>> tempAuthownerMap, AuthCust cust) {
        List<AuthCust> tempAuthowners = tempAuthownerMap.get(cust.getAuthOwnerId());
        if (tempAuthowners == null) {
            tempAuthowners = new ArrayList<AuthCust>();
            tempAuthownerMap.put(cust.getAuthOwnerId(), tempAuthowners);
        }
        tempAuthowners.add(cust);
    }

    private static void checkAndReLoadCache() {
        String key = PRE_KEY + UserUtil.getAcctId();
        Long cacheTimeStamp = CacheUtil.get(key, Long.class);
        if (cacheTimeStamp == null) {
            return;
        }
        Long localTimeStamp = DATA_TIME_STAMP_MAP.get(key);
        if (!cacheTimeStamp.equals(localTimeStamp)) {
            CustomerTreeCache.refreshAndGetCache();
            DATA_TIME_STAMP_MAP.put(key, localTimeStamp);
        }
    }

    private static void reSetDataTimeStamp() {
        Long localTimeStamp = System.currentTimeMillis();
        String key = PRE_KEY + UserUtil.getAcctId();
        DATA_TIME_STAMP_MAP.put(key, localTimeStamp);
        CacheUtil.put(key, localTimeStamp);
    }

    private CustomerTreeCache(Map<String, AuthCust> authCustMap, Map<Object, List<AuthCust>> authownerMap, Map<Object, List<AuthCust>> customerMap) {
        this.authCustMap = authCustMap;
        this.authownerMap = authownerMap;
        this.customerMap = customerMap;
    }

    public Map<String, AuthCust> getAuthCustMap() {
        return this.authCustMap;
    }

    public Map<Object, List<AuthCust>> getAuthownerMap() {
        return this.authownerMap;
    }

    public Map<Object, List<AuthCust>> getCustomerMap() {
        return this.customerMap;
    }

    public static synchronized void updateTreeCacheDelete(List<AuthCust> relations) {
        CustomerTreeCache cache = CustomerTreeCache.getCache();
        Map<String, AuthCust> authCustMap = cache.getAuthCustMap();
        Collection<AuthCust> values = authCustMap.values();
        HashSet<AuthCust> allNode = new HashSet<AuthCust>(values);
        allNode.removeAll(relations);
        CustomerTreeCache.updateTreeCache(allNode);
        CustomerTreeCache.reSetDataTimeStamp();
    }

    public static synchronized void updateTreeCacheAdd(List<AuthCust> relations) {
        CustomerTreeCache cache = CustomerTreeCache.getCache();
        Map<String, AuthCust> authCustMap = cache.getAuthCustMap();
        Collection<AuthCust> values = authCustMap.values();
        HashSet<AuthCust> allNode = new HashSet<AuthCust>(relations.size() + values.size());
        allNode.addAll(relations);
        allNode.addAll(values);
        CustomerTreeCache.updateTreeCache(allNode);
        CustomerTreeCache.reSetDataTimeStamp();
    }

    private static void updateTreeCache(Set<AuthCust> allNode) {
        HashMap<String, AuthCust> tempAuthCustMap = new HashMap<String, AuthCust>(allNode.size());
        HashMap<Object, List<AuthCust>> tempAuthownerMap = new HashMap<Object, List<AuthCust>>();
        HashMap<Object, List<AuthCust>> tempCustomerMap = new HashMap<Object, List<AuthCust>>();
        for (AuthCust authCust : allNode) {
            tempAuthCustMap.put(authCust.getKey(), authCust);
            CustomerTreeCache.updateAuthOwnerMap(tempAuthownerMap, authCust);
            CustomerTreeCache.updateCustomerMap(tempCustomerMap, authCust);
        }
        CustomerTreeCache newTreeCache = new CustomerTreeCache(tempAuthCustMap, tempAuthownerMap, tempCustomerMap);
        TREE_CACHE_MAP.put(UserUtil.getAcctId(), newTreeCache);
    }
}

