/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.cache.LRUCache;
import kd.drp.mdr.common.cache.model.FCNode;
import kd.drp.mdr.common.strategy.DynamicObject2FCNodeStrategy;
import kd.drp.mdr.common.util.CacheUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ItemClassTreeCache {
    private static final int MAX_COMPANY_SIZE = 128;
    private static final LRUCache<String, ItemClassTreeCache> treeCacheMap = new LRUCache(128);
    private Map<Object, List<FCNode>> fatherMap;
    private Map<Object, FCNode> childMap;
    private static final Map<String, Long> DATA_TIME_STAMP_MAP = new HashMap<String, Long>();
    private static final String PRE_KEY = "ItemClassTreeReLoadFlag";

    private ItemClassTreeCache() {
    }

    public static ItemClassTreeCache getCache() {
        ItemClassTreeCache.checkAndReLoadCache();
        ItemClassTreeCache localTreeCache = ItemClassTreeCache.refreshAndGetCache();
        return localTreeCache;
    }

    private static ItemClassTreeCache refreshAndGetCache() {
        DynamicObjectCollection fcs = QueryServiceHelper.query((String)"mdr_item_class", (String)"id,parent", null);
        List<FCNode> nodes = FCNode.prase2FCNodes((List<DynamicObject>)fcs, new DynamicObject2FCNodeStrategy(){

            @Override
            public FCNode prase2FCNode(DynamicObject dy) {
                return new FCNode(dy.get("parent"), dy.get("id"));
            }
        });
        return ItemClassTreeCache.reloadCache(nodes);
    }

    public static void refreshCache() {
        ItemClassTreeCache.refreshAndGetCache();
        ItemClassTreeCache.reSetDataTimeStamp();
    }

    private static ItemClassTreeCache reloadCache(List<FCNode> nodes) {
        HashMap<Object, List<FCNode>> tempFMap = new HashMap<Object, List<FCNode>>();
        HashMap<Object, FCNode> tempCMap = new HashMap<Object, FCNode>(nodes.size());
        FCNode node = null;
        int len = nodes.size();
        for (int i = 0; i < len; ++i) {
            node = nodes.get(i);
            FCNode.handleFatherMap(tempFMap, node);
            tempCMap.put(node.getChild(), node);
        }
        ItemClassTreeCache tempCache = new ItemClassTreeCache();
        tempCache.fatherMap = tempFMap;
        tempCache.childMap = tempCMap;
        treeCacheMap.put(UserUtil.getAcctId(), tempCache);
        return tempCache;
    }

    public Map<Object, List<FCNode>> getFatherMap() {
        return this.fatherMap;
    }

    public Map<Object, FCNode> getChildMap() {
        return this.childMap;
    }

    private static void checkAndReLoadCache() {
        String key = PRE_KEY + UserUtil.getAcctId();
        Long cacheTimeStamp = CacheUtil.get(key, Long.class);
        if (cacheTimeStamp == null) {
            return;
        }
        Long localTimeStamp = DATA_TIME_STAMP_MAP.get(key);
        if (!cacheTimeStamp.equals(localTimeStamp)) {
            ItemClassTreeCache.refreshAndGetCache();
            DATA_TIME_STAMP_MAP.put(key, localTimeStamp);
        }
    }

    private static void reSetDataTimeStamp() {
        Long localTimeStamp = System.currentTimeMillis();
        String key = PRE_KEY + UserUtil.getAcctId();
        DATA_TIME_STAMP_MAP.put(key, localTimeStamp);
        CacheUtil.put(key, localTimeStamp);
    }
}

