/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private static final float hashMapLoadFactor = 0.75f;
    private LinkedHashMap<K, V> cache;
    private int cacheSize;

    public LRUCache() {
        this(1000);
    }

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        int capacity = (int)Math.ceil((double)cacheSize / 0.75) + 1;
        this.cache = new LinkedHashMap<K, V>(capacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LRUCache.this.cacheSize;
            }
        };
    }

    public synchronized V get(K key) {
        return this.cache.get(key);
    }

    public synchronized V put(K key, V value) {
        return this.cache.put(key, value);
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public synchronized Collection<Map.Entry<K, V>> getAll() {
        return new ArrayList<Map.Entry<K, V>>(this.cache.entrySet());
    }
}

