/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.LRUCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CustomerSalerUtil;

public class ValidatorCache {
    private final LRUCache<String, Object> cache = new LRUCache(512);

    public boolean isAuthRelation(Object authId, Object customerId) {
        String key = "isAuthRelation" + authId + customerId;
        Object relation = this.cache.get(key);
        if (relation == null) {
            CustomerTreeCache tree = CustomerTreeCache.getCache();
            Map<String, AuthCust> authCustMap = tree.getAuthCustMap();
            AuthCust ac = authCustMap.get("" + authId + customerId);
            relation = ac != null && ac.isValid();
            this.cache.put(key, relation);
        }
        return (Boolean)relation;
    }

    public boolean isSaleControlItem(Object authId, Object customerId, Object itemId) {
        String key = "isSaleControlItem" + authId + customerId;
        Set<Object> idsSet = this.cache.get(key);
        if (idsSet == null) {
            idsSet = ItemSaleControlUtil.getAllCanSaleItemIds(authId, customerId, null);
            this.cache.put(key, idsSet);
        }
        Set ids = idsSet;
        return ids.contains(itemId);
    }

    public boolean isLegalSaler(Object authId, Object customerId, Object saleId) {
        Collection<Object> ids;
        String key = "isLegalSaler" + authId + customerId;
        HashSet<Object> idsSet = this.cache.get(key);
        if (idsSet == null) {
            ids = CustomerSalerUtil.queryCustomerSalerPK(customerId, authId);
            idsSet = new HashSet<Object>(ids);
        }
        ids = idsSet;
        return ids.contains(saleId);
    }
}

