/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache.model;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;

public class AuthCust
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object authOwnerId;
    private Object customerId;
    private String key;
    private boolean valid;
    private boolean isdefault;
    private boolean marketability;

    public boolean isValid() {
        return this.valid;
    }

    public boolean isdefault() {
        return this.isdefault;
    }

    public AuthCust(DynamicObject customerAuthInfo) {
        this(customerAuthInfo.getDynamicObject("authowner").getLong("id"), customerAuthInfo.getDynamicObject("customer").getLong("id"), customerAuthInfo.getString("enable"), customerAuthInfo.getBoolean("marketability"), customerAuthInfo.getBoolean("isdefault"));
    }

    public AuthCust(Long authOwnerId, Long customerId, String enable, boolean marketability, boolean isdefault) {
        this.authOwnerId = authOwnerId;
        this.customerId = customerId;
        this.marketability = marketability;
        this.valid = "1".equals(enable);
        this.isdefault = isdefault;
        this.key = AuthCust.calcuKey(authOwnerId, customerId);
    }

    public static String calcuKey(Object authOwnerId, Object customerId) {
        return String.format("%s%s", authOwnerId, customerId);
    }

    public Object getAuthOwnerId() {
        return this.authOwnerId;
    }

    public Object getCustomerId() {
        return this.customerId;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isMarketability() {
        return this.marketability;
    }

    public void setMarketability(boolean marketability) {
        this.marketability = marketability;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthCust other = (AuthCust)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public void updateInfo(AuthCust ac) {
        this.marketability = ac.marketability;
        this.valid = ac.valid;
    }

    public String toString() {
        return "AuthCust [authOwnerId=" + this.authOwnerId + ", customerId=" + this.customerId + ", key=" + this.key + ", valid=" + this.valid + ", marketability=" + this.marketability + ", isdefault=" + this.isdefault + "]";
    }
}

