/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.drp.mdr.common.strategy.DynamicObject2FCNodeStrategy;

public class FCNode {
    private Object father;
    private Object child;

    public FCNode(Object father, Object child) {
        this.father = father;
        this.child = child;
    }

    public Object getFather() {
        return this.father;
    }

    public Object getChild() {
        return this.child;
    }

    public static List<FCNode> prase2FCNodes(List<DynamicObject> dys, DynamicObject2FCNodeStrategy fun) {
        int size = dys.size();
        ArrayList<FCNode> nodes = new ArrayList<FCNode>(size);
        for (int i = 0; i < size; ++i) {
            nodes.add(fun.prase2FCNode(dys.get(i)));
        }
        return nodes;
    }

    public static List<Object> getFatherIds(List<FCNode> nodes) {
        ArrayList<Object> ids = new ArrayList<Object>(nodes.size());
        Object fid = null;
        for (FCNode node : nodes) {
            fid = node.getFather();
            if (fid == null || fid.equals(0L)) continue;
            ids.add(fid);
        }
        return ids;
    }

    public static void handleFatherMap(Map<Object, List<FCNode>> map, FCNode node) {
        Object fid = node.getFather();
        List tList = map.computeIfAbsent(fid, k -> new ArrayList());
        tList.add(node);
    }

    public static List<Object> getChildIds(List<FCNode> nodes) {
        if (nodes == null) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> ids = new ArrayList<Object>(nodes.size());
        for (FCNode node : nodes) {
            ids.add(node.getChild());
        }
        return ids;
    }

    public String toString() {
        return "FCNode [father=" + this.father + ", child=" + this.child + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + (this.father == null ? 0 : this.father.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FCNode other = (FCNode)obj;
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        return !(this.father == null ? other.father != null : !this.father.equals(other.father));
    }
}

