/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.cache.model.PathSaleInfo;
import kd.drp.mdr.common.itemclass.ItemClassUtil;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;

public class ItemSaleInfo {
    private static final String SPLIT_FLAG = "_";
    public static final String STRATEGY_CAN = "A";
    public static final String STRATEGY_NOT = "B";
    public static final String STRATEGY_CAN_NOT = "C";
    public static final String CAN_SALE = "A";
    public static final String CAN_NOT_SALE = "B";
    public static final String CAN_SALE_NOT_ENABLE = "C";
    private Map<String, AuthCust> authCustMap;
    private Map<Object, List<AuthCust>> customerMap;
    private Map<Object, String> strategyMap;

    public ItemSaleInfo() {
        CustomerTreeCache cache = CustomerTreeCache.getCache();
        this.authCustMap = cache.getAuthCustMap();
        this.customerMap = cache.getCustomerMap();
    }

    public PathSaleInfo querySaleRules(Object customerId) {
        List<List<Object>> pathList = this.getRootPaths(customerId);
        return this.analyzePathList(pathList);
    }

    private void initStrategyMap(List<List<Object>> pathList) {
        HashSet<Object> customerIds = new HashSet<Object>();
        for (List<Object> list : pathList) {
            customerIds.addAll(list);
        }
        this.strategyMap = this.getSaleStrategy(customerIds);
    }

    private Map<Object, String> getSaleStrategy(Collection<Object> customerIds) {
        return CustomerParamsUtil.getSaleControlType(customerIds);
    }

    public PathSaleInfo querySaleRules(Object authOwnerId, Object customerId) {
        List<List<Object>> pathList = this.getRootPaths(authOwnerId, customerId);
        return this.analyzePathList(pathList);
    }

    private PathSaleInfo analyzePathList(List<List<Object>> pathList) {
        this.initStrategyMap(pathList);
        PathSaleInfo pathInfo = null;
        int len = pathList.size();
        for (int i = 0; i < len; ++i) {
            if (i == 0) {
                pathInfo = this.analyzePath(pathList.get(i));
                continue;
            }
            pathInfo.mergePathCanSaleInfo(this.analyzePath(pathList.get(i)));
        }
        return pathInfo;
    }

    public List<List<Object>> getRootPaths(Object authOwnerId, Object customerId) {
        HashSet<String> paths = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        this.getRootStrPaths(authOwnerId, builder.append(customerId).append('_').append(authOwnerId).toString(), paths);
        return this.analyzePathStrs(paths);
    }

    private void getRootStrPaths(Object customerId, String prePathStr, Set<String> path) {
        Set<Object> owners = this.getAuthOwners(customerId);
        if (owners.isEmpty()) {
            path.add(prePathStr);
        } else {
            for (Object id : owners) {
                this.getRootStrPaths(id, prePathStr + SPLIT_FLAG + id, path);
            }
        }
    }

    private List<List<Object>> getRootPaths(Object customerId) {
        HashSet<String> paths = new HashSet<String>();
        this.getRootStrPaths(customerId, customerId.toString(), paths);
        return this.analyzePathStrs(paths);
    }

    private List<List<Object>> analyzePathStrs(Set<String> paths) {
        ArrayList<List<Object>> pathList = new ArrayList<List<Object>>(paths.size());
        for (String pathStr : paths) {
            pathList.add(this.analyzePathStr(pathStr));
        }
        return pathList;
    }

    private List<Object> analyzePathStr(String path) {
        String[] strs = path.split(SPLIT_FLAG);
        ArrayList<Object> ids = new ArrayList<Object>(strs.length);
        for (String str : strs) {
            ids.add(Long.valueOf(str));
        }
        return ids;
    }

    public Set<Object> getAuthOwners(Object customerId) {
        HashSet<Object> owners = new HashSet<Object>();
        List<AuthCust> list = this.customerMap.get(customerId);
        if (list != null) {
            for (AuthCust authCust : list) {
                if (!authCust.isValid()) continue;
                owners.add(authCust.getAuthOwnerId());
            }
        }
        return owners;
    }

    private String[] getPathStrategy(List<Object> path) {
        int len = path.size();
        String[] flags = new String[len];
        for (int i = 0; i < len; ++i) {
            flags[i] = this.strategyMap.get(path.get(i));
        }
        return flags;
    }

    private void queryCustomerGroupParentsAndSelf(Object groupId, List<Object> emptyList) {
        if (groupId == null || groupId.equals(0L)) {
            return;
        }
        String key = "parent";
        QFilter fs = new QFilter("id", "=", groupId);
        DynamicObject one = QueryServiceHelper.queryOne((String)"mdr_customer_group", (String)key, (QFilter[])fs.toArray());
        if (one == null) {
            return;
        }
        emptyList.add(groupId);
        Object newGroupId = one.get(key);
        this.queryCustomerGroupParentsAndSelf(newGroupId, emptyList);
    }

    private void queryCustomerGroupParents(List<Object> customerGroupIds, List<Object> emptyList) {
        if (customerGroupIds == null || customerGroupIds.size() == 0) {
            return;
        }
        String key = "parent";
        QFilter fs = new QFilter("id", "in", customerGroupIds);
        DynamicObjectCollection groupParents = QueryServiceHelper.query((String)"mdr_customer_group", (String)key, (QFilter[])fs.toArray());
        if (groupParents == null || groupParents.size() == 0) {
            return;
        }
        emptyList.addAll(customerGroupIds);
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject groupDyn : groupParents) {
            Object parentId = groupDyn.get(key);
            if (parentId.equals(0L)) continue;
            list.add(parentId);
        }
        this.queryCustomerGroupParents(list, emptyList);
    }

    private void queryRegionParentsAndSelf(Object ownerId, Object regionId, List<Object> emptyList) {
        if (regionId == null || regionId.equals(0L)) {
            return;
        }
        QFilter fs = new QFilter("owner", "=", ownerId);
        fs.and("id", "=", regionId);
        String key = "parent";
        DynamicObject one = QueryServiceHelper.queryOne((String)"mdr_region", (String)key, (QFilter[])fs.toArray());
        if (one == null) {
            return;
        }
        emptyList.add(regionId);
        Object newRegionId = one.get(key);
        this.queryRegionParentsAndSelf(ownerId, newRegionId, emptyList);
    }

    private Set<Object> putItemIds(List<Map<String, Object>> rules) {
        Object itemId = null;
        HashSet<Object> items = new HashSet<Object>();
        HashSet<Object> itemClasses = new HashSet<Object>();
        for (Map<String, Object> rule : rules) {
            itemId = rule.get("item");
            if (itemId == null || itemId.equals(0L)) {
                itemClasses.add(rule.get("itemclass"));
                continue;
            }
            items.add(itemId);
        }
        if (!itemClasses.isEmpty()) {
            Set<Object> otherItems = ItemClassUtil.queryAllItemsByClasses(itemClasses);
            items.addAll(otherItems);
        }
        return items;
    }

    private boolean[] getMarketability(List<Object> path) {
        int len = path.size();
        boolean[] flags = new boolean[len];
        for (int i = 0; i < len - 1; ++i) {
            flags[i] = this.getMarketabilitys(path.get(i + 1), path.get(i));
        }
        return flags;
    }

    public boolean getMarketabilitys(Object authOwnerId, Object customerId) {
        StringBuilder builder = new StringBuilder();
        AuthCust authCust = this.authCustMap.get(builder.append(authOwnerId).append(customerId).toString());
        if (authCust == null) {
            return false;
        }
        return authCust.isMarketability();
    }

    private PathSaleInfo analyzePath(List<Object> path) {
        PathSaleInfo info = new PathSaleInfo();
        int size = path.size();
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u9500\u63a7\u5236\u8def\u5f84\uff1asize=0", (String)"ItemSaleInfo_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (size == 1) {
            info.getOwnerIds().add(path.get(0));
            return info;
        }
        boolean[] marketability = this.getMarketability(path);
        String[] pathStrategy = this.getPathStrategy(path);
        for (int i = path.size() - 2; i >= 0; --i) {
            this.handleRules(info, path.get(i), path.get(i + 1), marketability[i], pathStrategy[i + 1]);
        }
        return info;
    }

    private void handleRules(PathSaleInfo info, Object customerId, Object authOwnerId, boolean marketControl, String authOwnerStrategy) {
        if (marketControl) {
            switch (authOwnerStrategy) {
                case "A": {
                    this.handleRules4StrategyCan(info, customerId, authOwnerId);
                    return;
                }
                case "B": {
                    this.handleRules4StrategyNot(info, customerId, authOwnerId);
                    return;
                }
                case "C": {
                    this.handleRules4StrategyCanOrNot(info, customerId, authOwnerId);
                    return;
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53ef\u9500\u7b56\u7565:%s\u4e0d\u5b58\u5728\uff01", (String)"ItemSaleInfo_1", (String)"drp-mdr-common", (Object[])new Object[0]), authOwnerStrategy));
        }
        info.addCustomerItemIds(authOwnerId);
    }

    private void handleRules4StrategyCanOrNot(PathSaleInfo info, Object customerId, Object authOwnerId) {
        this.handleRules4StrategyCan(info, customerId, authOwnerId);
        this.handleRules4StrategyNot(info, customerId, authOwnerId);
    }

    private void handleRules4StrategyNot(PathSaleInfo info, Object customerId, Object authOwnerId) {
        List<Map<String, Object>> nRules = this.queryCustomerSaleRules(authOwnerId, customerId, "B");
        Set<Object> nItem = this.putItemIds(nRules);
        info.loadOwnerItems(authOwnerId);
        info.getItems().removeAll(nItem);
    }

    private void handleRules4StrategyCan(PathSaleInfo info, Object customerId, Object authOwnerId) {
        List<Map<String, Object>> rules = this.queryCustomerSaleRules(authOwnerId, customerId, "A");
        Set<Object> items = this.putItemIds(rules);
        info.loadOwnerItems(authOwnerId);
        info.getItems().retainAll(items);
    }

    private List<Map<String, Object>> queryCustomerSaleRules(Object authOwnerId, Object customerId, String canSaleFlag) {
        DynamicObject authBizInfo = CustomerUtil.getAuthBizInfo(authOwnerId, customerId);
        ArrayList<Object> regions = new ArrayList<Object>();
        DynamicObject region = authBizInfo.getDynamicObject("region");
        if (region != null) {
            Object regionId = region.getPkValue();
            this.queryRegionParentsAndSelf(authOwnerId, regionId, regions);
        }
        ArrayList<Object> groups = new ArrayList<Object>();
        QFilter filter = new QFilter("id", "=", (Object)1L);
        filter.and("classstandardid", ">", (Object)0);
        if (!QueryServiceHelper.exists((String)"mdr_cust_standard_apply", (QFilter[])filter.toArray())) {
            List<Object> customerGroupIds = CustomerUtil.getGroupsByCustomer(customerId);
            if (customerGroupIds != null && customerGroupIds.size() > 0) {
                this.queryCustomerGroupParents(customerGroupIds, groups);
            }
        } else {
            DynamicObject group = authBizInfo.getDynamicObject("customergroup");
            if (group != null) {
                Object customerGroupId = group.getPkValue();
                this.queryCustomerGroupParentsAndSelf(customerGroupId, groups);
            }
        }
        QFilter fs01 = new QFilter("owner", "=", authOwnerId);
        fs01.and("cansale", "=", (Object)canSaleFlag);
        fs01.and("enable", "=", (Object)"1");
        QFilter fs02 = new QFilter("customer", "=", customerId);
        if (!regions.isEmpty()) {
            fs02.or(new QFilter("region", "in", regions));
        }
        if (!groups.isEmpty()) {
            fs02.or(new QFilter("customergroup", "in", groups));
        }
        String[] cols = new String[]{"item", "itemclass"};
        List<Map<String, Object>> infos = QueryUtil.queryColumnsList("mdr_salecontrol", cols, new QFilter[]{fs01, fs02});
        return infos;
    }
}

