/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.cache.model;

import java.util.HashSet;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;

public class PathSaleInfo {
    private Set<Object> items;
    private Set<Object> ownerIds = new HashSet<Object>();

    public boolean isLoadedItems() {
        return this.items != null;
    }

    private void clearOwnerIds() {
        this.ownerIds.clear();
    }

    public Set<Object> loadOwnerItems() {
        if (this.ownerIds.size() != 0) {
            this.items = this.queryOwnerItemIds();
        } else if (this.items == null) {
            this.items = new HashSet<Object>();
        }
        return this.items;
    }

    public Set<Object> loadOwnerItems(Object ownerId) {
        if (this.ownerIds.contains(ownerId)) {
            return this.items;
        }
        if (this.items == null) {
            this.items = new HashSet<Object>();
        }
        this.items.addAll(this.queryOwnerItemIds(ownerId));
        this.ownerIds.add(ownerId);
        return this.items;
    }

    private Set<Object> queryOwnerItemIds(Object ownerId) {
        QFilter fs = F7Utils.buildMultiF7QFitler("mulowner", ownerId);
        Set<Object> itemids = QueryUtil.querySingleCol("mdr_item_info", "id", fs.toArray());
        fs = new QFilter("owner", "=", ownerId);
        itemids.addAll(QueryUtil.querySingleCol("dpm_item_combination", "id", fs.toArray()));
        return itemids;
    }

    private Set<Object> queryOwnerItemIds() {
        QFilter fs = F7Utils.buildMultiF7QFitler("mulowner", this.ownerIds);
        Set<Object> itemids = QueryUtil.querySingleCol("mdr_item_info", "id", fs.toArray());
        fs = new QFilter("owner", "in", this.ownerIds);
        itemids.addAll(QueryUtil.querySingleCol("dpm_item_combination", "id", fs.toArray()));
        return itemids;
    }

    public Set<Object> getOwnerIds() {
        return this.ownerIds;
    }

    public void setOwnerIds(Set<Object> ownerIds) {
        if (ownerIds == null) {
            this.clearOwnerIds();
        } else {
            this.ownerIds = ownerIds;
        }
    }

    public Set<Object> getItems() {
        return this.items;
    }

    public void setItems(Set<Object> items) {
        this.items = items;
    }

    public void mergePathCanSaleInfo(PathSaleInfo saleInfo) {
        if (saleInfo == null) {
            return;
        }
        if (this.isLoadedItems() && saleInfo.isLoadedItems()) {
            this.items.addAll(saleInfo.items);
        } else if (!this.isLoadedItems() && saleInfo.isLoadedItems()) {
            this.loadOwnerItems();
            this.items.addAll(saleInfo.items);
        } else if (this.isLoadedItems() && !saleInfo.isLoadedItems()) {
            saleInfo.loadOwnerItems();
            this.items.addAll(saleInfo.items);
        } else {
            this.getOwnerIds().addAll(saleInfo.getOwnerIds());
        }
    }

    public void addCustomerItemIds(Object customerId) {
        if (this.isLoadedItems()) {
            this.items.addAll(this.queryCustomerItems(customerId));
        } else {
            this.getOwnerIds().add(customerId);
        }
    }

    private Set<Object> queryCustomerItems(Object customerId) {
        return this.queryOwnerItemIds(customerId);
    }

    public boolean isItemCanSale(Object itemId) {
        if (this.isLoadedItems()) {
            return this.items.contains(itemId);
        }
        QFilter fs = F7Utils.buildMultiF7QFitler("mulowner", this.ownerIds);
        fs.and("id", "=", itemId);
        boolean isCanSale = QueryServiceHelper.exists((String)"mdr_item_info", (QFilter[])fs.toArray());
        if (!isCanSale) {
            fs = new QFilter("owner", "in", this.ownerIds);
            fs.and("id", "=", itemId);
            isCanSale = QueryServiceHelper.exists((String)"dpm_item_combination", (QFilter[])fs.toArray());
        }
        return isCanSale;
    }
}

