/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.check.operation;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.status.SaleOrderPayStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;

public class SaleOrderOperationCheck {
    private static String getOrderStatus(DynamicObject order) {
        return order.getString("orderstatus");
    }

    private static String getOrderSyncStatus(DynamicObject order) {
        return order.getString("sync");
    }

    public static CheckResult checkCanSaveChange(DynamicObject order) {
        if (!SaleOrderUtil.isThisStatus(order, SaleOrderStatus.CHANGING)) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u53ea\u6709\u53d8\u66f4\u4e2d\u72b6\u6001\u8ba2\u5355\u624d\u80fd\u4fdd\u5b58\u53d8\u66f4\uff01", (String)"SaleOrderOperationCheck_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        Set<Object> entryIds = SaleOrderOperationCheck.queryOrderEntryIds(order);
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        BigDecimal qty = null;
        BigDecimal deliveredQty = null;
        DynamicObject entry = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            entry = (DynamicObject)entrys.get(i);
            qty = entry.getBigDecimal("qty");
            if (qty.compareTo(deliveredQty = entry.getBigDecimal("deliveredqty")) < 0) {
                return CheckResult.returnFalse(ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e\u5df2\u53d1\u8d27\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u53d8\u66f4\uff01", (String)"SaleOrderOperationCheck_1", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            entryIds.remove(entry.get("id"));
        }
        if (!entryIds.isEmpty()) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u53d8\u66f4\u4e0d\u80fd\u5220\u9664\u5206\u5f55\uff0c\u53ef\u5c06\u5546\u54c1\u6570\u91cf\u8bbe\u7f6e\u4e3a0", (String)"SaleOrderOperationCheck_2", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private static Set<Object> queryOrderEntryIds(DynamicObject order) {
        Object orderId = order.get("id");
        QFilter fs = new QFilter("id", "=", orderId);
        return QueryUtil.querySingleCol("bbc_saleorder", "itementry.id", fs.toArray());
    }

    public static CheckResult checkOrderCanChange(DynamicObject order) {
        String orderStatus = SaleOrderOperationCheck.getOrderStatus(order);
        String syncStatus = SaleOrderOperationCheck.getOrderSyncStatus(order);
        if ((SaleOrderStatus.PENDING_DELIVERY.getFlagStr().endsWith(orderStatus) || SaleOrderStatus.PART_DELIVERY.getFlagStr().endsWith(orderStatus) || SaleOrderStatus.CHANGING.getFlagStr().endsWith(orderStatus)) && SaleOrderSyncStatus.NOT_SYNC.getFlagStr().equals(syncStatus)) {
            return CheckResult.returnTrue();
        }
        return CheckResult.returnFalse(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u540c\u6b65\u3001\u90e8\u5206\u53d1\u8d27\u3001\u5f85\u53d1\u8d27\u3001\u53d8\u66f4\u4e2d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u53d8\u66f4\uff01", (String)"SaleOrderOperationCheck_3", (String)"drp-mdr-common", (Object[])new Object[0]));
    }

    public static CheckResult checkOrderCanSyncWithStatus(DynamicObject orderid) {
        return SaleOrderOperationCheck.checkOrderCanSync(orderid, true);
    }

    public static CheckResult checkOrderCanSyncWithoutStatus(DynamicObject orderid) {
        return SaleOrderOperationCheck.checkOrderCanSync(orderid, false);
    }

    public static CheckResult checkOrderCanSync(DynamicObject orderid, boolean checkStatus) {
        if (orderid == null) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u6821\u9a8c\u8ba2\u5355ID\u4e3a\u7a7a", (String)"SaleOrderOperationCheck_4", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        boolean isOpenEasSync = SysParamsUtil.isOpenEasSync();
        if (isOpenEasSync) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"EAS\u540c\u6b65\u5f00\u5173\u672a\u5f00\u542f", (String)"SaleOrderOperationCheck_5", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        QFilter filter = QueryUtil.getIdFilter(orderid);
        DynamicObject order = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"owner.id,orderstatus", (QFilter[])filter.toArray());
        if (order == null) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728", (String)"SaleOrderOperationCheck_6", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (checkStatus && SaleOrderStatus.PENDING_DELIVERY != EnumUtil.toSaleOrderStatus(order.getString("orderstatus"))) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u662f\u5ba1\u6838\u72b6\u6001", (String)"SaleOrderOperationCheck_7", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        Object ownerId = order.get("owner.id");
        filter = QueryUtil.getIdFilter(ownerId);
        DynamicObject owner = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"isinnerorg,iscompany", (QFilter[])filter.toArray());
        if (owner == null) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u8ba2\u5355\u7684\u4f9b\u8d27\u6e20\u9053\u4e0d\u5b58\u5728", (String)"SaleOrderOperationCheck_8", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        if (!owner.getBoolean("iscompany") && owner.getBoolean("isinnerorg")) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u8ba2\u5355\u7684\u4f9b\u8d27\u6e20\u9053\u4e0d\u662f\u4f01\u4e1a\u6216\u5185\u90e8\u6e20\u9053", (String)"SaleOrderOperationCheck_9", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    public static CheckResult checkCanDelivery(DynamicObject order) {
        String status = order.getString("orderstatus");
        if (!SaleOrderStatus.PENDING_DELIVERY.getFlagStr().equals(status) && SaleOrderStatus.PART_DELIVERY.getFlagStr().equals(status)) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u53d1\u8d27\u3001\u90e8\u5206\u53d1\u8d27\u5355\u636e\u624d\u80fd\u53d1\u8d27\uff01", (String)"SaleOrderOperationCheck_10", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    public static CheckResult checkDelete(DynamicObject order) {
        return CheckResult.returnTrue();
    }

    public static CheckResult checkCanSign(DynamicObject order) {
        String status = SaleOrderOperationCheck.getOrderStatus(order);
        if (!SaleOrderStatus.PART_DELIVERY.getFlagStr().equals(status) && SaleOrderStatus.WAITING_RECEIVER.getFlagStr().equals(status)) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u53ea\u6709\u90e8\u5206\u53d1\u8d27\u3001\u5f85\u6536\u8d27\u72b6\u6001\u5355\u636e\u624d\u80fd\u7b7e\u6536\uff01", (String)"SaleOrderOperationCheck_11", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    public static CheckResult checkPay(DynamicObject order) {
        String status = SaleOrderOperationCheck.getOrderStatus(order);
        if (!SaleOrderPayStatus.NOT_PAID.getFlagStr().equals(status)) {
            return CheckResult.returnFalse(ResManager.loadKDString((String)"\u5f85\u4ed8\u6b3e\u72b6\u6001\u5355\u636e\u624d\u80fd\u6536\u6b3e", (String)"SaleOrderOperationCheck_12", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }
}

