/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.extendmenu;

import com.alibaba.fastjson.JSON;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.extendmenu.AbstractExtendMenuURL;
import kd.drp.mdr.common.extendmenu.MdrLtpaTokenManager;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;

public class EASExtendMenuURL
extends AbstractExtendMenuURL {
    @Override
    public String getUrl(String url) {
        StringBuilder result = new StringBuilder();
        URL tmpUrl = null;
        QFilter fs = new QFilter("sysuser", "=", UserUtil.getUserID());
        fs.and("enable", "=", (Object)"1");
        Map userInfos = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (QFilter[])fs.toArray());
        String customerNumber = "";
        if (!userInfos.isEmpty()) {
            String easnumber = "";
            DynamicObject owner = null;
            for (DynamicObject userInfo : userInfos.values()) {
                owner = userInfo.getDynamicObject("owner");
                if (owner == null || (easnumber = owner.getString("easnumber")).isEmpty()) continue;
                customerNumber = easnumber;
                break;
            }
        }
        try {
            tmpUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u83dc\u5355\u7684url\u53c2\u6570\u4e2d\u914d\u7f6e\u6b63\u786e\u7684url", (String)"EASExtendMenuURL_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        result.append(tmpUrl.getProtocol());
        result.append("://");
        result.append(tmpUrl.getHost());
        int port = tmpUrl.getPort();
        if (port > 0) {
            result.append(':').append(port);
        }
        result.append("/portal/index2sso.jsp").append('?');
        result.append("isNotCheckRelogin=true");
        String userName = SysParamsUtil.getEasUser();
        result.append('&').append("username=").append(userName);
        result.append('&').append("password=").append(this.getPassword(userName));
        result.append('&').append("redirectTo=").append(this.getRedirectTo(tmpUrl, customerNumber));
        return result.toString();
    }

    protected String getPassword(String userName) {
        String token = MdrLtpaTokenManager.generate(userName).toString();
        return token;
    }

    protected String getRedirectTo(URL tUrl, Object ... customerNumber) {
        String extParam;
        StringBuilder redirectTo = new StringBuilder(tUrl.getPath());
        StringBuilder queryString = new StringBuilder();
        if (StringUtils.isNotEmpty(tUrl.getQuery())) {
            queryString.append(tUrl.getQuery());
        }
        if (StringUtils.isNotEmpty(extParam = this.getExtendParams(tUrl, customerNumber))) {
            if (queryString.length() > 0) {
                queryString.append('&');
            }
            queryString.append(extParam);
        }
        redirectTo.append('?').append((CharSequence)queryString);
        return StringUtils.urlEncode(redirectTo.toString());
    }

    protected String getExtendParams(URL tUrl, Object ... customerNumber) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (customerNumber != null && customerNumber[0] != null && customerNumber[0].toString().length() != 0) {
            param.put("customerNumber", customerNumber[0].toString());
        }
        if (this.isEASExtendReportUrl(tUrl.toString())) {
            param.put("telephone", UserUtil.getUserInfo().get("phone"));
        }
        if (param.size() > 0) {
            String destStr = JSON.toJSONString(param);
            return "extOutParam=" + destStr;
        }
        return "";
    }

    private boolean isEASExtendReportUrl(String url) {
        return url.indexOf("jumpPortlet.action") > 0 || url.indexOf("extlight-single-report.html") > 0;
    }
}

