/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.extendmenu;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import kd.drp.mdr.common.extendmenu.sso.ltpa.LtpaToken;
import kd.drp.mdr.common.extendmenu.sso.ltpa.LtpaTokenManager;
import kd.drp.mdr.common.extendmenu.sso.util.BASE64Util;
import kd.drp.mdr.common.extendmenu.sso.util.LMBCSUtil;

public class MdrLtpaTokenManager
extends LtpaTokenManager {
    public static final int TOKEN_EXPIRATION = 30;
    public static final String DOMINO_SECRET = "BTfa8F+HwNejYEGtuZSJTWOZ/t8=";

    public static LtpaToken generate(String canonicalUser) {
        Date creationDate = new Date();
        Date expirationDate = new Date();
        expirationDate.setTime(creationDate.getTime() + 1800000L);
        return MdrLtpaTokenManager.generate(canonicalUser, creationDate, expirationDate);
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires) {
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        try {
            ltpa.setUser(canonicalUser.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            ltpa.setUser(canonicalUser.getBytes(StandardCharsets.UTF_8));
        }
        byte[] token = null;
        calendar.setTime(tokenCreation);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes(StandardCharsets.UTF_8));
        calendar.setTime(tokenExpires);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes(StandardCharsets.UTF_8));
        token = LMBCSUtil.concatenate(token, ltpa.getHeader());
        token = LMBCSUtil.concatenate(token, ltpa.getCreation());
        token = LMBCSUtil.concatenate(token, ltpa.getExpires());
        token = LMBCSUtil.concatenate(token, ltpa.getUser());
        md.update(token);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes(DOMINO_SECRET));
        ltpa.setDigest(digest);
        token = LMBCSUtil.concatenate(token, digest);
        String tokenStr = BASE64Util.encode(token);
        String result = "";
        StringTokenizer st = new StringTokenizer(tokenStr);
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreTokens()) {
            result = builder.append(result).append(st.nextToken()).toString();
        }
        return new LtpaToken(result);
    }

    public static void main(String[] args) {
        System.out.print(MdrLtpaTokenManager.generate("user"));
    }
}

