/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.extendmenu.sso.ltpa;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import kd.drp.mdr.common.extendmenu.sso.util.BASE64Util;
import kd.drp.mdr.common.extendmenu.sso.util.LMBCSUtil;
import org.apache.log4j.Logger;

public class LtpaToken {
    private byte[] creation;
    private Date creationDate;
    private byte[] digest;
    private byte[] expires;
    private Date expiresDate;
    private byte[] header;
    private String tokenStr;
    private byte[] rawToken;
    private byte[] user;
    private static final Logger log = Logger.getLogger(LtpaToken.class);

    public LtpaToken() {
        this.init();
    }

    public LtpaToken(String token) {
        int i;
        this.init();
        this.tokenStr = token;
        this.rawToken = BASE64Util.decodeAsBytes(token);
        this.user = new byte[this.rawToken.length - 40];
        for (i = 0; i < 4; ++i) {
            this.header[i] = this.rawToken[i];
        }
        for (i = 4; i < 12; ++i) {
            this.creation[i - 4] = this.rawToken[i];
        }
        for (i = 12; i < 20; ++i) {
            this.expires[i - 12] = this.rawToken[i];
        }
        for (i = 20; i < this.rawToken.length - 20; ++i) {
            this.user[i - 20] = this.rawToken[i];
        }
        for (i = this.rawToken.length - 20; i < this.rawToken.length; ++i) {
            this.digest[i - (this.rawToken.length - 20)] = this.rawToken[i];
        }
        this.creationDate = new Date(Long.parseLong(new String(this.creation, StandardCharsets.UTF_8), 16) * 1000L);
        this.expiresDate = new Date(Long.parseLong(new String(this.expires, StandardCharsets.UTF_8), 16) * 1000L);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public String getUsername() {
        String userName = null;
        try {
            userName = new String(this.user, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            userName = new String(this.user, StandardCharsets.UTF_8);
        }
        return userName;
    }

    public String getUsername(String code) {
        String userName = null;
        try {
            userName = new String(this.user, code);
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user, StandardCharsets.UTF_8);
        }
        return userName;
    }

    private void init() {
        this.creation = new byte[8];
        this.digest = new byte[20];
        this.expires = new byte[8];
        this.header = new byte[4];
    }

    public boolean isValid(String secretKey) {
        boolean validDigest = false;
        boolean validDateRange = false;
        byte[] bytes = null;
        Date now = new Date();
        MessageDigest md = this.getMessageDigest();
        bytes = LMBCSUtil.concatenate(bytes, this.header);
        bytes = LMBCSUtil.concatenate(bytes, this.creation);
        bytes = LMBCSUtil.concatenate(bytes, this.expires);
        bytes = LMBCSUtil.concatenate(bytes, this.user);
        bytes = LMBCSUtil.concatenate(bytes, BASE64Util.decodeAsBytes(secretKey));
        byte[] newDigest = md.digest(bytes);
        validDigest = MessageDigest.isEqual(this.digest, newDigest);
        System.out.println("valid message digest :" + validDigest);
        validDateRange = now.before(this.expiresDate);
        boolean result = validDigest && validDateRange;
        System.out.println("creationDate[" + this.creationDate + "]<now[" + now + "]<expiresDate[" + this.expiresDate + "],validDateRange:" + validDateRange + ",verify result:" + result);
        return result;
    }

    public String toString() {
        return LtpaToken.encodeToken(this.tokenStr);
    }

    public byte[] getCreation() {
        return this.creation;
    }

    public void setCreation(byte[] creation) {
        this.creation = creation;
    }

    public byte[] getExpires() {
        return this.expires;
    }

    public void setExpires(byte[] expires) {
        this.expires = expires;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
    }

    public void setUser(byte[] user) {
        this.user = user;
    }

    public byte[] getUser() {
        return this.user;
    }

    public String getTokenStr() {
        return LtpaToken.encodeToken(this.tokenStr);
    }

    public static String encodeToken(String token) {
        try {
            return URLEncoder.encode(URLEncoder.encode(URLEncoder.encode(token, StandardCharsets.UTF_8.name()), StandardCharsets.UTF_8.name()), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Token encode error[UnsupportedEncodingException]!");
            log.error((Object)e.getMessage());
            return token;
        }
    }

    public static String decodeToken(String token) {
        if (token.indexOf(43) == -1) {
            try {
                String decodeToken1 = URLDecoder.decode(token, StandardCharsets.UTF_8.name());
                if (decodeToken1.indexOf(43) == -1) {
                    String decodeToken2 = URLDecoder.decode(decodeToken1, StandardCharsets.UTF_8.name());
                    if (decodeToken2.indexOf(43) == -1) {
                        return URLDecoder.decode(decodeToken2, StandardCharsets.UTF_8.name());
                    }
                    return decodeToken2;
                }
                return decodeToken1;
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Token decode error[UnsupportedEncodingException]!");
                log.error((Object)e.getMessage());
            }
        }
        return token;
    }

    public static void main(String[] args) {
        String prime = "%2525252BEE";
        String encode = LtpaToken.encodeToken(prime);
        String decode = LtpaToken.decodeToken(encode);
        System.out.println(encode);
        System.out.println(decode);
        System.out.println(prime.equals(decode));
    }
}

