/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.extendmenu.sso.ltpa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import kd.drp.mdr.common.extendmenu.sso.ltpa.ConfigurationError;
import kd.drp.mdr.common.extendmenu.sso.ltpa.LtpaToken;
import kd.drp.mdr.common.extendmenu.sso.util.BASE64Util;
import kd.drp.mdr.common.extendmenu.sso.util.CleanPathUtil;
import kd.drp.mdr.common.extendmenu.sso.util.LMBCSUtil;
import org.apache.log4j.Logger;

public class LtpaTokenManager {
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_NAME = "LtpaToken";
    public static final String DOMINO_SECRET = "domino.secret";
    public static final String TOKEN_EXPIRATION = "token.expiration";
    public static final String ISLMBCSENCODE = "isLMBCSEncode";
    private static Properties properties = null;
    private static boolean isConfigLoaded = false;
    private static final Logger log = Logger.getLogger(LtpaTokenManager.class);

    public static void loadConfig(String configFile) {
        if (!LtpaTokenManager.isConfigLoaded()) {
            properties = new Properties();
            InputStream is = null;
            try {
                is = Files.newInputStream(Paths.get(CleanPathUtil.cleanString(configFile), new String[0]), new OpenOption[0]);
                properties.load(is);
                isConfigLoaded = true;
            }
            catch (IOException ioe) {
                throw new ConfigurationError("LtpaToken.properties not found. file = " + configFile);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            if (properties.getProperty(DOMINO_SECRET) == null || properties.getProperty(COOKIE_DOMAIN) == null || properties.getProperty(TOKEN_EXPIRATION) == null) {
                throw new ConfigurationError("LtpaToken.properties not configured properly. file = " + configFile);
            }
        }
    }

    public static LtpaToken generate(String canonicalUser) {
        String configFile = LtpaTokenManager.getDefaultConfigFile();
        return LtpaTokenManager.generate(canonicalUser, configFile);
    }

    public static LtpaToken generate(String canonicalUser, String configFile) {
        LtpaTokenManager.initConfig(configFile);
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = Integer.parseInt(properties.getProperty(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return LtpaTokenManager.generate(canonicalUser, creationDate, expirationDate, configFile);
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires) {
        String configFile = LtpaTokenManager.getDefaultConfigFile();
        return LtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultConfigFile() {
        Properties prop = new Properties();
        String configFile = "";
        String defaultConfigFileName = "config.properties";
        InputStream is = LtpaTokenManager.class.getResourceAsStream(defaultConfigFileName);
        try {
            prop.load(is);
            configFile = prop.getProperty("config.path");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            try {
                is.close();
            }
            catch (IOException e1) {
                log.error((Object)e.getMessage());
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
        return configFile;
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile) {
        String isLMBC;
        boolean isLMBCSEncode = false;
        if (properties != null && (isLMBC = properties.getProperty(ISLMBCSENCODE)) != null && "true".equals(isLMBC)) {
            isLMBCSEncode = true;
        }
        return LtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile, isLMBCSEncode);
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile, boolean isLMBCSEncode) {
        LtpaTokenManager.initConfig(configFile);
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        if (isLMBCSEncode) {
            ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes(canonicalUser));
        } else {
            try {
                ltpa.setUser(canonicalUser.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                ltpa.setUser(canonicalUser.getBytes(StandardCharsets.UTF_8));
            }
        }
        byte[] token = null;
        calendar.setTime(tokenCreation);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes(StandardCharsets.UTF_8));
        calendar.setTime(tokenExpires);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes(StandardCharsets.UTF_8));
        token = LMBCSUtil.concatenate(token, ltpa.getHeader());
        token = LMBCSUtil.concatenate(token, ltpa.getCreation());
        token = LMBCSUtil.concatenate(token, ltpa.getExpires());
        token = LMBCSUtil.concatenate(token, ltpa.getUser());
        md.update(token);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes(properties.getProperty(DOMINO_SECRET)));
        ltpa.setDigest(digest);
        token = LMBCSUtil.concatenate(token, digest);
        String tokenStr = BASE64Util.encode(token);
        StringTokenizer st = new StringTokenizer(tokenStr);
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreTokens()) {
            builder.append(st.nextToken());
        }
        return new LtpaToken(builder.toString());
    }

    private static void initConfig(String configFile) {
        LtpaTokenManager.loadConfig(configFile);
    }

    public static boolean isValid(String ltpaToken) {
        LtpaTokenManager.checkConfig();
        LtpaToken ltpa = new LtpaToken(LtpaToken.decodeToken(ltpaToken));
        boolean result = ltpa.isValid(properties.getProperty(DOMINO_SECRET));
        System.out.println("LTPA token isValid result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + ltpaToken);
        }
        return result;
    }

    public static Cookie toCookie(String ltpaToken) {
        LtpaTokenManager.checkConfig();
        Cookie cookie = new Cookie(COOKIE_NAME, ltpaToken);
        String domain = properties.getProperty(COOKIE_DOMAIN);
        if (domain != null && !"".equals(domain)) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setSecure(false);
        cookie.setMaxAge(-1);
        return cookie;
    }

    private static void checkConfig() {
        if (!LtpaTokenManager.isConfigLoaded()) {
            throw new ConfigurationError("LtpaToken properties is unloaded properly. ");
        }
    }

    private static boolean isConfigLoaded() {
        return isConfigLoaded;
    }

    public static String getDefaultLtpaConfig() {
        String portalConfig = System.getProperty("portal.config");
        if (portalConfig == null || "".equals(portalConfig)) {
            System.err.println("[Eas Portal] please set system property [portal.config].");
            return "";
        }
        File portalConfigFile = new File(CleanPathUtil.cleanString(portalConfig));
        String configPath = portalConfigFile.getParentFile().getAbsolutePath() + "/LtpaToken.properties";
        return configPath;
    }

    public static synchronized void loadDefaultConfig() {
        LtpaTokenManager.loadConfig(LtpaTokenManager.getDefaultLtpaConfig());
    }

    public static boolean compare(String token, String userNumber) {
        boolean result = false;
        LtpaToken lt = new LtpaToken(LtpaToken.decodeToken(token));
        String username = lt.getUsername();
        result = username == null ? false : username.equals(userNumber);
        System.out.println("LTPA token compare result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + token);
        }
        return result;
    }

    public static boolean verifyToken(String path, String token, String userNumber) {
        boolean result = false;
        if (path == null || path.trim().length() == 0) {
            LtpaTokenManager.loadDefaultConfig();
        } else {
            LtpaTokenManager.loadConfig(path);
        }
        boolean isValid = LtpaTokenManager.isValid(LtpaToken.decodeToken(token));
        if (isValid) {
            result = LtpaTokenManager.compare(LtpaToken.decodeToken(token), userNumber);
            if (!result) {
                System.out.println("LTPA token compare false, token:" + token);
            }
        } else {
            System.out.println("LTPA token isValid false, token:" + token);
        }
        return result;
    }
}

