/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.extendmenu.sso.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public final class LMBCSUtil {
    private static final Logger log = Logger.getLogger(LMBCSUtil.class);
    private static final String ULMBCS_GRP_L1 = "0x01";
    private static final String ULMBCS_GRP_GR = "0x02";
    private static final String ULMBCS_GRP_HE = "0x03";
    private static final String ULMBCS_GRP_AR = "0x04";
    private static final String ULMBCS_GRP_RU = "0x05";
    private static final String ULMBCS_GRP_L2 = "0x06";
    private static final String ULMBCS_GRP_TR = "0x08";
    private static final String ULMBCS_GRP_TH = "0x0B";
    private static final String ULMBCS_GRP_JA = "0x10";
    private static final String ULMBCS_GRP_KO = "0x11";
    private static final String ULMBCS_GRP_TW = "0x12";
    private static final String ULMBCS_GRP_CN = "0x13";
    private static final String ULMBCS_GRP_UNICODE = "0x14";
    private static final HashMap groupMap = new HashMap();

    public static byte getLMBCGroupId(Locale locale) {
        byte groupId = Byte.decode(ULMBCS_GRP_L1);
        if (groupMap.get(locale) == null) {
            String language = locale.getLanguage();
            Locale l = new Locale(language, "");
            if (groupMap.get(l) != null) {
                groupId = Byte.decode(groupMap.get(l).toString());
            }
        } else {
            groupId = Byte.decode(groupMap.get(locale).toString());
        }
        return groupId;
    }

    public static byte getDefaultGroupId() {
        return LMBCSUtil.getLMBCGroupId(Locale.getDefault());
    }

    public static byte[] getLMBCSLocalGroupBytes(String input) {
        byte[] groupId = new byte[]{LMBCSUtil.getDefaultGroupId()};
        byte[] result = null;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            Character ch = Character.valueOf(c);
            String s = ch.toString();
            if (s.getBytes(StandardCharsets.UTF_8)[0] < 0) {
                result = LMBCSUtil.concatenate(result, groupId);
            }
            result = LMBCSUtil.concatenate(result, s.getBytes(StandardCharsets.UTF_8));
        }
        return result;
    }

    public static byte[] getLMBCSUnicodeGroupBytes(String input) {
        byte[] unicodeGroupId = new byte[]{Byte.decode(ULMBCS_GRP_UNICODE)};
        String s = null;
        byte[] unicodeBytes = null;
        byte[] LMBCSBytes = null;
        for (int i = 0; i < input.length(); ++i) {
            s = Character.valueOf(input.charAt(i)).toString();
            try {
                unicodeBytes = s.getBytes("Unicode");
                byte highByte = unicodeBytes[2];
                byte lowByte = unicodeBytes[3];
                if (highByte == 0) {
                    LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, new byte[]{lowByte});
                    continue;
                }
                LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, unicodeGroupId);
                LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, new byte[]{highByte});
                LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, new byte[]{lowByte});
                continue;
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage());
            }
        }
        return LMBCSBytes;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        if (a == null) {
            return b;
        }
        byte[] bytes = new byte[a.length + b.length];
        System.arraycopy(a, 0, bytes, 0, a.length);
        System.arraycopy(b, 0, bytes, a.length, b.length);
        return bytes;
    }

    static {
        groupMap.put(new Locale("ar", ""), ULMBCS_GRP_AR);
        groupMap.put(new Locale("be", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("bg", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("cs", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("el", ""), ULMBCS_GRP_GR);
        groupMap.put(new Locale("he", ""), ULMBCS_GRP_HE);
        groupMap.put(new Locale("hu", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("iw", ""), ULMBCS_GRP_HE);
        groupMap.put(new Locale("ja", ""), ULMBCS_GRP_JA);
        groupMap.put(new Locale("ko", ""), ULMBCS_GRP_KO);
        groupMap.put(new Locale("mk", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("pl", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("ro", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("ru", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("sh", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sk", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sl", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sq", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sr", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("th", ""), ULMBCS_GRP_TH);
        groupMap.put(new Locale("tr", ""), ULMBCS_GRP_TR);
        groupMap.put(new Locale("uk", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("zh", "TW"), ULMBCS_GRP_TW);
        groupMap.put(new Locale("zh", "HK"), ULMBCS_GRP_TW);
        groupMap.put(new Locale("zh", ""), ULMBCS_GRP_CN);
        groupMap.put(new Locale("zh", "CN"), ULMBCS_GRP_CN);
    }
}

