/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.handler;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.drp.mdr.common.util.BalanceUtil;

public class BalanceHandler {
    private static final DataEntityCacheManager BALANCE_CACHE = new DataEntityCacheManager("t_mdr_balance");
    private static final DBRoute ROUTE = new DBRoute("mdr");
    private static final String UPDATE_BALANCE_OCCUPIED = "update t_mdr_balance set fbalance = fbalance + ?, foccupied = foccupied + ? , fusable = fusable + ?, fversion = fversion + 1 where fid = ? and fversion = ?";

    public static void updateBalance(Object ownerPK, Object customerPK, BigDecimal balancedValue, BigDecimal occupiedValue) {
        if (balancedValue == null) {
            balancedValue = BigDecimal.ZERO;
        }
        if (occupiedValue == null) {
            occupiedValue = BigDecimal.ZERO;
        }
        if (balancedValue.compareTo(BigDecimal.ZERO) == 0 && occupiedValue.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u6536\u6b3e\u65e0\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\uff01", (String)"BalanceHandler_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        String errorMsg = ResManager.loadKDString((String)"\u9884\u6536\u6b3e\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u9884\u6536\u6b3e\u4f59\u989d", (String)"BalanceHandler_1", (String)"drp-mdr-common", (Object[])new Object[0]);
        for (int count = 0; count < 3; ++count) {
            DynamicObject balanceInfo = BalanceUtil.getBalanceInfo(ownerPK, customerPK, true);
            if (!BalanceHandler.checkCanDoUpdate(balanceInfo, balancedValue, occupiedValue)) {
                if (count != 2) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u9884\u6536\u6b3e\u4e09\u6b21\u91cd\u8bd5\u5168\u90e8\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01%s", (String)"BalanceHandler_2", (String)"drp-mdr-common", (Object[])new Object[0]), errorMsg));
            }
            int result = BalanceHandler.doUpdate(balanceInfo, balancedValue, occupiedValue);
            if (result == 1) {
                BALANCE_CACHE.removeByPrimaryKey(new Object[]{balanceInfo.get("id")});
                break;
            }
            if (count != 2) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u9884\u6536\u6b3e\u4e09\u6b21\u91cd\u8bd5\u5168\u90e8\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01%s", (String)"BalanceHandler_2", (String)"drp-mdr-common", (Object[])new Object[0]), errorMsg));
        }
    }

    private static boolean checkCanDoUpdate(DynamicObject balanceInfo, BigDecimal balancedValue, BigDecimal occupiedValue) {
        BigDecimal balance = balanceInfo.getBigDecimal("balance");
        balance = balance.add(balancedValue);
        BigDecimal occupied = balanceInfo.getBigDecimal("occupied");
        occupied = occupied.add(occupiedValue);
        BigDecimal usable = balance.subtract(occupied);
        return balance.compareTo(BigDecimal.ZERO) >= 0 && occupied.compareTo(BigDecimal.ZERO) >= 0 && usable.compareTo(BigDecimal.ZERO) >= 0;
    }

    private static int doUpdate(DynamicObject balanceInfo, BigDecimal balancedValue, BigDecimal occupiedValue) {
        Object balancePK = balanceInfo.get("id");
        Object version = balanceInfo.get("version");
        BigDecimal useableChange = balancedValue.subtract(occupiedValue);
        int result = DB.update((DBRoute)ROUTE, (String)UPDATE_BALANCE_OCCUPIED, (Object[])new Object[]{balancedValue, occupiedValue, useableChange, balancePK, version});
        return result;
    }
}

