/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.handler;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;

public class CustomerRelationHandler {
    public static void buildCustomerOfUserRelation(DynamicObject customer, DynamicObject user) throws Exception {
        if (customer == null || user == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e20\u9053\u4fe1\u606f\u6216\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a", (String)"CustomerRelationHandler_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        DynamicObject userInfo = BusinessDataServiceHelper.newDynamicObject((String)"dbd_drp_user");
        userInfo.set("sysuser", (Object)user);
        userInfo.set("owner", (Object)customer);
        userInfo.set("isdptadmin", (Object)Boolean.FALSE);
        userInfo.set("iscusorderprocessor", (Object)Boolean.FALSE);
        userInfo.set("isdispatcher", (Object)Boolean.FALSE);
        userInfo.set("issaler", (Object)Boolean.FALSE);
        userInfo.set("isbuyer", (Object)Boolean.FALSE);
        userInfo.set("isdefault", (Object)Boolean.FALSE);
        userInfo.set("enable", (Object)"1");
        userInfo.set("creator", UserUtil.getUserID());
        userInfo.set("createtime", (Object)new Date());
        userInfo.set("remark", (Object)(StringUtils.isEmpty(customer.get("sourcebillnumber")) ? "" : ResManager.loadKDString((String)"\u6e20\u9053\u7533\u8bf7\u65b0\u589e\u6e20\u9053\u4fe1\u606f", (String)"CustomerRelationHandler_1", (String)"drp-mdr-common", (Object[])new Object[0])));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"dbd_drp_user", (DynamicObject[])new DynamicObject[]{userInfo}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            List infos = result.getAllErrorOrValidateInfo();
            StringBuilder msg = new StringBuilder();
            for (IOperateInfo info : infos) {
                msg.append(info.getMessage());
                msg.append("\r\n");
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%s", (String)"CustomerRelationHandler_2", (String)"drp-mdr-common", (Object[])new Object[0]), msg.toString()));
        }
    }

    public static void severCustomerOfUserRelation(DynamicObject customer, DynamicObject user) {
        if (customer == null || user == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e20\u9053\u4fe1\u606fid\u6216\u4eba\u5458id\u4fe1\u606f\u4e3a\u7a7a\uff01", (String)"CustomerRelationHandler_3", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        QFilter fs = new QFilter("sysuser", "=", user.get("id"));
        fs.and("owner", "=", customer.get("id"));
        DynamicObject drpUser = BusinessDataServiceHelper.loadSingleFromCache((String)"dbd_drp_user", (QFilter[])fs.toArray());
        if (drpUser == null) {
            return;
        }
        drpUser.set("enable", (Object)Boolean.FALSE);
        OperationUtil.invokeOperation(drpUser, "delete");
    }
}

