/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.item.ConversionDirection;
import kd.drp.mdr.common.status.DispatchOrderPayStatus;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.strategy.OrderVersionStrategyFactory;
import kd.drp.mdr.common.util.DispatchOrderUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.SysParamsUtil;

public class DispatchOrderHandler {
    public static final String QTY = "qty";
    public static final String BASE_QTY = "baseqty";
    public static final String ASSIST_QTY = "assistqty";
    public static final String ASSIST_UNIT = "assistunit";
    public static final String BASE_UNIT = "baseunit";
    public static final String UNIT = "unit";
    public static final String ORDER_AMOUNT = "orderamount";
    public static final String PRICE = "price";
    public static final String ITEM_PRICE = "itemprice";
    public static final String HIGHTPRICERATIO = "hightpriceratio";
    public static final String TOTAL_ITEM_AMOUT = "totalitemamount";
    public static final String TOTAL_ORDER_AMOUNT = "totalorderamount";
    public static final String RECEIVED_AMOUNT = "receivedamount";
    public static final String AMOUNT_TO_BE_PAID = "amounttobepaid";
    public static final String TOTAL_QTY = "totalqty";
    public static final String ITEM_ENTRY = "itementry";
    public static final String SOURCEBILLID = "sourcebillid";
    public static final String SOURCEENTRYID = "sourceentryid";

    public static void handleStatusAfterSignOrDelivery(DynamicObject order) {
        DispatchOrderHandler.reHandleOrderStatus(order);
        DispatchOrderHandler.handleOrderIsOver(order);
    }

    public static void handleOrderIsOver(DynamicObject order) {
        DispatchOrderStatus orderStatus = DispatchOrderUtil.getOrderStatus(order);
        DispatchOrderPayStatus orderPayStatus = DispatchOrderUtil.getOrderPayStatus(order);
        if (DispatchOrderStatus.RECEIVED == orderStatus && DispatchOrderPayStatus.ALREADY_PAID == orderPayStatus) {
            DispatchOrderHandler.setOrderStatus(order, DispatchOrderStatus.COMPLETED);
        }
    }

    public static void handleOrderIsOverByQty(DynamicObject order) {
        DynamicObjectCollection itementry = order.getDynamicObjectCollection(ITEM_ENTRY);
        boolean hasOver = false;
        for (DynamicObject entry : itementry) {
            BigDecimal qty = entry.getBigDecimal(QTY);
            if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) continue;
            hasOver = true;
            return;
        }
        if (!hasOver) {
            DispatchOrderHandler.setOrderStatus(order, DispatchOrderStatus.COMPLETED);
        }
    }

    public static void reHandleOrderPayStatus(DynamicObject order) {
        BigDecimal amounttobepaid = order.getBigDecimal(AMOUNT_TO_BE_PAID);
        if (amounttobepaid.compareTo(BigDecimal.ZERO) == 0) {
            DispatchOrderHandler.setOrderPayStatus(order, DispatchOrderPayStatus.ALREADY_PAID);
        } else {
            DispatchOrderHandler.setOrderPayStatus(order, DispatchOrderPayStatus.NOT_PAID);
        }
    }

    public static void reHandleOrderQtysAndAmounts(DynamicObject order) {
        DispatchOrderHandler.reHandleOrderQtysAndAmounts(order, QTY);
    }

    public static void reHandleOrderQtysAndAmounts(DynamicObject order, String changedColName) {
        DynamicObjectCollection entrys = order.getDynamicObjectCollection(ITEM_ENTRY);
        Map<String, BigDecimal> entryQtys = null;
        Map<String, BigDecimal> entryPrices = null;
        Map<String, BigDecimal> entryAmounts = null;
        for (DynamicObject entry : entrys) {
            if (ORDER_AMOUNT.equals(changedColName)) {
                entryQtys = DispatchOrderHandler.handleEntryQtys(entry, QTY);
                DispatchOrderHandler.setValuesFromMap(entry, entryQtys);
                entryPrices = DispatchOrderHandler.handleEntryPrices(entry);
                DispatchOrderHandler.setValuesFromMap(entry, entryPrices);
                continue;
            }
            entryQtys = DispatchOrderHandler.handleEntryQtys(entry, changedColName);
            DispatchOrderHandler.setValuesFromMap(entry, entryQtys);
            entryAmounts = DispatchOrderHandler.handleEntryAmounts(entry);
            DispatchOrderHandler.setValuesFromMap(entry, entryAmounts);
        }
        Map<String, BigDecimal> amounts = DispatchOrderHandler.handleOrderTotalQtysAndAmounts((List<DynamicObject>)entrys);
        DispatchOrderHandler.setValuesFromMap(order, amounts);
        amounts = DispatchOrderHandler.handleOrderPayAmounts(order);
        DispatchOrderHandler.setValuesFromMap(order, amounts);
    }

    public static Map<String, BigDecimal> handleEntryQtys(DynamicObject orderEntry, String changedColName) {
        if (orderEntry.get("item") == null) {
            return new HashMap<String, BigDecimal>();
        }
        switch (changedColName) {
            case "unit": {
                return DispatchOrderHandler.handleUnitChange(orderEntry);
            }
            case "qty": {
                return DispatchOrderHandler.handleQTYChange(orderEntry);
            }
            case "assistqty": {
                return DispatchOrderHandler.handleAssistQtyChange(orderEntry);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u91cf\u6216\u5355\u4f4d\u5b57\u6bb5\u540d\u6709\u8bef\u3002", (String)"DispatchOrderHandler_7", (String)"drp-mdr-common", (Object[])new Object[0]));
    }

    private static Map<String, BigDecimal> handleAssistQtyChange(DynamicObject orderEntry) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(8);
        Object itemId = orderEntry.getDynamicObject("item").get("id");
        BigDecimal assistQty = orderEntry.getBigDecimal(ASSIST_QTY);
        DynamicObject assisUnit = orderEntry.getDynamicObject(ASSIST_UNIT);
        DynamicObject unit = orderEntry.getDynamicObject(UNIT);
        BigDecimal qty = orderEntry.getBigDecimal(QTY);
        DynamicObject infoById = ItemUtil.getItemBizInfo(itemId);
        String conversionfor = infoById.getString("conversionfor");
        UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) {
            qty = unitBatchHandler.getQtyFromAssistUnit(itemId, assisUnit.getPkValue(), assistQty, unit.getPkValue());
        }
        BigDecimal baseQty = unitBatchHandler.getBaseQty(itemId, qty, unit.getPkValue());
        map.put(BASE_QTY, baseQty);
        map.put(ASSIST_QTY, assistQty);
        map.put(QTY, qty);
        return map;
    }

    private static Map<String, BigDecimal> handleQTYChange(DynamicObject orderEntry) {
        DynamicObject assisUnit;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Object itemId = orderEntry.getDynamicObject("item").get("id");
        BigDecimal qty = orderEntry.getBigDecimal(QTY);
        DynamicObject unit = orderEntry.getDynamicObject(UNIT);
        UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
        BigDecimal baseQty = unitBatchHandler.getBaseQty(itemId, qty, unit.getPkValue());
        BigDecimal assistQty = orderEntry.getBigDecimal(ASSIST_QTY);
        DynamicObject infoById = ItemUtil.getItemBizInfo(itemId);
        String conversionfor = infoById.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = orderEntry.getDynamicObject(ASSIST_UNIT)) != null) {
            assistQty = unitBatchHandler.getUnitQty(itemId, assisUnit.getPkValue(), baseQty);
        }
        map.put(BASE_QTY, baseQty);
        map.put(ASSIST_QTY, assistQty);
        map.put(QTY, qty);
        return map;
    }

    private static Map<String, BigDecimal> handleUnitChange(DynamicObject orderEntry) {
        DynamicObject assisUnit;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Object itemId = orderEntry.getDynamicObject("item").get("id");
        DynamicObject unit = orderEntry.getDynamicObject(UNIT);
        BigDecimal baseQty = orderEntry.getBigDecimal(BASE_QTY);
        UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
        BigDecimal qty = unitBatchHandler.getUnitQty(itemId, unit.getPkValue(), baseQty);
        BigDecimal assistQty = orderEntry.getBigDecimal(ASSIST_QTY);
        DynamicObject infoById = ItemUtil.getItemBizInfo(itemId);
        String conversionfor = infoById.getString("conversionfor");
        if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && (assisUnit = orderEntry.getDynamicObject(ASSIST_UNIT)) != null) {
            assistQty = unitBatchHandler.getUnitQty(itemId, assisUnit.getPkValue(), baseQty);
        }
        map.put(BASE_QTY, baseQty);
        map.put(ASSIST_QTY, assistQty);
        map.put(QTY, qty);
        return map;
    }

    public static Map<String, BigDecimal> handleOrderTotalQtysAndAmounts(List<DynamicObject> orderEntrys) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal orderAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        for (DynamicObject entry : orderEntrys) {
            orderAmount = orderAmount.add(entry.getBigDecimal(ORDER_AMOUNT));
            totalQty = totalQty.add(entry.getBigDecimal(QTY));
        }
        map.put(TOTAL_ORDER_AMOUNT, orderAmount);
        map.put(TOTAL_QTY, totalQty);
        return map;
    }

    public static Map<String, BigDecimal> handleOrderPayAmounts(DynamicObject order) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(2);
        BigDecimal totalOrderAmount = order.getBigDecimal(TOTAL_ORDER_AMOUNT);
        BigDecimal receivedamount = order.getBigDecimal(RECEIVED_AMOUNT);
        BigDecimal amountToBePaid = totalOrderAmount.subtract(receivedamount);
        map.put(RECEIVED_AMOUNT, receivedamount);
        map.put(AMOUNT_TO_BE_PAID, amountToBePaid);
        return map;
    }

    public static Map<String, BigDecimal> handleEntryPrices(DynamicObject orderEntry) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(1);
        BigDecimal qty = orderEntry.getBigDecimal(QTY);
        BigDecimal orderAmount = orderEntry.getBigDecimal(ORDER_AMOUNT);
        BigDecimal price = orderEntry.getBigDecimal(PRICE);
        if (qty != null && orderAmount != null && qty.compareTo(BigDecimal.ZERO) != 0) {
            price = orderAmount.divide(qty, 2, RoundingMode.HALF_UP);
        }
        map.put(PRICE, price);
        return map;
    }

    public static void reCalcuHightPriceRatio(DynamicObject orderEntry) {
        BigDecimal price = orderEntry.getBigDecimal(PRICE);
        BigDecimal itemPrice = orderEntry.getBigDecimal(ITEM_PRICE);
        BigDecimal ratio = DispatchOrderHandler.calcuHightPrice(price, itemPrice);
        orderEntry.set(HIGHTPRICERATIO, (Object)ratio);
    }

    private static BigDecimal calcuHightPrice(BigDecimal price, BigDecimal itemPrice) {
        BigDecimal ratio = BigDecimal.ZERO;
        if (itemPrice.compareTo(BigDecimal.ZERO) != 0) {
            ratio = price.subtract(itemPrice).divide(itemPrice, 4, 4).multiply(new BigDecimal(100));
        }
        return ratio;
    }

    public static Map<String, BigDecimal> handleEntryAmounts(DynamicObject orderEntry) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(4);
        BigDecimal qty = orderEntry.getBigDecimal(QTY);
        BigDecimal price = orderEntry.getBigDecimal(PRICE);
        BigDecimal orderAmount = price.multiply(qty);
        map.put(ORDER_AMOUNT, orderAmount);
        return map;
    }

    public static void setValuesFromMap(DynamicObject obj, Map<String, BigDecimal> values) {
        for (Map.Entry<String, BigDecimal> value : values.entrySet()) {
            obj.set(value.getKey(), (Object)value.getValue());
        }
    }

    public static void reHandleOrderStatus(DynamicObject order) {
        DynamicObjectCollection entrys = order.getDynamicObjectCollection(ITEM_ENTRY);
        boolean isDelivery = false;
        boolean isDeliveryOver = true;
        boolean isSignOver = true;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            if (!isDelivery) {
                isDelivery = DispatchOrderHandler.isDelivery((DynamicObject)entrys.get(i));
            }
            if (isDeliveryOver) {
                isDeliveryOver = DispatchOrderHandler.isDeliveryOver((DynamicObject)entrys.get(i));
            }
            if (!isSignOver) continue;
            isSignOver = DispatchOrderHandler.isSignOver((DynamicObject)entrys.get(i));
        }
        if (!isDelivery) {
            DispatchOrderHandler.setOrderStatus(order, DispatchOrderStatus.PENDING_DELIVERY);
        } else if (!isDeliveryOver) {
            DispatchOrderHandler.setOrderStatus(order, DispatchOrderStatus.PART_DELIVERY);
        } else if (!isSignOver) {
            DispatchOrderHandler.setOrderStatus(order, DispatchOrderStatus.WAITING_RECEIVER);
        } else {
            DispatchOrderHandler.setOrderStatus(order, DispatchOrderStatus.RECEIVED);
        }
    }

    public static void reHandleSaleOrderStatus(DynamicObject saleorder) {
        SaleOrderHandler.reHandleOrderStatus4Dispatchorder(saleorder);
    }

    public static void setOrderStatus(DynamicObject order, DispatchOrderStatus status) {
        order.set("orderstatus", (Object)status.getFlagStr());
    }

    public static void setOrderPayStatus(DynamicObject order, DispatchOrderPayStatus status) {
        order.set("paystatus", (Object)status.getFlagStr());
    }

    private static boolean isDelivery(DynamicObject orderEntry) {
        int flag = BigDecimal.ZERO.compareTo(orderEntry.getBigDecimal("deliveredqty"));
        return flag != 0;
    }

    private static boolean isDeliveryOver(DynamicObject orderEntry) {
        int flag = orderEntry.getBigDecimal(QTY).compareTo(orderEntry.getBigDecimal("deliveredqty"));
        return flag <= 0;
    }

    private static boolean isSignOver(DynamicObject orderEntry) {
        int flag = orderEntry.getBigDecimal(QTY).compareTo(orderEntry.getBigDecimal("signedqty"));
        return flag <= 0;
    }

    public static void changeReceivableDate(DynamicObject order) {
        Date receivableDate = new Date();
        if (order.getDate("receivabledate") != null) {
            receivableDate = new Date(order.getDate("receivabledate").getTime());
        }
        HashMap<Object, DynamicObject> saleOrderMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> saleOrderEntryMap = new HashMap<Object, DynamicObject>();
        DynamicObjectCollection itemEntrys = order.getDynamicObjectCollection(ITEM_ENTRY);
        Object orderId = null;
        Long orderEntryId = null;
        boolean isAlterSaleOrder = SysParamsUtil.isAlterSaleOrderByReceivableDate();
        for (DynamicObject itemEntry : itemEntrys) {
            DynamicObject saleOrderEntry;
            DynamicObject owner = order.getDynamicObject("owner");
            DynamicObject item = itemEntry.getDynamicObject("item");
            DynamicObject unit = itemEntry.getDynamicObject(UNIT);
            if (owner == null || item == null || unit == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5f52\u5c5e\u6e20\u9053\uff0c\u5206\u5f55\u5546\u54c1\uff0c\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"DispatchOrderHandler_8", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            Object assistattrId = 0L;
            DynamicObject assistattr = itemEntry.getDynamicObject("assistattr");
            if (assistattr != null) {
                assistattrId = assistattr.get("id");
            }
            BigDecimal priceItem = PriceUtil.getPriceByDate(item.get("id"), unit.get("id"), assistattrId, owner.get("id"), receivableDate);
            itemEntry.set(ITEM_PRICE, (Object)priceItem);
            DispatchOrderHandler.reCalcuHightPriceRatio(itemEntry);
            if (!isAlterSaleOrder) continue;
            orderId = itemEntry.get(SOURCEBILLID);
            orderEntryId = itemEntry.getLong(SOURCEENTRYID);
            DynamicObject saleOrder = (DynamicObject)saleOrderMap.get(orderId);
            if (saleOrder == null) {
                saleOrder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
                if (saleOrder == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u8981\u8d27\u8ba2\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"DispatchOrderHandler_9", (String)"drp-mdr-common", (Object[])new Object[0]));
                }
                saleOrderMap.put(orderId, saleOrder);
                DynamicObjectCollection saleOrderEntrys = saleOrder.getDynamicObjectCollection(ITEM_ENTRY);
                saleOrderEntryMap.putAll(CommonUtils.collection2Map("id", (List<DynamicObject>)saleOrderEntrys));
            }
            if ((saleOrderEntry = (DynamicObject)saleOrderEntryMap.get(orderEntryId)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u8981\u8d27\u8ba2\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"DispatchOrderHandler_10", (String)"drp-mdr-common", (Object[])new Object[0]));
            }
            saleOrderEntry.set(ITEM_PRICE, (Object)priceItem);
        }
        if (isAlterSaleOrder) {
            for (DynamicObject saleOrder : saleOrderMap.values()) {
                OrderVersionStrategyFactory.saveVersion(saleOrder, "save");
                SaleOrderHandler.reHandleOrderReceStatus(saleOrder);
                SaleOrderHandler.reSetSaleAndDispatchConfirmStatusByReceStatus(saleOrder);
                OrderOperateLogHandler.save(saleOrder, "change", ResManager.loadKDString((String)"EAS\u5e94\u6536\u5355\u53d8\u66f4\u91cd\u53d6\u5546\u54c1\u4ef7\u683c\u3002", (String)"DispatchOrderHandler_11", (String)"drp-mdr-common", (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            }
        }
    }
}

