/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.handler;

import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.StringUtils;

public class OrderOperateLogHandler {
    private static final String ORDERID = "orderid";
    private static final String BILLNO = "billno";
    private static final String HISTORYORDERID = "historyorderid";
    private static final String ORDERTYPE = "ordertype";
    private static final String CREATER = "creater";
    private static final String CREATEDATE = "createdate";
    private static final String OPERATE = "operate";
    private static final String OPERATE_KEY = "operatekey";
    private static final String REMARK = "remark";
    private static final HashMap<String, String> OPERATES = new HashMap();

    public static void save(DynamicObject order, String op) {
        OrderOperateLogHandler.save(order, op, "", null);
    }

    public static void save(DynamicObject order, String op, String remark) {
        OrderOperateLogHandler.save(order, op, remark, null);
    }

    public static void save(DynamicObject order, String op, String remark, Object historyOrderId) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"mdr_order_op_log");
        log.set(ORDERID, order.get("id"));
        log.set(BILLNO, order.get(BILLNO));
        log.set(HISTORYORDERID, historyOrderId);
        log.set(CREATER, (Object)RequestContext.get().getUserId());
        log.set(CREATEDATE, (Object)new Date());
        log.set(OPERATE, (Object)OrderOperateLogHandler.getOpName(op));
        log.set(OPERATE_KEY, (Object)op);
        log.set(REMARK, (Object)remark);
        if ("mdr_saleorder".equals(order.getDynamicObjectType().getName()) || "mdr_purorder".equals(order.getDynamicObjectType().getName()) || "bbc_saleorder".equals(order.getDynamicObjectType().getName()) || "dpa_purorder".equals(order.getDynamicObjectType().getName())) {
            log.set(ORDERTYPE, (Object)"saleorder");
        } else if ("mdr_dispatch_order".equals(order.getDynamicObjectType().getName())) {
            log.set(ORDERTYPE, (Object)"dispatchorder");
        } else if ("mdr_returnorder_req".equals(order.getDynamicObjectType().getName())) {
            log.set(ORDERTYPE, (Object)"returnorder");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static String getOpName(String op) {
        if (StringUtils.isEmpty(op)) {
            return ResManager.loadKDString((String)"\u65e0", (String)"OrderOperateLogHandler_25", (String)"drp-mdr-common", (Object[])new Object[0]);
        }
        String opName = op;
        if (OPERATES.get(opName) != null) {
            opName = OPERATES.get(opName);
        }
        return opName;
    }

    public static String getOpMessage(String op) {
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u786e\u8ba4", (String)"OrderOperateLogHandler_26", (String)"drp-mdr-common", (Object[])new Object[0]));
        message.append(OrderOperateLogHandler.getOpName(op));
        message.append(ResManager.loadKDString((String)"\u8ba2\u5355\uff1f", (String)"OrderOperateLogHandler_27", (String)"drp-mdr-common", (Object[])new Object[0]));
        return message.toString();
    }

    static {
        OPERATES.put("save", ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OrderOperateLogHandler_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("submit", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"OrderOperateLogHandler_1", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("unsubmit", ResManager.loadKDString((String)"\u64a4\u9500", (String)"OrderOperateLogHandler_2", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("audit", ResManager.loadKDString((String)"\u5ba1\u6838", (String)"OrderOperateLogHandler_3", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("unaudit", ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"OrderOperateLogHandler_4", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("delete", ResManager.loadKDString((String)"\u5220\u9664", (String)"OrderOperateLogHandler_5", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("saveandnew", ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u65b0\u589e", (String)"OrderOperateLogHandler_6", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("submitandnew", ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u65b0\u589e", (String)"OrderOperateLogHandler_7", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("invalid", ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"OrderOperateLogHandler_8", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("valid", ResManager.loadKDString((String)"\u53cd\u4f5c\u5e9f", (String)"OrderOperateLogHandler_9", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("change", ResManager.loadKDString((String)"\u53d8\u66f4", (String)"OrderOperateLogHandler_10", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("confirmchange", ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"OrderOperateLogHandler_11", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("savechange", ResManager.loadKDString((String)"\u4fdd\u5b58\u53d8\u66f4", (String)"OrderOperateLogHandler_12", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("tosync", ResManager.loadKDString((String)"\u540c\u6b65", (String)"OrderOperateLogHandler_13", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("cancelsync", ResManager.loadKDString((String)"\u53d6\u6d88\u540c\u6b65", (String)"OrderOperateLogHandler_14", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("sendallotmsg", ResManager.loadKDString((String)"\u53d1\u9001\u5206\u8d27\u77ed\u4fe1", (String)"OrderOperateLogHandler_15", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("sendamountmsg", ResManager.loadKDString((String)"\u53d1\u9001\u5e94\u6536\u77ed\u4fe1", (String)"OrderOperateLogHandler_16", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("toallot", ResManager.loadKDString((String)"\u5206\u914d", (String)"OrderOperateLogHandler_17", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("generation", ResManager.loadKDString((String)"\u751f\u6210\u6b20\u6b3e\u7533\u8bf7\u5355", (String)"OrderOperateLogHandler_18", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("pushdispatchorder", ResManager.loadKDString((String)"\u4e0b\u63a8\u914d\u8d27\u5355", (String)"OrderOperateLogHandler_19", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("pushlogisticssend", ResManager.loadKDString((String)"\u4e0b\u63a8\u7269\u6d41\u6d3e\u8f66\u5355", (String)"OrderOperateLogHandler_20", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("withdraw", ResManager.loadKDString((String)"\u64a4\u56de", (String)"OrderOperateLogHandler_21", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("dispatchconfirm", ResManager.loadKDString((String)"\u786e\u8ba4\u5206\u914d", (String)"OrderOperateLogHandler_22", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("amountconfirm", ResManager.loadKDString((String)"\u786e\u8ba4\u5e94\u6536", (String)"OrderOperateLogHandler_23", (String)"drp-mdr-common", (Object[])new Object[0]));
        OPERATES.put("psedelete", ResManager.loadKDString((String)"\u5ba2\u6237\u5220\u9664", (String)"OrderOperateLogHandler_24", (String)"drp-mdr-common", (Object[])new Object[0]));
    }
}

