/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.handler;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.handler.BalanceHandler;
import kd.drp.mdr.common.model.CurrentInfo;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.OperationUtil;

public class ReceivingBillHandler {
    private static final String NUMBER = "number";
    private static final String CONTACTS_CUSTOMER = "contactscustomer";
    private static final String ISADDNEW = "isaddnew";
    private static final String REMARK = "remark";
    private static final String AMOUNT = "amount";
    private static final String RECEIVINGTYPE = "receivingtype";
    private static final String PAYMENTTYPE = "paymenttype";
    private static final String PAYMENTCHANNEL = "paymentchannel";
    private static final String PAYMENTTIME = "paymenttime";
    private static final String CURRENCY = "currency";
    private static final DBRoute ROUTE = new DBRoute("mdr");
    private static final String UPDATE_SALEORDER_RETURNBALANCE = "update t_bbc_saleorder set freturnbalance = freturnbalance + ? where forderid = ? and freturnbalance + ? <= fusedbalance and freturnbalance + ? >= 0";
    private CurrentInfo current;

    public static void handleOffsetBill(DynamicObject saleorder, boolean isAdd, String operate) {
        if (isAdd) {
            BigDecimal amount = saleorder.getBigDecimal("usedbalance");
            ReceivingBillHandler.createOffsetBill(saleorder, amount, operate);
        } else {
            ReceivingBillHandler.deleteOffsetBill(saleorder);
        }
    }

    public static void handleOffsetBill(DynamicObject saleorder, BigDecimal amount, boolean isAdd) {
        if (isAdd) {
            ReceivingBillHandler.createOffsetBill(saleorder, amount, "change");
        } else {
            ReceivingBillHandler.deleteOffsetBill(saleorder);
        }
    }

    public static void handleRefundsBill(DynamicObject saleorder, BigDecimal amount, boolean isAdd) {
        if (isAdd) {
            ReceivingBillHandler.createRefundsBill(saleorder, amount);
        } else {
            ReceivingBillHandler.deleteRefundsBill(saleorder);
        }
    }

    private static void createOffsetBill(DynamicObject saleorder, BigDecimal amount, String operate) {
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        DynamicObject offsetBill = ReceivingBillHandler.createReceivingBill();
        DynamicObject owner = (DynamicObject)saleorder.get("owner");
        DynamicObject customer = (DynamicObject)saleorder.get("customer");
        offsetBill.set("owner", (Object)owner);
        offsetBill.set(CONTACTS_CUSTOMER, (Object)customer);
        if ("audit".equals(operate) || "change".equals(operate)) {
            amount = amount.negate();
        }
        offsetBill.set(AMOUNT, (Object)amount);
        offsetBill.set("orderid", saleorder.get("id"));
        offsetBill.set("ordertype", (Object)"saleorder");
        offsetBill.set(RECEIVINGTYPE, (Object)"4");
        offsetBill.set("sourcebillno", saleorder.get("billno"));
        offsetBill.set("status", (Object)Character.valueOf('B'));
        try (TXHandle h = TX.required();){
            OperationResult result = OperationUtil.invokeOperation(offsetBill, "save");
            List ids = result.getSuccessPkIds();
            offsetBill = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"mdr_money_receivingbill");
            OperationUtil.invokeOperation(offsetBill, "audit");
            if ("audit".equals(operate)) {
                BalanceHandler.updateBalance(owner.getPkValue(), customer.getPkValue(), amount, amount);
            } else if ("change".equals(operate)) {
                BalanceHandler.updateBalance(owner.getPkValue(), customer.getPkValue(), amount, null);
            }
        }
    }

    private static void deleteOffsetBill(DynamicObject saleorder) {
        DynamicObject owner = (DynamicObject)saleorder.get("owner");
        DynamicObject customer = (DynamicObject)saleorder.get("customer");
        QFilter filter = new QFilter("owner", "=", owner.getPkValue()).and(CONTACTS_CUSTOMER, "=", customer.getPkValue()).and("orderid", "=", (Object)saleorder.get("id").toString()).and(RECEIVINGTYPE, "=", (Object)"4");
        DynamicObjectCollection offsetBills = QueryServiceHelper.query((String)"mdr_money_receivingbill", (String)"id", (QFilter[])filter.toArray());
        try (TXHandle h = TX.required();){
            try {
                for (DynamicObject offsetBill : offsetBills) {
                    offsetBill = BusinessDataServiceHelper.loadSingle((Object)offsetBill.get("id"), (String)"mdr_money_receivingbill");
                    BigDecimal amount = offsetBill.getBigDecimal(AMOUNT);
                    OperationResult result = OperationUtil.invokeOperation(offsetBill, "unaudit");
                    List ids = result.getSuccessPkIds();
                    offsetBill = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"mdr_money_receivingbill");
                    OperationUtil.invokeOperation(offsetBill, "delete");
                    BalanceHandler.updateBalance(owner.getPkValue(), customer.getPkValue(), amount.negate(), null);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static boolean deleteReceivingBill(DynamicObject returnOrderObj) {
        DynamicObject owner = (DynamicObject)returnOrderObj.get("owner");
        DynamicObject customer = (DynamicObject)returnOrderObj.get("customer");
        QFilter filter = new QFilter("owner", "=", owner.getPkValue()).and(CONTACTS_CUSTOMER, "=", customer.getPkValue()).and("sourcebillno", "=", (Object)returnOrderObj.getString("billno")).and(RECEIVINGTYPE, "=", (Object)"1");
        DynamicObjectCollection offsetBills = QueryServiceHelper.query((String)"mdr_money_receivingbill", (String)"id", (QFilter[])filter.toArray());
        if (offsetBills.size() > 0) {
            DynamicObject offsetBill = (DynamicObject)offsetBills.get(0);
            offsetBill = BusinessDataServiceHelper.loadSingle((Object)offsetBill.get("id"), (String)"mdr_money_receivingbill");
            BigDecimal amount = offsetBill.getBigDecimal(AMOUNT);
            OperationResult result = OperationUtil.invokeOperation(offsetBill, "unaudit");
            List ids = result.getSuccessPkIds();
            offsetBill = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"mdr_money_receivingbill");
            OperationUtil.invokeOperation(offsetBill, "delete");
            BalanceHandler.updateBalance(owner.getPkValue(), customer.getPkValue(), amount, null);
            ReceivingBillHandler.reWriteSaleOrder(((DynamicObject)returnOrderObj.getDynamicObjectCollection("itementry").get(0)).getLong("srcbillid"), amount);
        }
        return Boolean.TRUE;
    }

    private static void reWriteSaleOrder(long saleOrderId, BigDecimal amount) {
        int res = DB.update((DBRoute)ROUTE, (String)UPDATE_SALEORDER_RETURNBALANCE, (Object[])new Object[]{amount, saleOrderId, amount, amount});
        if (res != 1) {
            throw new KDBizException("\u8ddf\u65b0\u540e\u7684\u9000\u56de\u9884\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u8981\u8d27\u8ba2\u5355\u672c\u6b21\u62b5\u7528\u91d1\u989d\uff0c\u8ddf\u65b0\u5931\u8d25");
        }
    }

    public static boolean newReceivingBillThenAudit(DynamicObject returnOrderObj) {
        DynamicObject newReceivingBillObj = ReceivingBillHandler.newReceivingBillObj(returnOrderObj);
        if (newReceivingBillObj != null) {
            OperationResult result = OperationUtil.invokeOperation(newReceivingBillObj, "save");
            List ids = result.getSuccessPkIds();
            newReceivingBillObj = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"mdr_money_receivingbill");
            OperationUtil.invokeOperation(newReceivingBillObj, "audit");
            BalanceHandler.updateBalance(DynamicObjectUtils.getPkId(newReceivingBillObj, "owner"), DynamicObjectUtils.getPkId(newReceivingBillObj, CONTACTS_CUSTOMER), newReceivingBillObj.getBigDecimal(AMOUNT).negate(), null);
            ReceivingBillHandler.reWriteSaleOrder(((DynamicObject)returnOrderObj.getDynamicObjectCollection("itementry").get(0)).getLong("srcbillid"), newReceivingBillObj.getBigDecimal(AMOUNT).negate());
        }
        return Boolean.TRUE;
    }

    private static DynamicObject newReceivingBillObj(DynamicObject returnOrderObj) {
        BigDecimal amount = ReceivingBillHandler.calAmount(returnOrderObj);
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        DynamicObject newReceivingBillObj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_money_receivingbill");
        newReceivingBillObj.set("owner_id", DynamicObjectUtils.getPkId(returnOrderObj, "owner"));
        newReceivingBillObj.set("contactscustomer_id", DynamicObjectUtils.getPkId(returnOrderObj, "customer"));
        newReceivingBillObj.set(RECEIVINGTYPE, (Object)"1");
        newReceivingBillObj.set(PAYMENTTYPE, (Object)"1");
        newReceivingBillObj.set(PAYMENTCHANNEL, (Object)"2");
        Date date = new Date();
        newReceivingBillObj.set(PAYMENTTIME, (Object)date);
        newReceivingBillObj.set(REMARK, (Object)(((DynamicObject)returnOrderObj.getDynamicObjectCollection("itementry").get(0)).getString("srcbillnumber") + "\u9000\u8d27\u91ca\u653e\u9884\u4ed8\u6b3e"));
        newReceivingBillObj.set("status", (Object)"B");
        newReceivingBillObj.set("currency_id", DynamicObjectUtils.getPkId(returnOrderObj, CURRENCY));
        newReceivingBillObj.set("sourcebillno", (Object)returnOrderObj.getString("billno"));
        newReceivingBillObj.set("ordertype", (Object)"mdr_returnorder");
        newReceivingBillObj.set(ISADDNEW, (Object)Boolean.FALSE);
        newReceivingBillObj.set(AMOUNT, (Object)amount.negate());
        newReceivingBillObj.set("creatorid_id", (Object)RequestContext.get().getCurrUserId());
        newReceivingBillObj.set("createtime", (Object)date);
        return newReceivingBillObj;
    }

    private static BigDecimal calAmount(DynamicObject returnOrderObj) {
        BigDecimal totalAmountAndTax = returnOrderObj.getBigDecimal("totalamountandtax");
        long saleOrderId = ((DynamicObject)returnOrderObj.getDynamicObjectCollection("itementry").get(0)).getLong("srcbillid");
        DynamicObject saleOrderObj = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"bbc_saleorder", (String)"id,isusebalance,usedbalance,returnbalance");
        if (saleOrderObj.getBoolean("isusebalance")) {
            BigDecimal subtract = saleOrderObj.getBigDecimal("usedbalance").subtract(saleOrderObj.getBigDecimal("returnbalance"));
            return totalAmountAndTax.min(subtract);
        }
        return BigDecimal.ZERO;
    }

    private static void createRefundsBill(DynamicObject saleorder, BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        DynamicObject offsetBill = ReceivingBillHandler.createReceivingBill();
        DynamicObject owner = (DynamicObject)saleorder.get("owner");
        DynamicObject customer = (DynamicObject)saleorder.get("customer");
        offsetBill.set("owner", (Object)owner);
        offsetBill.set(CONTACTS_CUSTOMER, (Object)customer);
        offsetBill.set(AMOUNT, (Object)amount);
        offsetBill.set("orderid", (Object)saleorder.get("id").toString());
        offsetBill.set("ordertype", (Object)"saleorder");
        offsetBill.set(RECEIVINGTYPE, (Object)"5");
        try (TXHandle h = TX.required();){
            try {
                OperationResult result = OperationUtil.invokeOperation(offsetBill, "save");
                List ids = result.getSuccessPkIds();
                offsetBill = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"mdr_money_receivingbill");
                OperationUtil.invokeOperation(offsetBill, "audit");
                BalanceHandler.updateBalance(owner.getPkValue(), customer.getPkValue(), amount, null);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void deleteRefundsBill(DynamicObject saleorder) {
        DynamicObject owner = (DynamicObject)saleorder.get("owner");
        DynamicObject customer = (DynamicObject)saleorder.get("customer");
        QFilter filter = new QFilter("owner", "=", owner.getPkValue()).and(CONTACTS_CUSTOMER, "=", customer.getPkValue()).and("orderid", "=", (Object)saleorder.get("id").toString()).and(RECEIVINGTYPE, "=", (Object)"5");
        DynamicObjectCollection offsetBills = QueryServiceHelper.query((String)"mdr_money_receivingbill", (String)"id,amount", (QFilter[])filter.toArray());
        try (TXHandle h = TX.required();){
            try {
                for (DynamicObject offsetBill : offsetBills) {
                    offsetBill = BusinessDataServiceHelper.loadSingle((Object)offsetBill.get("id"), (String)"mdr_money_receivingbill");
                    BigDecimal amount = offsetBill.getBigDecimal(AMOUNT);
                    BalanceHandler.updateBalance(owner.getPkValue(), customer.getPkValue(), amount.negate(), null);
                    OperationResult result = OperationUtil.invokeOperation(offsetBill, "unaudit");
                    List ids = result.getSuccessPkIds();
                    offsetBill = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"mdr_money_receivingbill");
                    OperationUtil.invokeOperation(offsetBill, "delete");
                    ReceivingBillHandler.handleOrderAmount(saleorder, amount, true);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public CurrentInfo getCurrent() {
        if (this.current == null) {
            this.current = new CurrentInfo();
        }
        return this.current;
    }

    private static DynamicObject createReceivingBill() {
        DynamicObject offsetBill = BusinessDataServiceHelper.newDynamicObject((String)"mdr_money_receivingbill");
        CurrentInfo current = new CurrentInfo();
        offsetBill.set(ISADDNEW, (Object)Boolean.FALSE);
        offsetBill.set(REMARK, (Object)ResManager.loadKDString((String)"\u7ebf\u4e0a\u8ba2\u5355\u81ea\u52a8\u751f\u6210", (String)"ReceivingBillHandler_0", (String)"drp-mdr-common", (Object[])new Object[0]));
        offsetBill.set(PAYMENTTYPE, (Object)"0");
        offsetBill.set(PAYMENTCHANNEL, (Object)"0");
        offsetBill.set(PAYMENTTIME, (Object)current.getNow());
        offsetBill.set(CURRENCY, (Object)1);
        offsetBill.set("createtime", (Object)current.getNow());
        offsetBill.set("creatorid", current.getUserId());
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)offsetBill.getDataEntityType().getName(), (DynamicObject)offsetBill, null);
        CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)offsetBill);
        if (codeRuleInfo != null) {
            String number = codeRuleInfo.getNumber();
            offsetBill.set(NUMBER, (Object)number);
        }
        return offsetBill;
    }

    private static void handleOrderAmount(DynamicObject saleorder, BigDecimal amount, boolean isAdd) {
        if (!isAdd) {
            amount = amount.negate();
        }
        BigDecimal amounttobepaid = saleorder.getBigDecimal("amounttobepaid");
        BigDecimal receivedamount = saleorder.getBigDecimal("receivedamount");
        BigDecimal totalorderamount = saleorder.getBigDecimal("totalorderamount");
        BigDecimal usedbalance = saleorder.getBigDecimal("usedbalance");
        receivedamount = receivedamount.add(amount);
        amounttobepaid = totalorderamount.subtract(receivedamount);
        if (!isAdd) {
            saleorder.set("usedbalance", (Object)usedbalance.add(amount));
        }
        saleorder.set("amounttobepaid", (Object)amounttobepaid);
        saleorder.set("receivedamount", (Object)receivedamount);
    }
}

