/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.handler.ReceivingBillHandler;
import kd.drp.mdr.common.status.DispatchOrderConfirmStatus;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.status.SaleOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderEvaluateStatus;
import kd.drp.mdr.common.status.SaleOrderPayStatus;
import kd.drp.mdr.common.status.SaleOrderReceStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.EvaluateUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;

public class SaleOrderHandler {
    public static void handleStatusAfterChangeSave(DynamicObject order) {
        SaleOrderHandler.reHandleOrderPayStatus(order);
        SaleOrderHandler.reHandleOrderReceStatus(order);
        SaleOrderHandler.reHandleEvaluateStatus(order);
        SaleOrderHandler.handleOrderIsOver(order);
    }

    public static void handleStatusAfterConfirmChanged(DynamicObject order) {
        SaleOrderHandler.reHandleOrderPayStatus(order);
        SaleOrderHandler.reHandleOrderReceStatus(order);
        SaleOrderHandler.reHandleOrderStatus(order);
        SaleOrderHandler.reHandleEvaluateStatus(order);
        SaleOrderHandler.handleOrderIsOver(order);
    }

    public static void handleStatusAfterSignOrDelivery(DynamicObject order) {
        SaleOrderHandler.reHandleOrderStatus(order);
        SaleOrderHandler.reHandleEvaluateStatus(order);
        SaleOrderHandler.handleOrderIsOver(order);
    }

    public static void handleOrderIsOver(DynamicObject order) {
        SaleOrderStatus orderStatus = SaleOrderUtil.getOrderStatus(order);
        SaleOrderPayStatus orderPayStatus = SaleOrderUtil.getOrderPayStatus(order);
        if (SaleOrderStatus.RECEIVED == orderStatus && SaleOrderPayStatus.ALREADY_PAID == orderPayStatus) {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.COMPLETED);
        }
        SaleOrderHandler.handleOrderIsOverByQty(order);
    }

    public static void handleOrderIsOverByQty(DynamicObject order) {
        DynamicObjectCollection itementry = order.getDynamicObjectCollection("itementry");
        boolean hasOver = false;
        for (DynamicObject entry : itementry) {
            BigDecimal qty = entry.getBigDecimal("qty");
            if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) continue;
            hasOver = true;
            return;
        }
        if (!hasOver) {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.COMPLETED);
        }
    }

    public static void reHandleOrderPayStatus(DynamicObject order) {
        BigDecimal amounttobepaid = order.getBigDecimal("amounttobepaid");
        if (amounttobepaid.compareTo(BigDecimal.ZERO) == 0) {
            SaleOrderHandler.setOrderPayStatus(order, SaleOrderPayStatus.ALREADY_PAID);
        } else {
            SaleOrderHandler.setOrderPayStatus(order, SaleOrderPayStatus.NOT_PAID);
        }
    }

    public static void reHandleOrderReceStatus(DynamicObject order) {
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        BigDecimal alreadyReceQty = null;
        BigDecimal qty = null;
        SaleOrderReceStatus receStatus = null;
        for (DynamicObject entry : entrys) {
            String entrytype = entry.getString("entrytype");
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            alreadyReceQty = entry.getBigDecimal("alreadyreceqty");
            qty = entry.getBigDecimal("qty");
            if (qty.compareTo(BigDecimal.ZERO) > 0 && alreadyReceQty.compareTo(BigDecimal.ZERO) == 0) {
                if (SaleOrderReceStatus.ALREADY_RECE == receStatus) {
                    receStatus = SaleOrderReceStatus.PART_RECE;
                    break;
                }
                receStatus = SaleOrderReceStatus.NO_RECE;
                continue;
            }
            if (alreadyReceQty.compareTo(qty) >= 0) {
                if (SaleOrderReceStatus.NO_RECE == receStatus) {
                    receStatus = SaleOrderReceStatus.PART_RECE;
                    break;
                }
                receStatus = SaleOrderReceStatus.ALREADY_RECE;
                continue;
            }
            receStatus = SaleOrderReceStatus.PART_RECE;
            break;
        }
        if (receStatus == null) {
            receStatus = SaleOrderReceStatus.NO_RECE;
        }
        order.set("amountstatus", (Object)receStatus.getFlagStr());
    }

    private static void reHandleEvaluateStatus(DynamicObject order) {
        ArrayList<SaleOrderStatus> statuss = new ArrayList<SaleOrderStatus>();
        statuss.add(SaleOrderStatus.RECEIVED);
        statuss.add(SaleOrderStatus.COMPLETED);
        String orderstatus = order.getString("orderstatus");
        SaleOrderStatus saleOrderStatus = EnumUtil.toSaleOrderStatus(orderstatus);
        if (statuss.contains((Object)saleOrderStatus)) {
            order.set("evaluatestatus", (Object)SaleOrderEvaluateStatus.TO_EVALUATE.getFlagStr());
        }
        if (EvaluateUtil.hasEvaluate(order.get("id"))) {
            order.set("evaluatestatus", (Object)SaleOrderEvaluateStatus.EVALUATED.getFlagStr());
        }
    }

    public static void reSetSaleAndDispatchConfirmStatusByReceStatus(DynamicObject order) {
        if ((SaleOrderReceStatus.NO_RECE.getFlagStr().equals(order.getString("amountstatus")) || SaleOrderReceStatus.PART_RECE.getFlagStr().equals(order.getString("amountstatus"))) && (SaleOrderConfirmStatus.AMOUNTCONFIRMED.getFlagStr().equals(order.getString("confirmstatus")) || SaleOrderConfirmStatus.AMOUNTSENDED.getFlagStr().equals(order.getString("confirmstatus")))) {
            order.set("confirmstatus", (Object)SaleOrderConfirmStatus.ALLOTCONFIRMED.getFlagStr());
            SaleOrderUtil.unWriteDispatchOrderConfirmStatus(order, DispatchOrderConfirmStatus.ALLOTCONFIRMED.getFlagStr());
        }
    }

    public static void reHandleOrderStatus(DynamicObject order) {
        boolean isDispatch = SysParamsUtil.isDispatch();
        if (isDispatch) {
            SaleOrderHandler.reHandleOrderStatus4Dispatchorder(order);
        } else {
            SaleOrderHandler.handleOrderStatus(order);
        }
    }

    public static void reHandleOrderStatus4Dispatchorder(DynamicObject order) {
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        boolean isDispatch = false;
        boolean isDispatchOver = true;
        boolean isDispatchorderAudit = false;
        boolean isDelivery = false;
        boolean isDeliveryOver = true;
        boolean isSignOver = true;
        boolean isNeedConfirmAfterAllot = SysParamsUtil.isNeedConfirmAfterAllot();
        for (DynamicObject entry : entrys) {
            String entrytype = (String)entry.get("entrytype");
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            if (!isDispatchorderAudit) {
                isDispatchorderAudit = SaleOrderHandler.isDispatchorderAudit(entry);
            }
            if (!isDispatch) {
                isDispatch = SaleOrderHandler.isDispatch(entry);
            }
            if (isDispatchOver) {
                isDispatchOver = SaleOrderHandler.isDispatchOver(entry);
            }
            if (!isDelivery) {
                isDelivery = SaleOrderHandler.isDelivery(entry);
            }
            if (isDeliveryOver) {
                isDeliveryOver = SaleOrderHandler.isDeliveryOver(entry);
            }
            if (!isSignOver) continue;
            isSignOver = SaleOrderHandler.isSignOver(entry);
        }
        if (!isDispatch) {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.PENDING_DISPATCH);
            if (isNeedConfirmAfterAllot) {
                SaleOrderHandler.setOrderConfirmStatus(order, SaleOrderConfirmStatus.ALLOTSENDED);
            } else {
                SaleOrderHandler.setOrderConfirmStatus(order, SaleOrderConfirmStatus.EMPTY);
            }
        } else if (!isDispatchOver) {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.PART_DISPATCH);
            if (isNeedConfirmAfterAllot) {
                SaleOrderHandler.setOrderConfirmStatus(order, SaleOrderConfirmStatus.ALLOTSENDED);
            } else {
                SaleOrderHandler.setOrderConfirmStatus(order, SaleOrderConfirmStatus.EMPTY);
            }
        } else if (isDispatchOver) {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.DISPATCHED);
        }
        if (isDispatchorderAudit) {
            if (isDispatchOver) {
                SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.PENDING_DELIVERY);
            }
            if (isDelivery) {
                if (!isDeliveryOver) {
                    SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.PART_DELIVERY);
                } else if (!isSignOver) {
                    SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.WAITING_RECEIVER);
                } else {
                    SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.RECEIVED);
                }
            }
        }
    }

    private static boolean isDispatchorderAudit(DynamicObject entry) {
        int flag = BigDecimal.ZERO.compareTo(entry.getBigDecimal("allotedqty"));
        return flag != 0;
    }

    private static boolean isDispatch(DynamicObject entry) {
        int flag = BigDecimal.ZERO.compareTo(entry.getBigDecimal("allotenqty"));
        return flag != 0;
    }

    private static boolean isDispatchOver(DynamicObject entry) {
        return entry.getBigDecimal("qty").compareTo(entry.getBigDecimal("allotenqty")) <= 0;
    }

    private static void handleOrderStatus(DynamicObject order) {
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("itementry");
        boolean isDelivery = false;
        boolean isDeliveryOver = true;
        boolean isSignOver = true;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String entrytype = entry.getString("entrytype");
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            if (!isDelivery) {
                isDelivery = SaleOrderHandler.isDelivery(entry);
            }
            if (isDeliveryOver) {
                isDeliveryOver = SaleOrderHandler.isDeliveryOver(entry);
            }
            if (!isSignOver) continue;
            isSignOver = SaleOrderHandler.isSignOver(entry);
        }
        if (!isDelivery) {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.PENDING_DELIVERY);
        } else if (!isDeliveryOver) {
            boolean isUncontrlDeliveryQty = SysParamsUtil.isUnContrlDeliveyQTY();
            if (isUncontrlDeliveryQty) {
                SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.WAITING_RECEIVER);
            } else {
                SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.PART_DELIVERY);
            }
        } else if (!isSignOver) {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.WAITING_RECEIVER);
        } else {
            SaleOrderHandler.setOrderStatus(order, SaleOrderStatus.RECEIVED);
        }
    }

    public static void setOrderStatus(DynamicObject order, SaleOrderStatus status) {
        order.set("orderstatus", (Object)status.getFlagStr());
    }

    public static void setOrderConfirmStatus(DynamicObject order, SaleOrderConfirmStatus status) {
        order.set("confirmstatus", (Object)status.getFlagStr());
    }

    public static void setOrderPayStatus(DynamicObject order, SaleOrderPayStatus status) {
        order.set("paystatus", (Object)status.getFlagStr());
    }

    private static boolean isDelivery(DynamicObject orderEntry) {
        int flag = BigDecimal.ZERO.compareTo(orderEntry.getBigDecimal("deliveredqty"));
        return flag != 0;
    }

    private static boolean isDeliveryOver(DynamicObject orderEntry) {
        int flag = orderEntry.getBigDecimal("qty").compareTo(orderEntry.getBigDecimal("deliveredqty"));
        return flag <= 0;
    }

    private static boolean isSignOver(DynamicObject orderEntry) {
        int flag = orderEntry.getBigDecimal("qty").compareTo(orderEntry.getBigDecimal("signedqty"));
        return flag <= 0;
    }

    public static SaleOrderEntryType getEntryType(DynamicObject orderEntry) {
        String entryType = orderEntry.getString("entrytype");
        SaleOrderEntryType saleOrderEntryType = EnumUtil.toSaleOrderEntryType(entryType);
        return saleOrderEntryType;
    }

    public static List<Object> getAfterDispatchStatus() {
        ArrayList<Object> status = new ArrayList<Object>();
        status.add(SaleOrderStatus.DISPATCHED.getFlagStr());
        status.add(SaleOrderStatus.PENDING_DELIVERY.getFlagStr());
        status.add(SaleOrderStatus.PART_DELIVERY.getFlagStr());
        status.add(SaleOrderStatus.WAITING_RECEIVER.getFlagStr());
        status.add(SaleOrderStatus.RECEIVED.getFlagStr());
        status.add(SaleOrderStatus.COMPLETED.getFlagStr());
        return status;
    }

    public static void handleReceivingBill4Change(DynamicObject saleorder) {
        if (!saleorder.getBoolean("isusebalance")) {
            return;
        }
        DynamicObject oldSaleOrder = BusinessDataServiceHelper.loadSingle((Object)saleorder.get("id"), (String)"bbc_saleorder");
        BigDecimal oldUsedBalacne = oldSaleOrder.getBigDecimal("usedbalance");
        BigDecimal usedBalacne = saleorder.getBigDecimal("usedbalance");
        BigDecimal totalOrderAmount = saleorder.getBigDecimal("totalorderamount");
        BigDecimal amountToBePaid = saleorder.getBigDecimal("amounttobepaid");
        BigDecimal dValue = usedBalacne.subtract(oldUsedBalacne);
        if (dValue.compareTo(BigDecimal.ZERO) < 0) {
            ReceivingBillHandler.handleRefundsBill(saleorder, dValue.negate(), true);
            saleorder.set("receivedamount", (Object)totalOrderAmount.subtract(amountToBePaid));
        } else if (dValue.compareTo(BigDecimal.ZERO) > 0) {
            ReceivingBillHandler.handleOffsetBill(saleorder, dValue, true);
        }
    }
}

