/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;

public class UnitBatchHandler {
    private final String[] cols = new String[]{"id", "denominator", "numerator", "precision", "precisionaccount"};
    protected final Map<Object, JSONObject> loaclMap = new ConcurrentHashMap<Object, JSONObject>();

    public void batchLoad(Collection<Object> itemIds) {
        if (!(itemIds = this.getLocalNotExsistId(itemIds)).isEmpty()) {
            this.batchLoad4LoaclMap(itemIds);
        }
    }

    protected final Collection<Object> getLocalNotExsistId(Collection<Object> itemIds) {
        if (this.loaclMap.isEmpty()) {
            return itemIds;
        }
        ArrayList<Object> notExsistId = new ArrayList<Object>();
        for (Object id : itemIds) {
            if (this.loaclMap.containsKey(id)) continue;
            notExsistId.add(id);
        }
        return notExsistId;
    }

    protected final Map<Object, JSONObject> batchLoad4LoaclMap(Collection<Object> itemIds) {
        Map<Object, JSONObject> itemUnits = this.loadItemUnitsFromService(itemIds);
        this.loaclMap.putAll(itemUnits);
        return itemUnits;
    }

    protected final JSONObject load4LoaclMap(Object itemId) {
        ArrayList<Object> itemIds = new ArrayList<Object>(1);
        itemIds.add(itemId);
        Map<Object, JSONObject> itemUnits = this.batchLoad4LoaclMap(itemIds);
        return itemUnits.get(itemId);
    }

    public BigDecimal getQtyFromAssistUnit(Object itemId, Object assistUnit, BigDecimal assistUnitQty, Object toUnit) {
        BigDecimal qty = this.getUnitQty(itemId, assistUnit, toUnit, assistUnitQty);
        return qty;
    }

    public BigDecimal getUnitQty(Object itemId, Object fromUnit, Object toUnit, BigDecimal fromUnitqty) {
        if (fromUnit.equals(toUnit)) {
            return fromUnitqty;
        }
        JSONObject fromUnitCalcuInfo = this.getUnitCalcuInfo(itemId, fromUnit);
        JSONObject toUnitCalcuInfo = this.getUnitCalcuInfo(itemId, toUnit);
        int precision = toUnitCalcuInfo.getIntValue("precision");
        int precisionaccount = this.parseMode(toUnitCalcuInfo.getString("precisionaccount"));
        BigDecimal[] fromNums = this.getNumeratorAndDenominator(itemId, fromUnitCalcuInfo);
        BigDecimal[] toNums = this.getNumeratorAndDenominator(itemId, toUnitCalcuInfo);
        BigDecimal result = fromUnitqty.multiply(fromNums[0].multiply(toNums[1])).divide(fromNums[1].multiply(toNums[0]), precision, precisionaccount);
        return result;
    }

    public BigDecimal getUnitQty(Object itemId, Object unitId, BigDecimal baseQty) {
        BigDecimal qty = this.calcuQty(itemId, unitId, baseQty, false);
        return qty;
    }

    public BigDecimal getBaseQty(Object itemId, BigDecimal unitQty, Object unitId) {
        BigDecimal qty = this.calcuQty(itemId, unitId, unitQty, true);
        return qty;
    }

    private BigDecimal calcuQty(Object itemId, Object fromOrToUnitId, BigDecimal unitQty, boolean isToBaseQty) {
        JSONObject baseUnitInfo = this.getBaseUnitData(itemId);
        if (baseUnitInfo != null && baseUnitInfo.get((Object)"id").toString().equals(fromOrToUnitId.toString())) {
            return unitQty;
        }
        JSONObject unitCalcuInfo = this.getUnitCalcuInfo(itemId, fromOrToUnitId);
        BigDecimal[] nums = this.getNumeratorAndDenominator(itemId, unitCalcuInfo);
        JSONObject targetUnit = isToBaseQty ? baseUnitInfo : unitCalcuInfo;
        BigDecimal multiplyNum = isToBaseQty ? nums[0] : nums[1];
        BigDecimal divideMum = isToBaseQty ? nums[1] : nums[0];
        int precision = 0;
        if (targetUnit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u6362\u7b97\u7684\u5355\u4f4d\u4e3a\u7a7a\uff01", (String)"UnitBatchHandler_4", (String)"drp-mdr-common", (Object[])new Object[0]));
        }
        precision = targetUnit.getIntValue("precision");
        int precisionaccount = this.parseMode(targetUnit.getString("precisionaccount"));
        BigDecimal result = unitQty.multiply(multiplyNum).divide(divideMum, precision, precisionaccount);
        return result;
    }

    private BigDecimal[] getNumeratorAndDenominator(Object itemId, JSONObject unitCalcuInfo) {
        BigDecimal numerator = unitCalcuInfo.getBigDecimal("numerator");
        BigDecimal denominator = unitCalcuInfo.getBigDecimal("denominator");
        if (denominator == null || numerator == null || denominator.multiply(numerator).compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u5bf9\u5e94\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u5217\u8868\u4e2d\uff0c\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011\u6362\u7b97\u5206\u5b50\u3010%s\u3011\u5206\u6bcd\u3010%s\u3011\u4e0d\u5408\u6cd5\uff0c\u65e0\u6cd5\u8ba1\u7b97", (String)"UnitBatchHandler_0", (String)"drp-mdr-common", (Object[])new Object[0]), itemId, unitCalcuInfo.get((Object)"id"), numerator, denominator));
        }
        return new BigDecimal[]{numerator, denominator};
    }

    private int parseMode(String type) {
        if ("2".equals(type)) {
            return 1;
        }
        if ("3".equals(type)) {
            return 2;
        }
        return 4;
    }

    private JSONObject getUnitCalcuInfo(Object itemId, Object unitId) {
        JSONObject unitData = this.getItemUnitData(itemId);
        JSONArray ids = unitData.getJSONArray("id");
        int index = ids.indexOf(unitId);
        if (index < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u5bf9\u5e94\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u5217\u8868\u4e2d\uff0c\u6ca1\u6709\u8be5\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011", (String)"UnitBatchHandler_1", (String)"drp-mdr-common", (Object[])new Object[0]), itemId, unitId));
        }
        return this.getUnitDataByIndex(unitData, index);
    }

    private JSONObject tryGetItemUnitData(Object itemId) {
        JSONObject info = this.loaclMap.get(itemId);
        if (info == null) {
            info = this.load4LoaclMap(itemId);
        }
        return info;
    }

    protected void checkUnit(Object itemId, JSONObject info) {
        if (info.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1[%s]\u672a\u67e5\u5230\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u6838\u67e5", (String)"UnitBatchHandler_2", (String)"drp-mdr-common", (Object[])new Object[0]), itemId));
        }
    }

    protected JSONObject getItemUnitData(Object itemId) {
        JSONObject info = this.tryGetItemUnitData(itemId);
        this.checkUnit(itemId, info);
        return info;
    }

    public List<Object> getUnitIdList(Object itemId) {
        JSONObject unitInfos = this.getItemUnitData(itemId);
        JSONArray unitIds = unitInfos.getJSONArray("id");
        return new ArrayList<Object>((Collection<Object>)unitIds);
    }

    public Object getBaseUnitId(Object itemId) {
        JSONObject baseUnitInfo = this.getBaseUnitData(itemId);
        Long id = 0L;
        if (baseUnitInfo != null) {
            id = baseUnitInfo.getLong("id");
        }
        return id;
    }

    public Object getSaleUnitId(Object itemId) {
        JSONObject baseUnitInfo = this.getSaleUnitData(itemId);
        Long id = 0L;
        if (baseUnitInfo != null) {
            id = baseUnitInfo.getLong("id");
        }
        return id;
    }

    public Object getAssistUnitId(Object itemId) {
        JSONObject assistUnitData = this.getAssistUnitData(itemId);
        if (assistUnitData == null) {
            return null;
        }
        Long id = assistUnitData.getLong("id");
        return id;
    }

    private JSONObject getBaseUnitData(Object itemId) {
        return this.getUnitData(itemId, "baseUnit");
    }

    private JSONObject getSaleUnitData(Object itemId) {
        return this.getUnitData(itemId, "saleUnit");
    }

    private JSONObject getAssistUnitData(Object itemId) {
        return this.getUnitData(itemId, "assistUnit");
    }

    private JSONObject getUnitData(Object itemId, String unitNameKey) {
        JSONObject itemUnitData = this.getItemUnitData(itemId);
        int index = itemUnitData.getIntValue(unitNameKey);
        if (index < 0) {
            return null;
        }
        return this.getUnitDataByIndex(itemUnitData, index);
    }

    private JSONObject getUnitDataByIndex(JSONObject itemUnitData, int index) {
        JSONObject info = new JSONObject();
        for (String col : this.cols) {
            info.put(col, itemUnitData.getJSONArray(col).get(index));
        }
        return info;
    }

    private Map<Object, JSONObject> loadItemUnitsFromService(Collection<Object> itemIds) {
        if (itemIds.isEmpty()) {
            return new HashMap<Object, JSONObject>();
        }
        String jsonIds = JSON.toJSONString(itemIds);
        JSONObject itemUnitDatas = (JSONObject)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dbd", (String)"UnitService", (String)"queryUnitInfoByItemIds", (Object[])new Object[]{jsonIds});
        JSONObject itemUnitData = null;
        ArrayList<Object> noUnitDataIds = new ArrayList<Object>();
        HashMap<Object, JSONObject> itemUnitDataMap = new HashMap<Object, JSONObject>(itemIds.size());
        for (Object itemId : itemIds) {
            itemUnitData = itemUnitDatas.getJSONObject(itemId.toString());
            if (itemUnitData == null) {
                noUnitDataIds.add(itemId);
                itemUnitData = new JSONObject();
            }
            this.parseUnitIdToLong(itemUnitData);
            itemUnitDataMap.put(itemId, itemUnitData);
        }
        if (noUnitDataIds.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1%s\u672a\u67e5\u5230\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u6838\u67e5", (String)"UnitBatchHandler_3", (String)"drp-mdr-common", (Object[])new Object[0]), this.getItemNames(itemIds)));
        }
        return itemUnitDataMap;
    }

    protected final void parseUnitIdToLong(JSONObject itemUnitData) {
        JSONArray ids = itemUnitData.getJSONArray("id");
        String newStr = ids.toJSONString();
        itemUnitData.put("id", (Object)JSON.parseArray((String)newStr, Long.class));
    }

    private List<Object> getItemNames(Collection<Object> itemIds) {
        String jsonIds = JSON.toJSONString(itemIds);
        JSONArray names = (JSONArray)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dbd", (String)"ItemService", (String)"queryNames", (Object[])new Object[]{jsonIds});
        return names;
    }

    public String toString() {
        return this.loaclMap.toString();
    }
}

