/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.itemclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.cache.ItemClassTreeCache;
import kd.drp.mdr.common.cache.model.FCNode;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.QueryUtil;

public class ItemClassUtil {
    public static List<Object> queryClassList(Object itemId) {
        List<Object> classList = new ArrayList<Object>();
        if (itemId == null) {
            return classList;
        }
        DynamicObject itemInfo = ItemUtil.loadInfoById(itemId, "itemclass");
        DynamicObject itemclass = itemInfo.getDynamicObject("itemclass");
        if (itemclass == null) {
            return classList;
        }
        classList = ItemClassUtil.getParentIds(itemclass.get("id"));
        return classList;
    }

    public static Set<Object> queryParentItemClasses(Collection<Object> ids) {
        ItemClassTreeCache cache = ItemClassTreeCache.getCache();
        Map<Object, FCNode> childMap = cache.getChildMap();
        List<Object> fids = ItemClassUtil.getParentIds(ids, childMap);
        return new HashSet<Object>(fids);
    }

    private static List<Object> getParentIds(Collection<Object> ids, Map<Object, FCNode> childMap) {
        ArrayList<FCNode> fNodes = new ArrayList<FCNode>(ids.size());
        for (Object id : ids) {
            fNodes.add(childMap.get(id));
        }
        return FCNode.getFatherIds(fNodes);
    }

    private static List<Object> getParentIds(Object id) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (id == null) {
            return list;
        }
        ItemClassTreeCache cache = ItemClassTreeCache.getCache();
        Map<Object, FCNode> childMap = cache.getChildMap();
        while (id != null && !id.equals(0L)) {
            list.add(id);
            FCNode fcNode = childMap.get(id);
            if (fcNode == null) break;
            id = fcNode.getFather();
        }
        return list;
    }

    public static Set<Object> queryAllParentItemClasses(Collection<Object> ids) {
        HashSet<Object> allIds = new HashSet<Object>();
        if (ids.isEmpty()) {
            return allIds;
        }
        ItemClassTreeCache cache = ItemClassTreeCache.getCache();
        Map<Object, FCNode> childMap = cache.getChildMap();
        while (!(ids = ItemClassUtil.getParentIds(ids, childMap)).isEmpty()) {
            allIds.addAll(ids);
        }
        return allIds;
    }

    public static Set<Object> queryAllSubItemClasses(Collection<Object> ids) {
        HashSet<Object> allIds = new HashSet<Object>();
        ItemClassTreeCache cache = ItemClassTreeCache.getCache();
        Map<Object, List<FCNode>> fatherMap = cache.getFatherMap();
        int count = 0;
        while (!(ids = ItemClassUtil.getSubIds(fatherMap, ids)).isEmpty()) {
            allIds.addAll(ids);
            if (++count <= 20) continue;
            break;
        }
        return allIds;
    }

    private static List<Object> getSubIds(Map<Object, List<FCNode>> fatherMap, Collection<Object> fids) {
        ArrayList<Object> idList = new ArrayList<Object>();
        List<FCNode> fcs = null;
        for (Object fid : fids) {
            fcs = fatherMap.get(fid);
            if (fcs == null) continue;
            idList.addAll(FCNode.getChildIds(fcs));
        }
        return idList;
    }

    public static Set<Object> querySubItemClasses(Collection<Object> ids) {
        ItemClassTreeCache cache = ItemClassTreeCache.getCache();
        Map<Object, List<FCNode>> fatherMap = cache.getFatherMap();
        List<Object> subIds = ItemClassUtil.getSubIds(fatherMap, ids);
        return new HashSet<Object>(subIds);
    }

    public static Set<Object> querySubItemClasses(Object id) {
        HashSet<Object> idSet = new HashSet<Object>();
        ItemClassTreeCache cache = ItemClassTreeCache.getCache();
        Map<Object, List<FCNode>> fatherMap = cache.getFatherMap();
        List<FCNode> fcs = fatherMap.get(id);
        idSet.addAll(FCNode.getChildIds(fcs));
        return idSet;
    }

    public static Set<Object> queryItemClassesByItems(Set<Object> ids) {
        QFilter fs = new QFilter("id", "in", ids);
        return QueryUtil.querySingleCol("mdr_item_info", "itemclass", fs.toArray());
    }

    public static Set<Object> queryItemsByClasses(Set<Object> ids) {
        if (ids.isEmpty()) {
            return new HashSet<Object>();
        }
        QFilter fs = new QFilter("itemclassentity.goodsclasssid", "in", ids);
        return QueryUtil.querySingleCol("mdr_item_info", "id", fs.toArray());
    }

    public static Set<Object> queryAllItemsByClasses(Set<Object> ids) {
        if (ids.isEmpty()) {
            return new HashSet<Object>();
        }
        HashSet<Object> idSet = new HashSet<Object>();
        idSet.addAll(ItemClassUtil.queryAllSubItemClasses(ids));
        idSet.addAll(ids);
        return ItemClassUtil.queryItemsByClasses(idSet);
    }
}

