/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.itemcontrol;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.cache.model.ItemSaleInfo;
import kd.drp.mdr.common.cache.model.PathSaleInfo;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;
import org.apache.commons.lang.StringUtils;

public class ItemSaleControlUtil {
    private static final String KEY = "key_salecontrol";
    private static final int MAX_KEY_COUNT = 8;

    public static QFilter getItemFilter(Object authOwnerId, Object customerId) {
        PathSaleInfo saleInfo = ItemSaleControlUtil.getPathSaleInfo(authOwnerId, customerId);
        return ItemSaleControlUtil.getItemFilterByPathSaleInfo(saleInfo);
    }

    public static QFilter getItemFilter(Object customerId) {
        PathSaleInfo saleInfo = ItemSaleControlUtil.getPathSaleInfo(customerId);
        return ItemSaleControlUtil.getItemFilterByPathSaleInfo(saleInfo);
    }

    public static QFilter getItemFilterUsePageCache(Object customerId, IPageCache pageCache) {
        return ItemSaleControlUtil.getItemFilterUsePageCache(null, customerId, pageCache);
    }

    public static QFilter getItemFilterUsePageCache(Object authOwnerId, Object customerId, IPageCache pageCache) {
        if (pageCache != null) {
            String valueKey = new StringBuffer(KEY).append(authOwnerId).append(customerId).toString();
            String filterStr = pageCache.get(valueKey);
            if (filterStr == null) {
                QFilter fList = ItemSaleControlUtil.autoGetItemFilter(authOwnerId, customerId);
                pageCache.put(valueKey, fList.toSerializedString());
                ItemSaleControlUtil.handleValueKey(valueKey, pageCache);
                return fList;
            }
            if ("all".equals(filterStr)) {
                return null;
            }
            return QFilter.fromSerializedString((String)filterStr);
        }
        return ItemSaleControlUtil.autoGetItemFilter(authOwnerId, customerId);
    }

    private static void handleValueKey(String valueKey, IPageCache pageCache) {
        String keys = pageCache.get(KEY);
        if (StringUtils.isEmpty((String)keys)) {
            pageCache.put(KEY, valueKey);
        } else {
            String splitFlag = ",";
            StringBuilder newKeys = new StringBuilder(valueKey);
            String[] keyArr = keys.split(splitFlag);
            if (keyArr.length >= 8) {
                for (int i = 0; i < 7; ++i) {
                    newKeys.append(',').append(keyArr[i]);
                }
            } else {
                newKeys.append(',').append(keys);
            }
            pageCache.put(KEY, newKeys.toString());
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> pageCache = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            ItemSaleControlUtil.addKey(pageCache, KEY + i);
        }
        System.out.println(pageCache);
    }

    private static void addKey(Map<String, String> pageCache, String valueKey) {
        String keys = pageCache.get(KEY);
        if (StringUtils.isEmpty((String)keys)) {
            pageCache.put(KEY, valueKey);
        } else {
            StringBuilder newKeys = new StringBuilder(valueKey);
            String[] keyArr = keys.split(",");
            if (keyArr.length >= 8) {
                for (int i = 0; i < 7; ++i) {
                    newKeys.append(',').append(keyArr[i]);
                }
            } else {
                newKeys.append(',').append(keys);
            }
            pageCache.put(KEY, newKeys.toString());
        }
    }

    private static QFilter autoGetItemFilter(Object authOwnerId, Object customerId) {
        if (authOwnerId == null) {
            return ItemSaleControlUtil.getItemFilter(customerId);
        }
        return ItemSaleControlUtil.getItemFilter(authOwnerId, customerId);
    }

    public static Set<Object> getAllCanSaleItemIds(Object customerId, QFilter extFilters, boolean isOverDeafultFilter) {
        return ItemSaleControlUtil.getAllCanSaleItemIds(null, customerId, extFilters, isOverDeafultFilter);
    }

    public static Set<Object> getAllCanSaleItemIds(Object authOwnerId, Object customerId, QFilter extFilters) {
        return ItemSaleControlUtil.getAllCanSaleItemIds(authOwnerId, customerId, extFilters, true);
    }

    public static Set<Object> getAllCanSaleItemIds(Object customerId, QFilter extFilters) {
        return ItemSaleControlUtil.getAllCanSaleItemIds(null, customerId, extFilters, true);
    }

    public static Set<Object> getAllCanSaleItemIdsByDefaultFilter(Object authOwnerId, Object customerId) {
        return ItemSaleControlUtil.getAllCanSaleItemIds(authOwnerId, customerId, null, false);
    }

    public static Set<Object> getAllCanSaleItemIdsByDefaultFilter(Object customerId) {
        return ItemSaleControlUtil.getAllCanSaleItemIds(null, customerId, null, false);
    }

    public static Set<Object> getAllCanSaleItemIds(Object authOwnerId, Object customerId, QFilter extFilters, boolean isOverDeafultFilter) {
        PathSaleInfo info = ItemSaleControlUtil.autoGetPathSaleInfo(authOwnerId, customerId);
        if (info == null) {
            return new HashSet<Object>();
        }
        QFilter fs = ItemSaleControlUtil.getDeafultFilter();
        if (isOverDeafultFilter) {
            fs = extFilters;
        } else if (extFilters != null) {
            fs.and(extFilters);
        }
        if (fs == null) {
            if (info.isLoadedItems()) {
                return new HashSet<Object>(info.getItems());
            }
            fs = new QFilter("owner", "in", info.getOwnerIds());
            Set<Object> combinationids = QueryUtil.querySingleCol("dpm_item_combination", "id", fs.toArray());
            fs = F7Utils.buildMultiF7QFitler("mulowner", info.getOwnerIds());
            combinationids.addAll(QueryUtil.querySingleCol("mdr_item_info", "id", fs.toArray()));
            return combinationids;
        }
        if (info.isLoadedItems()) {
            fs.and("id", "in", info.getItems());
            Set<Object> combinationids = QueryUtil.querySingleCol("dpm_item_combination", "id", fs.toArray());
            combinationids.addAll(QueryUtil.querySingleCol("mdr_item_info", "id", fs.toArray()));
            return combinationids;
        }
        Set<Object> combinationids = QueryUtil.querySingleCol("dpm_item_combination", "id", new QFilter("owner", "in", info.getOwnerIds()).and(fs).toArray());
        fs.and(F7Utils.buildMultiF7QFitler("mulowner", info.getOwnerIds()));
        combinationids.addAll(QueryUtil.querySingleCol("mdr_item_info", "id", fs.toArray()));
        return combinationids;
    }

    private static QFilter getDeafultFilter() {
        return new QFilter("isonsell", "=", (Object)"1").and("status", "=", (Object)"C");
    }

    private static PathSaleInfo autoGetPathSaleInfo(Object authOwnerId, Object customerId) {
        if (authOwnerId == null) {
            return ItemSaleControlUtil.getPathSaleInfo(customerId);
        }
        return ItemSaleControlUtil.getPathSaleInfo(authOwnerId, customerId);
    }

    public static QFilter getItemFilterByPathSaleInfo(PathSaleInfo saleInfo) {
        if (saleInfo == null) {
            return new QFilter("id", "=", (Object)0L);
        }
        if (saleInfo.isLoadedItems()) {
            return new QFilter("id", "in", saleInfo.getItems());
        }
        QFilter fs = ItemSaleControlUtil.getDeafultFilter();
        Set<Object> itemids = QueryUtil.querySingleCol("dpm_item_combination", "id", new QFilter("owner", "in", saleInfo.getOwnerIds()).and(fs).toArray());
        fs.and(F7Utils.buildMultiF7QFitler("mulowner", saleInfo.getOwnerIds()));
        itemids.addAll(QueryUtil.querySingleCol("mdr_item_info", "id", fs.toArray()));
        return new QFilter("id", "in", itemids);
    }

    public static PathSaleInfo getPathSaleInfo(Object customerId) {
        if (customerId == null) {
            return null;
        }
        ItemSaleInfo info = new ItemSaleInfo();
        PathSaleInfo result = info.querySaleRules(customerId);
        result.addCustomerItemIds(customerId);
        return result;
    }

    public static PathSaleInfo getPathSaleInfo(Object authOwnerId, Object customerId) {
        if (authOwnerId == null || customerId == null) {
            return null;
        }
        ItemSaleInfo info = new ItemSaleInfo();
        return info.querySaleRules(authOwnerId, customerId);
    }
}

