/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.matetype;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kd.drp.mdr.common.matetype.TypeCastException;

public class TypeCaseHelper {
    public static Object convert(Object obj, String type, String format) throws TypeCastException {
        Locale locale = new Locale("zh", "CN", "");
        if (obj == null) {
            return null;
        }
        if (obj.getClass().getName().equals(type)) {
            return obj;
        }
        if ("Object".equals(type) || "java.lang.Object".equals(type)) {
            return obj;
        }
        String fromType = null;
        if (obj instanceof String) {
            fromType = "String";
            String str = (String)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return obj;
            }
            if (str.length() == 0) {
                return null;
            }
            if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                Boolean value = null;
                value = str.equalsIgnoreCase("TRUE") || str.equals("1") ? Boolean.TRUE : Boolean.FALSE;
                return value;
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                try {
                    Number tempNum = TypeCaseHelper.getNf(locale).parse(str);
                    return new Double(tempNum.doubleValue());
                }
                catch (ParseException e) {
                    throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                try {
                    BigDecimal retBig = new BigDecimal(str);
                    int iscale = str.indexOf(46);
                    int keylen = str.length();
                    if (iscale > -1) {
                        iscale = keylen - (iscale + 1);
                        return retBig.setScale(iscale, 5);
                    }
                    return retBig.setScale(0, 5);
                }
                catch (Exception e) {
                    throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                try {
                    Number tempNum = TypeCaseHelper.getNf(locale).parse(str);
                    return new Float(tempNum.floatValue());
                }
                catch (ParseException e) {
                    throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                try {
                    NumberFormat nf = TypeCaseHelper.getNf(locale);
                    nf.setMaximumFractionDigits(0);
                    Number tempNum = nf.parse(str);
                    return tempNum.longValue();
                }
                catch (ParseException e) {
                    throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                try {
                    NumberFormat nf = TypeCaseHelper.getNf(locale);
                    nf.setMaximumFractionDigits(0);
                    Number tempNum = nf.parse(str);
                    return tempNum.intValue();
                }
                catch (ParseException e) {
                    throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                if (format == null || format.length() == 0) {
                    try {
                        return java.sql.Date.valueOf(str);
                    }
                    catch (Exception e) {
                        try {
                            DateFormat df = null;
                            df = DateFormat.getDateInstance(3, locale);
                            Date fieldDate = df.parse(str);
                            return new java.sql.Date(fieldDate.getTime());
                        }
                        catch (ParseException e1) {
                            throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                        }
                    }
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    Date fieldDate = sdf.parse(str);
                    return new java.sql.Date(fieldDate.getTime());
                }
                catch (ParseException e) {
                    throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                if (str.length() == 10) {
                    str = str + " 00:00:00";
                }
                if (format == null || format.length() == 0) {
                    try {
                        return Timestamp.valueOf(str);
                    }
                    catch (Exception e) {
                        try {
                            DateFormat df = null;
                            df = DateFormat.getDateTimeInstance(3, 3, locale);
                            Date fieldDate = df.parse(str);
                            return new Timestamp(fieldDate.getTime());
                        }
                        catch (ParseException e1) {
                            throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                        }
                    }
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    Date fieldDate = sdf.parse(str);
                    return new Timestamp(fieldDate.getTime());
                }
                catch (ParseException e) {
                    throw new TypeCastException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof BigDecimal) {
            fromType = "BigDecimal";
            BigDecimal bigD = (BigDecimal)obj;
            if ("String".equals(type)) {
                return TypeCaseHelper.getNf(locale).format(bigD.doubleValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return obj;
            }
            if ("Double".equals(type)) {
                return new Double(bigD.doubleValue());
            }
            if ("Float".equals(type)) {
                return new Float(bigD.floatValue());
            }
            if ("Long".equals(type)) {
                return Math.round(bigD.doubleValue());
            }
            if ("Integer".equals(type)) {
                return (int)Math.round(bigD.doubleValue());
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Double) {
            fromType = "Double";
            Double dbl = (Double)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return TypeCaseHelper.getNf(locale).format(dbl);
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return obj;
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return new Float(dbl.floatValue());
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return Math.round(dbl);
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return (int)Math.round(dbl);
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return new BigDecimal(dbl.toString());
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Float) {
            fromType = "Float";
            Float flt = (Float)obj;
            if ("String".equals(type)) {
                return TypeCaseHelper.getNf(locale).format(flt.doubleValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return BigDecimal.valueOf(flt.doubleValue());
            }
            if ("Double".equals(type)) {
                return new Double(flt.doubleValue());
            }
            if ("Float".equals(type)) {
                return obj;
            }
            if ("Long".equals(type)) {
                return Math.round(flt.doubleValue());
            }
            if ("Integer".equals(type)) {
                return (int)Math.round(flt.doubleValue());
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Long) {
            fromType = "Long";
            Long lng = (Long)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return TypeCaseHelper.getNf(locale).format(lng);
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return new Double(lng.doubleValue());
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return new Float(lng.floatValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                return new BigDecimal(lng.toString());
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return obj;
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return lng.intValue();
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Integer) {
            fromType = "Integer";
            Integer intgr = (Integer)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return TypeCaseHelper.getNf(locale).format(intgr.longValue());
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return new Double(intgr.doubleValue());
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return new Float(intgr.floatValue());
            }
            if ("BigDecimal".equals(type) || "java.math.BigDecimal".equals(type)) {
                String str = intgr.toString();
                BigDecimal retBig = BigDecimal.valueOf(intgr.doubleValue());
                int iscale = str.indexOf(46);
                int keylen = str.length();
                if (iscale > -1) {
                    iscale = keylen - (iscale + 1);
                    return retBig.setScale(iscale, 5);
                }
                return retBig.setScale(0, 5);
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return intgr.longValue();
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return obj;
            }
            if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                if (intgr == 0) {
                    return Boolean.FALSE;
                }
                if (intgr == 1) {
                    return Boolean.TRUE;
                }
            } else {
                throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
            }
        }
        if (obj instanceof java.sql.Date) {
            fromType = "Date";
            java.sql.Date dte = (java.sql.Date)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                if (format == null || format.length() == 0) {
                    return dte.toString();
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(new Date(dte.getTime()));
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                return obj;
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                return new Timestamp(dte.getTime());
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Timestamp) {
            fromType = "Timestamp";
            Timestamp tme = (Timestamp)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                if (format == null || format.length() == 0) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(tme);
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(new Date(tme.getTime()));
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                return new java.sql.Date(tme.getTime());
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                return new Time(tme.getTime());
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                return obj;
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Boolean) {
            fromType = "Boolean";
            Boolean bol = (Boolean)obj;
            if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return bol;
            }
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return bol.toString();
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                if (bol.booleanValue()) {
                    return 1;
                }
                return 0;
            }
            throw new TypeCastException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if ("String".equals(type) || "java.lang.String".equals(type)) {
            return obj.toString();
        }
        throw new TypeCastException("Conversion from " + obj.getClass().getName() + " to " + type + " not currently supported");
    }

    private static NumberFormat getNf(Locale locale) {
        NumberFormat nf = null;
        nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        nf.setGroupingUsed(false);
        return nf;
    }
}

