/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.message.json;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.drp.mdr.common.matetype.Dto;
import kd.drp.mdr.common.matetype.impl.BaseDto;
import kd.drp.mdr.common.message.json.JsonValueProcessorImpl;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import org.apache.log4j.Logger;

public class JsonHelper {
    private static Logger log = Logger.getLogger(JsonHelper.class);

    public static final String encodeObject2Json(Object pObject) {
        String jsonString = "[]";
        if (!JsonHelper.isEmpty(pObject)) {
            if (pObject instanceof List) {
                JSONArray jsonArray = JSONArray.fromObject((Object)pObject);
                jsonString = jsonArray.toString();
            } else {
                JSONObject jsonObject = JSONObject.fromObject((Object)pObject);
                jsonString = jsonObject.toString();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u5e8f\u5217\u5316\u540e\u7684JSON\u8d44\u6599\u8f93\u51fa:\n" + jsonString));
        }
        return jsonString;
    }

    public static final String encodeObject2Json(Object pObject, String pFormatString) {
        String jsonString = "[]";
        if (!JsonHelper.isEmpty(pObject)) {
            JsonConfig cfg = new JsonConfig();
            cfg.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new JsonValueProcessorImpl(pFormatString));
            cfg.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new JsonValueProcessorImpl(pFormatString));
            cfg.registerJsonValueProcessor(java.sql.Date.class, (JsonValueProcessor)new JsonValueProcessorImpl(pFormatString));
            if (pObject instanceof ArrayList) {
                JSONArray jsonArray = JSONArray.fromObject((Object)pObject, (JsonConfig)cfg);
                jsonString = jsonArray.toString();
            } else {
                JSONObject jsonObject = JSONObject.fromObject((Object)pObject, (JsonConfig)cfg);
                jsonString = jsonObject.toString();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u5e8f\u5217\u5316\u540e\u7684JSON\u8d44\u6599\u8f93\u51fa:\n" + jsonString));
        }
        return jsonString;
    }

    public static Dto parseSingleJson2Dto(String jsonString) {
        Dto dto = new BaseDto();
        if (JsonHelper.isEmpty(jsonString)) {
            return dto;
        }
        JSONObject jb = JSONObject.fromObject((Object)jsonString);
        dto = (Dto)JSONObject.toBean((JSONObject)jb, BaseDto.class);
        return dto;
    }

    public static List<Dto> parseJsonArray2ListDto(String jsonString) {
        ArrayList<Dto> list = new ArrayList<Dto>();
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        for (Object jsonObject : jsonArray) {
            Dto dto = JsonHelper.parseSingleJson2Dto(jsonObject.toString());
            list.add(dto);
        }
        return list;
    }

    public static List<Object> parseJsonArray2List(String jsonString) {
        ArrayList<Object> list = new ArrayList<Object>();
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        for (Object jsonObject : jsonArray) {
            list.add(jsonObject);
        }
        return list;
    }

    public static boolean isEmpty(Object pObj) {
        if (pObj == null) {
            return true;
        }
        if (pObj == "") {
            return true;
        }
        return pObj instanceof String ? ((String)pObj).length() == 0 : (pObj instanceof Collection ? ((Collection)pObj).size() == 0 : pObj instanceof Map && ((Map)pObj).size() == 0);
    }
}

