/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.message.send.model;

import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DBServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.message.send.model.AbstractSendMessageCallBack;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class SendMessageInfo {
    private long msgid;
    private String companyid;
    private String messageurl;
    private Timestamp gmtborn;
    private String type;
    private String data;
    private int sendtimes;
    private boolean isused;
    private String errormessage;
    private RequestContext rc;
    private volatile boolean isCompleted;
    private MessageResponse result;
    private ReentrantLock lock;
    private Condition notCompleted;
    private AbstractSendMessageCallBack callback;

    public SendMessageInfo() {
        this.msgid = DBServiceHelper.genGlobalLongId();
        this.gmtborn = new Timestamp(System.currentTimeMillis());
        this.sendtimes = 0;
        this.isused = false;
        this.lock = new ReentrantLock();
        this.notCompleted = this.lock.newCondition();
    }

    public SendMessageInfo(DynamicObject o, RequestContext rc) {
        this.msgid = o.getLong("id");
        this.gmtborn = new Timestamp(o.getDate("gmtborn").getTime());
        this.sendtimes = o.getInt("sendtimes");
        this.isused = o.getBoolean("isused");
        this.type = o.getString("type");
        this.data = o.getString("data");
        this.messageurl = o.getString("messageurl");
        this.lock = new ReentrantLock();
        this.notCompleted = this.lock.newCondition();
        this.setRc(rc);
    }

    public long getMsgid() {
        return this.msgid;
    }

    public void setMsgid(long msgid) {
        this.msgid = msgid;
    }

    public String getCompanyid() {
        return this.companyid;
    }

    public void setCompanyid(String companyid) {
        this.companyid = companyid;
    }

    public String getMessageurl() {
        return this.messageurl;
    }

    public void setMessageurl(String messageurl) {
        this.messageurl = messageurl;
    }

    public Timestamp getGmtborn() {
        return this.gmtborn;
    }

    public void setGmtborn(Timestamp gmtborn) {
        this.gmtborn = gmtborn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getSendtimes() {
        return this.sendtimes;
    }

    public void setSendtimes(int sendtimes) {
        this.sendtimes = sendtimes;
    }

    public boolean isIsused() {
        return this.isused;
    }

    public void setIsused(boolean isused) {
        this.isused = isused;
    }

    public String getErrormessage() {
        return this.errormessage;
    }

    public void setErrormessage(String errormessage) {
        this.errormessage = errormessage;
    }

    public String toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put((Object)"source", (Object)"WDH");
            if (StringUtils.isNotEmpty(this.msgid)) {
                json.put((Object)"msgid", (Object)this.msgid);
            }
            if (this.gmtborn != null) {
                json.put((Object)"gmtBorn", (Object)this.gmtborn.toString());
            }
            if (StringUtils.isNotEmpty(this.type)) {
                json.put((Object)"type", (Object)this.type);
            }
            if (StringUtils.isNotEmpty(this.data)) {
                json.put((Object)"data", (Object)this.data);
            }
        }
        catch (JSONException e) {
            return "";
        }
        return json.toString();
    }

    public MessageResponse getResult() throws InterruptedException {
        if (!this.isCompleted) {
            this.lock.lock();
            try {
                if (!this.notCompleted.await(300L, TimeUnit.SECONDS)) {
                    this.result = new MessageResponse("600", ResManager.loadKDString((String)"\u7b49\u5f85\u540c\u6b65\u6d88\u606f\u7ed3\u679c\u8d85\u65f6\uff01", (String)"SendMessageInfo_0", (String)"drp-mdr-common", (Object[])new Object[0]));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.result;
    }

    public void setResult(MessageResponse result) {
        this.lock.lock();
        try {
            this.result = result;
            this.isused = result.isSuccess();
            if (!this.isused) {
                this.setErrormessage(result.toString());
            }
            this.isCompleted = true;
            this.notCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public AbstractSendMessageCallBack getCallback() {
        return this.callback;
    }

    public void setCallback(AbstractSendMessageCallBack callback) {
        this.callback = callback;
    }

    public RequestContext getRc() {
        return this.rc;
    }

    public void setRc(RequestContext rc) {
        this.rc = rc;
    }
}

