/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.common.message.send.service;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import kd.bos.context.RequestContext;
import kd.bos.orm.util.StringUtils;
import kd.bos.threads.ThreadPools;
import kd.drp.mdr.common.message.send.MessageStoreService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.SendMessageInfo;
import kd.drp.mdr.common.message.send.service.MessageQueue;
import kd.drp.mdr.common.message.send.service.MessageSender;
import org.apache.log4j.Logger;

public class MessageManager {
    private static Logger log = Logger.getLogger(MessageManager.class);
    private MessageQueue messageQueue;
    private static ExecutorService executor;
    private Thread sendThread;

    public static MessageManager getInstance() {
        return ManagerInstance.messageMgr;
    }

    public void setMessageQueue(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    private MessageManager() {
        executor = ThreadPools.newExecutorService((String)"sendMessageToEAS", (int)20);
        this.sendThread = new Thread(){

            @Override
            public void run() {
                MessageManager.this.doSend();
            }
        };
    }

    public void send(SendMessageInfo msg) {
        if (msg != null) {
            log.info((Object)("send:" + msg));
            if (this.messageQueue == null) {
                this.messageQueue = MessageQueue.getInstance();
                this.messageQueue.init();
                this.sendThread.start();
            }
            this.messageQueue.put(msg);
        }
    }

    private void doSend() {
        SendMessageInfo msg = null;
        do {
            msg = this.messageQueue.get();
            log.info((Object)("doSend:" + msg));
            if (StringUtils.isEmpty((Object)msg.getMessageurl())) continue;
            executor.execute(new MessageSendTask(msg));
        } while (msg != null);
    }

    public void start() {
        this.sendThread.start();
    }

    public void stop() {
        executor.shutdown();
    }

    class MessageSendTask
    implements Runnable {
        private final SendMessageInfo msg;
        private final FutureTask<MessageResponse> future;

        public MessageSendTask(final SendMessageInfo msg) {
            this.msg = msg;
            Callable<MessageResponse> callable = new Callable<MessageResponse>(){

                @Override
                public MessageResponse call() throws Exception {
                    return MessageSendTask.this.innerSend(1);
                }
            };
            this.future = new FutureTask<MessageResponse>((Callable)callable){

                @Override
                protected void done() {
                    RequestContext.set((RequestContext)msg.getRc());
                    MessageResponse result = new MessageResponse();
                    try {
                        result = (MessageResponse)this.get();
                        StringBuilder builder = new StringBuilder();
                        log.info((Object)builder.append("\u54cd\u5e94\u7ed3\u679c\u662f\uff1a").append(result));
                    }
                    catch (InterruptedException e) {
                        result.setErrorCode("403");
                        result.setErrorMessage("Get MessageSendTask result InterruptedException: " + e.getMessage());
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        result.setErrorCode("404");
                        result.setErrorMessage("Get MessageSendTask result ExecutionException: " + e.getMessage());
                    }
                    finally {
                        if (msg.getCallback() != null) {
                            msg.getCallback().doaftersend(msg, result);
                        }
                        MessageSendTask.this.doUpdateMessage(result);
                    }
                }
            };
        }

        private MessageResponse innerSend(int retryTimes) {
            MessageResponse result = null;
            int waitTime = 0;
            for (int i = 0; i < retryTimes; ++i) {
                if (i == 1) {
                    waitTime = 30000;
                } else if (i == 2) {
                    waitTime = 120000;
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.msg.setSendtimes(i + 1);
                result = MessageSender.sendMessage(this.msg);
                this.msg.setResult(result);
                if (!result.isSuccess()) continue;
                return result;
            }
            return result;
        }

        private void doUpdateMessage(MessageResponse result) {
            MessageStoreService.updateMessage(this.msg);
        }

        @Override
        public void run() {
            this.future.run();
        }
    }

    private static class ManagerInstance {
        private static MessageManager messageMgr = new MessageManager();

        private ManagerInstance() {
        }
    }
}

